# NamingSystem version - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NamingSystem version**

## Extension: NamingSystem version 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/StructureDefinition/ext-namingsystem-version | *Version*:0.0.34 |
| Active as of 2025-11-13 | *Computable Name*:NamingSystemVersion |

The business version associated with the Naming System

**Context of Use**

**Usage info**

**Usages:**

* This Extension is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.terminology|current/StructureDefinition/ext-namingsystem-version)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ext-namingsystem-version.csv), [Excel](StructureDefinition-ext-namingsystem-version.xlsx), [Schematron](StructureDefinition-ext-namingsystem-version.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ext-namingsystem-version",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    }
  ],
  "url" : "http://terminology.hl7.org/StructureDefinition/ext-namingsystem-version",
  "version" : "0.0.34",
  "name" : "NamingSystemVersion",
  "title" : "NamingSystem version",
  "status" : "active",
  "date" : "2025-11-13T08:03:09+00:00",
  "description" : "The business version associated with the Naming System",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "NamingSystem"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "NamingSystem version",
        "definition" : "The business version associated with the Naming System",
        "max" : "1"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "type" : [
          {
            "code" : "uri"
          }
        ],
        "fixedUri" : "http://terminology.hl7.org/StructureDefinition/ext-namingsystem-version"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
