# RxNorm - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **RxNorm**

## NamingSystem: RxNorm 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/v3-rxNorm | *Version*:3.0.0 | |
| Active as of 2020-11-03 | *Responsible:*National Library of Medicine (NLM) | *Computable Name*:RxNorm |
| **Copyright/Legal**: Using RxNorm codes of type SAB=RXNORM as this specification describes does not require a UMLS license. Access to the full set of RxNorm definitions, and/or additional use of other RxNorm structures and information requires a UMLS license. The use of RxNorm in this specification is pursuant to HL7's status as a licensee of the NLM UMLS. HL7's license does not convey the right to use RxNorm to any users of this specification; implementers must acquire a license to use RxNorm in their own right. | | |

 
RxNorm provides normalized names for clinical drugs and links its names to many of the drug vocabularies commonly used in pharmacy management and drug interaction software, including those of First Databank, Micromedex, and Gold Standard Drug Database. By providing links between these vocabularies, RxNorm can mediate messages between systems not using the same software and vocabulary. RxNorm now includes the United States Pharmacopeia (USP) Compendial Nomenclature from the United States Pharmacopeial Convention. USP is a cumulative data set of all Active Pharmaceutical Ingredients (API). 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/v3-rxNorm |
| Version | 3.0.0 |
| Name | RxNorm |
| Title | RxNorm |
| Status | active |
| Definition | RxNorm provides normalized names for clinical drugs and links its names to many of the drug vocabularies commonly used in pharmacy management and drug interaction software, including those of First Databank, Micromedex, and Gold Standard Drug Database. By providing links between these vocabularies, RxNorm can mediate messages between systems not using the same software and vocabulary. RxNorm now includes the United States Pharmacopeia (USP) Compendial Nomenclature from the United States Pharmacopeial Convention. USP is a cumulative data set of all Active Pharmaceutical Ingredients (API). |
| Publisher | National Library of Medicine (NLM) |
| Copyright | Using RxNorm codes of type SAB=RXNORM as this specification describes does not require a UMLS license. Access to the full set of RxNorm definitions, and/or additional use of other RxNorm structures and information requires a UMLS license. The use of RxNorm in this specification is pursuant to HL7's status as a licensee of the NLM UMLS. HL7's license does not convey the right to use RxNorm to any users of this specification; implementers must acquire a license to use RxNorm in their own right. |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.88
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://www.nlm.nih.gov/research/umls/rxnorm
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "v3-rxNorm",
  "url" : "http://terminology.hl7.org/NamingSystem/v3-rxNorm",
  "version" : "3.0.0",
  "name" : "RxNorm",
  "title" : "RxNorm",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2020-11-03",
  "publisher" : "National Library of Medicine (NLM)",
  "contact" : [
    {
      "name" : "National Library of Medicine (NLM)",
      "telecom" : [
        {
          "system" : "email",
          "value" : "rxnorminfo@nlm.nih.gov"
        }
      ]
    }
  ],
  "responsible" : "National Library of Medicine (NLM)",
  "description" : "RxNorm provides normalized names for clinical drugs and links its names to many of the drug vocabularies commonly used in pharmacy management and drug interaction software, including those of First Databank, Micromedex, and Gold Standard Drug Database. By providing links between these vocabularies, RxNorm can mediate messages between systems not using the same software and vocabulary. RxNorm now includes the United States Pharmacopeia (USP) Compendial Nomenclature from the United States Pharmacopeial Convention. USP is a cumulative data set of all Active Pharmaceutical Ingredients (API).",
  "copyright" : "Using RxNorm codes of type SAB=RXNORM as this specification describes does not require  a UMLS license. Access to the full set of RxNorm definitions, and/or additional use of other RxNorm structures and information requires a UMLS license. The use of RxNorm in this specification is pursuant to HL7's status as a licensee of the NLM UMLS. HL7's license does not convey the right to use RxNorm to any users of this specification; implementers must acquire a license to use RxNorm in their own right.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.88",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://www.nlm.nih.gov/research/umls/rxnorm",
      "preferred" : true
    }
  ]
}

```
