# Healthcare Provider Taxonomy HIPAA - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Healthcare Provider Taxonomy HIPAA**

## NamingSystem: Healthcare Provider Taxonomy HIPAA 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/v3-HealthcareProviderTaxonomyHIPAA | *Version*:2.0.0 |
| Retired as of 2021-11-09 | *Computable Name*:HealthcareProviderTaxonomyHIPAA |

 
This HL7 Version 3 code system stub was created many years ago for the convenience of the HL7 community using the RIM; it has been determined that there is licensure issue with the republishing of the content for this code system by HL7, as well as erroneous and incomplete content. Content should be accessed using the links at nucc.org 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/v3-HealthcareProviderTaxonomyHIPAA |
| Version | 2.0.0 |
| Name | HealthcareProviderTaxonomyHIPAA |
| Title | Healthcare Provider Taxonomy HIPAA |
| Status | retired |
| Definition | This HL7 Version 3 code system stub was created many years ago for the convenience of the HL7 community using the RIM; it has been determined that there is licensure issue with the republishing of the content for this code system by HL7, as well as erroneous and incomplete content. Content should be accessed using the links at nucc.org |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.101
  * **Preferred**: true
  * **Comment**: 
* **Type**: URI
  * **Value**: http://nucc.org/provider-taxonomy
  * **Preferred**: true
  * **Comment**: 
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/v3-HealthcareProviderTaxonomyHIPAA
  * **Preferred**: false
  * **Comment**: Published for many years in HL7 Standards with this name, but has now been corrected to refer to the IP owner. Retained here for backwards-compatibility and reference. Content removed as of the July 2016 v3 harmonization meeting.

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "v3-HealthcareProviderTaxonomyHIPAA",
  "url" : "http://terminology.hl7.org/NamingSystem/v3-HealthcareProviderTaxonomyHIPAA",
  "version" : "2.0.0",
  "name" : "HealthcareProviderTaxonomyHIPAA",
  "title" : "Healthcare Provider Taxonomy HIPAA",
  "status" : "retired",
  "kind" : "codesystem",
  "date" : "2021-11-09T10:00:00+10:00",
  "description" : "This HL7 Version 3 code system stub was created many years ago for the convenience of the HL7 community using the RIM; it has been determined that there is licensure issue with the republishing of the content for this code system by HL7, as well as erroneous and incomplete content.  Content should be accessed using the links at nucc.org",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.101",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://nucc.org/provider-taxonomy",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/v3-HealthcareProviderTaxonomyHIPAA",
      "preferred" : false,
      "comment" : "Published for many years in HL7 Standards with this name, but has now been corrected to refer to the IP owner.   Retained here for backwards-compatibility and reference.  Content removed as of the July 2016 v3 harmonization meeting."
    }
  ]
}

```
