# DICOM Controlled Terminology - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **DICOM Controlled Terminology**

## NamingSystem: DICOM Controlled Terminology 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/v3-DCM | *Version*:3.0.0 | |
| Active as of 2020-09-03 | *Responsible:*DICOM | *Computable Name*:DCM |

 
Coded concepts defined in PS 3.16 Digital Imaging and Communications in Medicine (DICOM): Part 16: Content Mapping Resource, Annex D: DICOM Controlled Terminology Definition 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/v3-DCM |
| Version | 3.0.0 |
| Name | DCM |
| Title | DICOM Controlled Terminology |
| Status | active |
| Definition | Coded concepts defined in PS 3.16 Digital Imaging and Communications in Medicine (DICOM): Part 16: Content Mapping Resource, Annex D: DICOM Controlled Terminology Definition |
| Publisher | DICOM |

### Identifiers

* **Type**: OID
  * **Value**: 1.2.840.10008.2.16.4
  * **Preferred**: true
  * **Period**: 
* **Type**: URI
  * **Value**: http://dicom.nema.org/resources/ontology/DCM
  * **Preferred**: true
  * **Period**: 2020-09-03 15:32:00-0400 --> (ongoing)
* **Type**: URI
  * **Value**: http://dicom.nema.org/medical/dicom
  * **Preferred**: false
  * **Period**: (?) --> 2020-09-03 15:32:00-0400

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "v3-DCM",
  "url" : "http://terminology.hl7.org/NamingSystem/v3-DCM",
  "version" : "3.0.0",
  "name" : "DCM",
  "title" : "DICOM Controlled Terminology",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2020-09-03T00:00:00-04:00",
  "publisher" : "DICOM",
  "contact" : [
    {
      "name" : "DICOM Standards Committee"
    }
  ],
  "responsible" : "DICOM",
  "description" : "Coded concepts defined in PS 3.16 Digital Imaging and Communications in Medicine (DICOM): Part 16: Content Mapping Resource, Annex D: DICOM Controlled Terminology Definition",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "1.2.840.10008.2.16.4",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://dicom.nema.org/resources/ontology/DCM",
      "preferred" : true,
      "period" : {
        "start" : "2020-09-03T15:32:00-04:00"
      }
    },
    {
      "type" : "uri",
      "value" : "http://dicom.nema.org/medical/dicom",
      "preferred" : false,
      "period" : {
        "end" : "2020-09-03T15:32:00-04:00"
      }
    }
  ]
}

```
