# US Census Bureau - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Census Bureau**

## NamingSystem: US Census Bureau 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/sic | *Version*:2.1.0 | |
| Active as of 2019-03-20 | *Responsible:*US Government | *Computable Name*:Sic |

 
The Standard Industrial Classification Codes that appear in a company's disseminated EDGAR filings indicate the company's type of business. These codes are also used in the Division of Corporation Finance as a basis for assigning review responsibility for the company's filings. For example, a company whose business was Metal Mining (SIC 1000) would have its filings reviewed by staffers in A/D Office 4. Note that this code system is published both by the US Bureau of Labor Statistics (BLS) at http://www.sec.gov/info/edgar/siccodes.htm, and by the US Occupational & Safety Health Administration (OSHA) at http://www.osha.gov/pls/imis/sic_manual.html. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/sic |
| Version | 2.1.0 |
| Name | Sic |
| Title | US Census Bureau |
| Status | active |
| Definition | The Standard Industrial Classification Codes that appear in a company's disseminated EDGAR filings indicate the company's type of business. These codes are also used in the Division of Corporation Finance as a basis for assigning review responsibility for the company's filings. For example, a company whose business was Metal Mining (SIC 1000) would have its filings reviewed by staffers in A/D Office 4. Note that this code system is published both by the US Bureau of Labor Statistics (BLS) at http://www.sec.gov/info/edgar/siccodes.htm, and by the US Occupational & Safety Health Administration (OSHA) at http://www.osha.gov/pls/imis/sic_manual.html. |
| Publisher | US Government |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.232
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/sic
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "sic",
  "url" : "http://terminology.hl7.org/NamingSystem/sic",
  "version" : "2.1.0",
  "name" : "Sic",
  "title" : "US Census Bureau",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2019-03-20T00:00:00-04:00",
  "publisher" : "US Government",
  "contact" : [
    {
      "name" : "US Census Bureau"
    }
  ],
  "responsible" : "US Government",
  "description" : "The Standard Industrial Classification Codes that appear in a company's disseminated EDGAR filings indicate the company's type of business. These codes are also used in the Division of Corporation Finance as a basis for assigning review responsibility for the company's filings. For example, a company whose business was Metal Mining (SIC 1000) would have its filings reviewed by staffers in A/D Office 4. Note that this code system is published both by the US Bureau of Labor Statistics (BLS) at http://www.sec.gov/info/edgar/siccodes.htm, and by the US Occupational & Safety Health Administration (OSHA) at http://www.osha.gov/pls/imis/sic\\_manual.html.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.232",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/sic",
      "preferred" : true
    }
  ]
}

```
