# Passport Numbers Namespace for NIUE - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Passport Numbers Namespace for NIUE**

## NamingSystem: Passport Numbers Namespace for NIUE 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/passportNumNS-NIU | *Version*:1.0.0 |
| Active as of 2022-02-07 | *Computable Name*:PassportNumNS_NIU |

 
Identifier of the namespace for Passport Numbers issued by the country of NIUE. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/passportNumNS-NIU |
| Version | 1.0.0 |
| Name | PassportNumNS_NIU |
| Title | Passport Numbers Namespace for NIUE |
| Status | active |
| Definition | Identifier of the namespace for Passport Numbers issued by the country of NIUE. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.4.330.570
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://hl7.org/fhir/sid/passport-NIU
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "passportNumNS-NIU",
  "url" : "http://terminology.hl7.org/NamingSystem/passportNumNS-NIU",
  "version" : "1.0.0",
  "name" : "PassportNumNS_NIU",
  "title" : "Passport Numbers Namespace for NIUE",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2022-02-07T00:00:00-00:00",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
        "code" : "PPN"
      }
    ]
  },
  "description" : "Identifier of the namespace for Passport Numbers issued by the country of NIUE.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.4.330.570",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/sid/passport-NIU",
      "preferred" : true
    }
  ]
}

```
