# Passport Numbers Namespace for BELIZE - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Passport Numbers Namespace for BELIZE**

## NamingSystem: Passport Numbers Namespace for BELIZE 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/passportNumNS-BLZ | *Version*:1.0.0 |
| Active as of 2022-02-07 | *Computable Name*:PassportNumNS_BLZ |

 
Identifier of the namespace for Passport Numbers issued by the country of BELIZE. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/passportNumNS-BLZ |
| Version | 1.0.0 |
| Name | PassportNumNS_BLZ |
| Title | Passport Numbers Namespace for BELIZE |
| Status | active |
| Definition | Identifier of the namespace for Passport Numbers issued by the country of BELIZE. Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.4.330.84
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://hl7.org/fhir/sid/passport-BLZ
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "passportNumNS-BLZ",
  "url" : "http://terminology.hl7.org/NamingSystem/passportNumNS-BLZ",
  "version" : "1.0.0",
  "name" : "PassportNumNS_BLZ",
  "title" : "Passport Numbers Namespace for BELIZE",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2022-02-07T00:00:00-00:00",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
        "code" : "PPN"
      }
    ]
  },
  "description" : "Identifier of the namespace for Passport Numbers issued by the country of BELIZE.  Used for the HL7 v3 data type II.root and FHIR Identifer.system values for Passport Numbers",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.4.330.84",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/sid/passport-BLZ",
      "preferred" : true
    }
  ]
}

```
