# Nursing Intervention Classification - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Nursing Intervention Classification**

## NamingSystem: Nursing Intervention Classification 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/nic | *Version*:3.1.0 |
| Active as of 2019-03-20 | *Computable Name*:Nic |

 
The Nursing Interventions Classification (NIC) is a standardized classification developed by a research team at the University of Iowa. The purpose of NIC is to define interventions that nurses do on behalf of patients in all care domains. An intervention is defined as 'any treatment, based upon clinical judgment and knowledge, a nurse performs to enhance patient/client outcomes.' NIC is updated a five-year cycle. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/nic |
| Version | 3.1.0 |
| Name | Nic |
| Title | Nursing Intervention Classification |
| Status | active |
| Definition | The Nursing Interventions Classification (NIC) is a standardized classification developed by a research team at the University of Iowa. The purpose of NIC is to define interventions that nurses do on behalf of patients in all care domains. An intervention is defined as 'any treatment, based upon clinical judgment and knowledge, a nurse performs to enhance patient/client outcomes.' NIC is updated a five-year cycle. |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.15
  * **Preferred**: true
  * **Comment**: 
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/nic
  * **Preferred**: false
  * **Comment**: Original pro-forma v3 URL; replaced with canonical URL.
* **Type**: URI
  * **Value**: https://nursing.uiowa.edu/cncce/nursing-interventions-classification-overview
  * **Preferred**: true
  * **Comment**: Official canonical URL as validated with termminology owner.

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "nic",
  "url" : "http://terminology.hl7.org/NamingSystem/nic",
  "version" : "3.1.0",
  "name" : "Nic",
  "title" : "Nursing Intervention Classification",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2019-03-20T00:00:00-04:00",
  "description" : "The Nursing Interventions Classification (NIC) is a standardized classification developed by a research team at the University of Iowa. The purpose of NIC is to define interventions that nurses do on behalf of patients in all care domains. An intervention is defined as 'any treatment, based upon clinical judgment and knowledge, a nurse performs to enhance patient/client outcomes.' NIC is updated a five-year cycle.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.15",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/nic",
      "preferred" : false,
      "comment" : "Original pro-forma v3 URL; replaced with canonical URL."
    },
    {
      "type" : "uri",
      "value" : "https://nursing.uiowa.edu/cncce/nursing-interventions-classification-overview",
      "preferred" : true,
      "comment" : "Official canonical URL as validated with termminology owner."
    }
  ]
}

```
