# Internationalized Resource Identifier (IRI) - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Internationalized Resource Identifier (IRI)**

## NamingSystem: Internationalized Resource Identifier (IRI) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/iri | *Version*:1.0.0 |
| Active as of 2023-03-16 | *Computable Name*:IRI |

 
As defined by RFC 3987 (http://www.ietf.org/rfc/rfc3987.txt). Internationalized Resource Identifiers (IRIs) are the internationalized version of URIs (which are also defined as a NamingSystem as https://terminology.hl7.org/4.0.0/NamingSystem-uri.html) that allow Unicode characters to be used in the identifier with some restrictions, which was defined by the Internet Engineering Task Force (IETF) in 2005. An IRI such as 'https://hi.wikipedia.org/wiki/हृदय' can be percent-encoded into the URI 'https://hi.wikipedia.org/wiki/%E0%A4%B9%E0%A5%83%E0%A4%A6%E0%A4%AF' to be used as a URL, but the IRI is easier to read, particularly for readers of non-Latin languages, and is natively supported by many tools, including many browsers, HTTP libraries, and in the Resource Description Framework (RDF). 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/iri |
| Version | 1.0.0 |
| Name | IRI |
| Title | Internationalized Resource Identifier (IRI) |
| Status | active |
| Definition | As defined by RFC 3987 (http://www.ietf.org/rfc/rfc3987.txt). Internationalized Resource Identifiers (IRIs) are the internationalized version of URIs (which are also defined as a NamingSystem as https://terminology.hl7.org/4.0.0/NamingSystem-uri.html) that allow Unicode characters to be used in the identifier with some restrictions, which was defined by the Internet Engineering Task Force (IETF) in 2005. An IRI such as 'https://hi.wikipedia.org/wiki/हृदय' can be percent-encoded into the URI 'https://hi.wikipedia.org/wiki/%E0%A4%B9%E0%A5%83%E0%A4%A6%E0%A4%AF' to be used as a URL, but the IRI is easier to read, particularly for readers of non-Latin languages, and is natively supported by many tools, including many browsers, HTTP libraries, and in the Resource Description Framework (RDF). |

### Identifiers

* **Type**: URI
  * **Value**: urn:ietf:rfc:3987
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "iri",
  "url" : "http://terminology.hl7.org/NamingSystem/iri",
  "version" : "1.0.0",
  "name" : "IRI",
  "title" : "Internationalized Resource Identifier (IRI)",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2023-03-16T00:00:00-00:00",
  "description" : "As defined by RFC 3987 (http://www.ietf.org/rfc/rfc3987.txt). Internationalized Resource Identifiers (IRIs) are the internationalized version of URIs (which are also defined as a NamingSystem as https://terminology.hl7.org/4.0.0/NamingSystem-uri.html) that allow Unicode characters to be used in the identifier with some restrictions, which was defined by the Internet Engineering Task Force (IETF) in 2005. An IRI such as 'https://hi.wikipedia.org/wiki/हृदय' can be percent-encoded into the URI 'https://hi.wikipedia.org/wiki/%E0%A4%B9%E0%A5%83%E0%A4%A6%E0%A4%AF' to be used as a URL, but the IRI is easier to read, particularly for readers of non-Latin languages, and is natively supported by many tools, including many browsers, HTTP libraries, and in the Resource Description Framework (RDF).",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "urn:ietf:rfc:3987",
      "preferred" : true
    }
  ]
}

```
