# Insurance Benefit Type - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Insurance Benefit Type**

## NamingSystem: Insurance Benefit Type 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/insurance-benefit-type | *Version*:1.0.0 | | |
| Draft as of 2025-11-13 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:InsuranceBenefitType |

 
This code system defines a set of codes for Insurance Benefit Type. This code system is being developed in the National Directory of Healthcare Providers & Services (NDH) Implementation Guide until it is mature enough to be moved to THO. The code system can be viewed in the IG here:[https://build.fhir.org/ig/HL7/fhir-us-ndh/CodeSystem-NdhPayerCharacteristicsCS.html](https://build.fhir.org/ig/HL7/fhir-us-ndh/CodeSystem-NdhPayerCharacteristicsCS.html) 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/insurance-benefit-type |
| Version | 1.0.0 |
| Name | InsuranceBenefitType |
| Title | Insurance Benefit Type |
| Status | draft |
| Definition | This code system defines a set of codes for Insurance Benefit Type. This code system is being developed in the National Directory of Healthcare Providers & Services (NDH) Implementation Guide until it is mature enough to be moved to THO. The code system can be viewed in the IG here: [https://build.fhir.org/ig/HL7/fhir-us-ndh/CodeSystem-NdhPayerCharacteristicsCS.html](https://build.fhir.org/ig/HL7/fhir-us-ndh/CodeSystem-NdhPayerCharacteristicsCS.html) |
| Publisher | Health Level Seven International |
| Committee | [Patient Administration](CodeSystem-hl7-work-group.md#hl7-work-group-pa) |

### Identifiers

* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/insurance-benefit-type
  * **Preferred**: true
  * **Period**: 2024-09-18 --> (ongoing)
  * **Comment**: This code system defines a set of codes for Insurance Benefit Type.



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "insurance-benefit-type",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/NamingSystem/insurance-benefit-type",
  "version" : "1.0.0",
  "name" : "InsuranceBenefitType",
  "title" : "Insurance Benefit Type",
  "status" : "draft",
  "kind" : "codesystem",
  "experimental" : false,
  "date" : "2025-11-13T08:03:09+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This code system defines a set of codes for Insurance Benefit Type. This code system is being developed in the National Directory of Healthcare Providers & Services (NDH) Implementation Guide until it is mature enough to be moved to THO. The code system can be viewed in the IG here:  [https://build.fhir.org/ig/HL7/fhir-us-ndh/CodeSystem-NdhPayerCharacteristicsCS.html](https://build.fhir.org/ig/HL7/fhir-us-ndh/CodeSystem-NdhPayerCharacteristicsCS.html)",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/insurance-benefit-type",
      "preferred" : true,
      "comment" : "This code system defines a set of codes for Insurance Benefit Type.",
      "period" : {
        "start" : "2024-09-18"
      }
    }
  ]
}

```
