# International Classification for Nursing Practice - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **International Classification for Nursing Practice**

## NamingSystem: International Classification for Nursing Practice 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/icnp | *Version*:2.1.0 | |
| Active as of 2019-03-20 | *Responsible:*ICN | *Computable Name*:Icnp |

 
ICNP(r) is a combinatorial terminology, using a multi-axial structure. ICNP(r) provides standardized terms and codes for terms in two classifications that can be used to compose or create pre-coordinated concepts to represent observations and procedures, specifically, patient problems/nursing diagnoses, nursing interventions including those focused on assessment and actual or expected (goal) outcomes. The ICNP(r) Classification for Nursing Phenomena is used to compose concepts or statements to represent observations (nursing diagnoses, patient problems, patient status, patient outcomes). The ICNP(r) Nursing Actions Classification is used to compose concepts or statements to represent procedures (nursing interventions) 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/icnp |
| Version | 2.1.0 |
| Name | Icnp |
| Title | International Classification for Nursing Practice |
| Status | active |
| Definition | ICNP(r) is a combinatorial terminology, using a multi-axial structure. ICNP(r) provides standardized terms and codes for terms in two classifications that can be used to compose or create pre-coordinated concepts to represent observations and procedures, specifically, patient problems/nursing diagnoses, nursing interventions including those focused on assessment and actual or expected (goal) outcomes. The ICNP(r) Classification for Nursing Phenomena is used to compose concepts or statements to represent observations (nursing diagnoses, patient problems, patient status, patient outcomes). The ICNP(r) Nursing Actions Classification is used to compose concepts or statements to represent procedures (nursing interventions) |
| Publisher | ICN |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.97
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/icnp
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "icnp",
  "url" : "http://terminology.hl7.org/NamingSystem/icnp",
  "version" : "2.1.0",
  "name" : "Icnp",
  "title" : "International Classification for Nursing Practice",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2019-03-20T00:00:00-04:00",
  "publisher" : "ICN",
  "contact" : [
    {
      "name" : "International Council of Nurses (ICN)"
    }
  ],
  "responsible" : "ICN",
  "description" : "ICNP(r) is a combinatorial terminology, using a multi-axial structure. ICNP(r) provides standardized terms and codes for terms in two classifications that can be used to compose or create pre-coordinated concepts to represent observations and procedures, specifically, patient problems/nursing diagnoses, nursing interventions including those focused on assessment and actual or expected (goal) outcomes. The ICNP(r) Classification for Nursing Phenomena is used to compose concepts or statements to represent observations (nursing diagnoses, patient problems, patient status, patient outcomes). The ICNP(r) Nursing Actions Classification is used to compose concepts or statements to represent procedures (nursing interventions)",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.97",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/icnp",
      "preferred" : true
    }
  ]
}

```
