# Canadian DiagnosisCodes ICD-10-CA - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Canadian DiagnosisCodes ICD-10-CA**

## NamingSystem: Canadian DiagnosisCodes ICD-10-CA 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/icd10-CA | *Version*:2.1.0 | |
| Active as of 2019-03-20 | *Responsible:*Canadian Institute for Health Information | *Computable Name*:ICD10CA |

 
ICD-10-CA (International Statistical Classification of Diseases and Related Health Problems, 10th Revision, Canada) was developed by the World Health Organization (WHO) and enhanced by CIHI to meet Canadian morbidity data needs. ICD-10-CA classifies diseases, injuries and causes of death, as well as external causes of injury and poisoning. It also includes conditions and situations that are not diseases but represent risk factors to health, such as occupational and environmental factors, lifestyle and psychosocial circumstances. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/icd10-CA |
| Version | 2.1.0 |
| Name | ICD10CA |
| Title | Canadian DiagnosisCodes ICD-10-CA |
| Status | active |
| Definition | ICD-10-CA (International Statistical Classification of Diseases and Related Health Problems, 10th Revision, Canada) was developed by the World Health Organization (WHO) and enhanced by CIHI to meet Canadian morbidity data needs. ICD-10-CA classifies diseases, injuries and causes of death, as well as external causes of injury and poisoning. It also includes conditions and situations that are not diseases but represent risk factors to health, such as occupational and environmental factors, lifestyle and psychosocial circumstances. |
| Publisher | Canadian Institute for Health Information |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.94
  * **Preferred**: true
  * **Period**: 
* **Type**: URI
  * **Value**: http://hl7.org/fhir/sid/icd-10-ca
  * **Preferred**: true
  * **Period**: 2020-09-24 --> (ongoing)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "icd10-CA",
  "url" : "http://terminology.hl7.org/NamingSystem/icd10-CA",
  "version" : "2.1.0",
  "name" : "ICD10CA",
  "title" : "Canadian DiagnosisCodes ICD-10-CA",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2019-03-20T00:00:00-04:00",
  "publisher" : "Canadian Institute for Health Information",
  "contact" : [
    {
      "name" : "Canadian Institute for Health Information"
    }
  ],
  "responsible" : "Canadian Institute for Health Information",
  "description" : "ICD-10-CA (International Statistical Classification of Diseases and Related Health Problems, 10th Revision, Canada) was developed by the World Health Organization (WHO) and enhanced by CIHI to meet Canadian morbidity data needs. ICD-10-CA classifies diseases, injuries and causes of death, as well as external causes of injury and poisoning. It also includes conditions and situations that are not diseases but represent risk factors to health, such as occupational and environmental factors, lifestyle and psychosocial circumstances.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.94",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/sid/icd-10-ca",
      "preferred" : true,
      "period" : {
        "start" : "2020-09-24"
      }
    }
  ]
}

```
