# The Health Care Payment Learning and Action Network (HCPLAN) Alternative Payment Model (APM) Framework Categories - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **The Health Care Payment Learning and Action Network (HCPLAN) Alternative Payment Model (APM) Framework Categories**

## NamingSystem: The Health Care Payment Learning and Action Network (HCPLAN) Alternative Payment Model (APM) Framework Categories 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/hcp-lan-apm-framework | *Version*:1.0.0 | |
| Active as of 2024-03-04 | *Responsible:*[The Health Care Payment Learning and Action Network](https://hcp-lan.org/) | *Computable Name*:LAN_APM_Framework |
| **Copyright/Legal**: "The LAN APM Framework White Payer and the APM Framework categories defined in the white paper are in the public domain and are free to use without restriction. | | |

 
"The Health Care Payment Learning and Action Network (HCPLAN or LAN)[https://hcp-lan.org/](https://hcp-lan.org/)is a public-private partnership established in 2015 by the US Department of Health and Human Services (HHS) to accelerate the transition to value-based payment models in the US healthcare system." 
"The Framework represents payments from public and private payers to provider organizations (including payments between the payment and delivery arms of highly integrated health systems). It is designed to accommodate payments in multiple categories that are made by a single payer, as well as single provider organizations that receive payments in different categories—potentially from the same payer." 
"Since the original APM Framework White Paper was released in January 2016, it has become the foundation for implementing APMs and evaluating progress toward health care payment reform. Payers, providers, and purchasers have all used the APM Framework to better understand the payment reform landscape and to set goals for participation in APMs, and health care stakeholders have used the APM Framework to identify common goals for transforming the nation’s health care system. Overall, the APM Framework’s classification system has been adopted by the health care ecosystem." 
"The LAN APM Framework represents a continuum of payment approaches across four Categories." 
Initial version of the APM Framework White Paper was published in 2016. The updated version of the White Paper was published in 2017. 
For more information, please see[https://hcp-lan.org/workproducts/apm-refresh-whitepaper-final.pdf](https://hcp-lan.org/workproducts/apm-refresh-whitepaper-final.pdf) 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/hcp-lan-apm-framework |
| Version | 1.0.0 |
| Name | LAN_APM_Framework |
| Title | The Health Care Payment Learning and Action Network (HCPLAN) Alternative Payment Model (APM) Framework Categories |
| Status | active |
| Definition | "The Health Care Payment Learning and Action Network (HCPLAN or LAN) [https://hcp-lan.org/](https://hcp-lan.org/) is a public-private partnership established in 2015 by the US Department of Health and Human Services (HHS) to accelerate the transition to value-based payment models in the US healthcare system.""The Framework represents payments from public and private payers to provider organizations (including payments between the payment and delivery arms of highly integrated health systems). It is designed to accommodate payments in multiple categories that are made by a single payer, as well as single provider organizations that receive payments in different categories—potentially from the same payer.""Since the original APM Framework White Paper was released in January 2016, it has become the foundation for implementing APMs and evaluating progress toward health care payment reform. Payers, providers, and purchasers have all used the APM Framework to better understand the payment reform landscape and to set goals for participation in APMs, and health care stakeholders have used the APM Framework to identify common goals for transforming the nation’s health care system. Overall, the APM Framework’s classification system has been adopted by the health care ecosystem.""The LAN APM Framework represents a continuum of payment approaches across four Categories."Initial version of the APM Framework White Paper was published in 2016. The updated version of the White Paper was published in 2017.For more information, please see [https://hcp-lan.org/workproducts/apm-refresh-whitepaper-final.pdf](https://hcp-lan.org/workproducts/apm-refresh-whitepaper-final.pdf) |
| Publisher | The Health Care Payment Learning and Action Network |
| Copyright | "The LAN APM Framework White Payer and the APM Framework categories defined in the white paper are in the public domain and are free to use without restriction. |

### Identifiers

* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/hcp-lan-apm-framework
  * **Preferred**: true
  * **Period**: 2024-03-04 --> (ongoing)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "hcp-lan-apm-framework",
  "url" : "http://terminology.hl7.org/NamingSystem/hcp-lan-apm-framework",
  "version" : "1.0.0",
  "name" : "LAN_APM_Framework",
  "title" : "The Health Care Payment Learning and Action Network (HCPLAN) Alternative Payment Model (APM) Framework Categories",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2024-03-04T00:00:00-00:00",
  "publisher" : "The Health Care Payment Learning and Action Network",
  "contact" : [
    {
      "name" : "The Health Care Payment Learning and Action Network",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hcp-lan.org/"
        }
      ]
    }
  ],
  "responsible" : "The Health Care Payment Learning and Action Network",
  "description" : "\"The Health Care Payment Learning and Action Network (HCPLAN or LAN) [https://hcp-lan.org/](https://hcp-lan.org/) is a public-private partnership established in 2015 by the US Department of Health and Human Services (HHS) to accelerate the transition to value-based payment models in the US healthcare system.\"\r\n\r\n   \"The  Framework represents payments from public and private payers to provider organizations (including payments between the payment and delivery arms of highly integrated health systems). It is designed to accommodate payments in multiple categories that are made by a single payer, as well as single provider organizations that receive payments in different categories—potentially from the same payer.\"\r\n\r\n   \"Since the original APM Framework White Paper was released in January 2016, it has become the foundation for implementing APMs and evaluating progress toward health care payment reform. Payers, providers, and purchasers have all used the APM Framework to better understand the payment reform landscape and to set goals for participation in APMs, and health care stakeholders have used the APM Framework to identify common goals for transforming the nation’s health care system. Overall, the APM Framework’s classification system has been adopted by the health care ecosystem.\"\r\n\r\n   \"The LAN APM Framework represents a continuum of payment approaches across four Categories.\"\r\n\r\n  Initial version of the APM Framework White Paper was published in 2016. The updated version of the White Paper was published in 2017.\r\n\r\n  For more information, please see [https://hcp-lan.org/workproducts/apm-refresh-whitepaper-final.pdf](https://hcp-lan.org/workproducts/apm-refresh-whitepaper-final.pdf)",
  "copyright" : "\"The LAN APM Framework White Payer and the APM Framework categories defined in the white paper are in the public domain and are free to use without restriction.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/hcp-lan-apm-framework",
      "preferred" : true,
      "period" : {
        "start" : "2024-03-04"
      }
    }
  ]
}

```
