# Health Canada Drug Id Number - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Health Canada Drug Id Number**

## NamingSystem: Health Canada Drug Id Number 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/ca-hc-din | *Version*:4.0.0 | |
| Active as of 2021-10-04 | *Responsible:*HL7 | *Computable Name*:HcDIN |

 
A Drug Identification Number (DIN) is a computer-generated eight digit number assigned by Health Canada to a drug product prior to being marketed in Canada. It uniquely identifies all drug products sold in a dosage form in Canada and is located on the label of prescription and over-the-counter drug products that have been evaluated and authorized for sale in Canada. A DIN uniquely identifies the following product characteristics: 
* manufacturer
* product name
* active ingredient(s)
* strength(s) of active ingredient(s)
* pharmaceutical form, and
* route of administration.
 
Note: The number has a leading zero. 
Further information about this Code System can be found at https://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/applications-submissions/guidance-documents/regulatory-requirements-drug-identification-numbers/document.html 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/ca-hc-din |
| Version | 4.0.0 |
| Name | HcDIN |
| Title | Health Canada Drug Id Number |
| Status | active |
| Definition | A Drug Identification Number (DIN) is a computer-generated eight digit number assigned by Health Canada to a drug product prior to being marketed in Canada. It uniquely identifies all drug products sold in a dosage form in Canada and is located on the label of prescription and over-the-counter drug products that have been evaluated and authorized for sale in Canada. A DIN uniquely identifies the following product characteristics:* manufacturer
* product name
* active ingredient(s)
* strength(s) of active ingredient(s)
* pharmaceutical form, and
* route of administration.
Note: The number has a leading zero.Further information about this Code System can be found at https://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/applications-submissions/guidance-documents/regulatory-requirements-drug-identification-numbers/document.html |
| Publisher | HL7 |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.5.1105
  * **Preferred**: true
  * **Comment**: 
* **Type**: URI
  * **Value**: http://hl7.org/fhir/NamingSystem/ca-hc-din
  * **Preferred**: true
  * **Comment**: Official canonical URL going forward.
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/ca-hc-din
  * **Preferred**: false
  * **Comment**: Maintained for backward compatibility.
* **Type**: URI
  * **Value**: http://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database-3
  * **Preferred**: false
  * **Comment**: Maintained for backward compatibility.

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "ca-hc-din",
  "url" : "http://terminology.hl7.org/NamingSystem/ca-hc-din",
  "version" : "4.0.0",
  "name" : "HcDIN",
  "title" : "Health Canada Drug Id Number",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2021-10-04T00:00:00-04:00",
  "publisher" : "HL7",
  "contact" : [
    {
      "name" : "Health Canada,Health Canada"
    }
  ],
  "responsible" : "HL7",
  "description" : "A Drug Identification Number (DIN) is a computer-generated eight digit number assigned by Health Canada to a drug product prior to being marketed in Canada. It uniquely identifies all drug products sold in a dosage form in Canada and is located on the label of prescription and over-the-counter drug products that have been evaluated and authorized for sale in Canada.  A DIN uniquely identifies the following product characteristics:\r\n\r\n *  manufacturer\r\n *  product name\r\n *  active ingredient(s)\r\n *  strength(s) of active ingredient(s)\r\n *  pharmaceutical form, and\r\n *  route of administration.\r\n\r\nNote: The number has a leading zero.\r\n\r\nFurther information about this Code System can be found at https://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/applications-submissions/guidance-documents/regulatory-requirements-drug-identification-numbers/document.html",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.5.1105",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/NamingSystem/ca-hc-din",
      "preferred" : true,
      "comment" : "Official canonical URL going forward."
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/ca-hc-din",
      "preferred" : false,
      "comment" : "Maintained for backward compatibility."
    },
    {
      "type" : "uri",
      "value" : "http://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database-3",
      "preferred" : false,
      "comment" : "Maintained for backward compatibility."
    }
  ]
}

```
