# ABC Codes - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ABC Codes**

## NamingSystem: ABC Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/abcCodes | *Version*:2.1.1 | |
| Retired as of 2021-11-09 | *Responsible:*Name Alternative Link Systems, Inc. | *Computable Name*:AbcCodes |

 
Five character alphabetic codes fit into current claims processing software or onto standard paper claim forms. ABC Codes give business parity to licensed CAM and nurse providers who file claims to insurance companies. . 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/abcCodes |
| Version | 2.1.1 |
| Name | AbcCodes |
| Title | ABC Codes |
| Status | retired |
| Definition | Five character alphabetic codes fit into current claims processing software or onto standard paper claim forms. ABC Codes give business parity to licensed CAM and nurse providers who file claims to insurance companies. . |
| Publisher | Name Alternative Link Systems, Inc. |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.25
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/abcCodes
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "abcCodes",
  "url" : "http://terminology.hl7.org/NamingSystem/abcCodes",
  "version" : "2.1.1",
  "name" : "AbcCodes",
  "title" : "ABC Codes",
  "status" : "retired",
  "kind" : "codesystem",
  "date" : "2021-11-09T10:00:00+10:00",
  "publisher" : "Name Alternative Link Systems, Inc.",
  "contact" : [
    {
      "name" : "Name Melinna Giannini, Alternative Link Systems, Inc.; Address 1065 S. Main, Building C, Las Cruces, NM 88005; Telephone 505-527-0636; Fax 505-523-4152; E-mail mg@alternativelink.com"
    }
  ],
  "responsible" : "Name Alternative Link Systems, Inc.",
  "description" : "Five character alphabetic codes fit into current claims processing software or onto standard paper claim forms. ABC Codes give business parity to licensed CAM and nurse providers who file claims to insurance companies. .",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.25",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/abcCodes",
      "preferred" : true
    }
  ]
}

```
