# US Census Occupation Code - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Census Occupation Code**

## NamingSystem: US Census Occupation Code 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/USCOC | *Version*:2.1.0 | |
| Retired as of 2021-11-09 | *Responsible:*US Government | *Computable Name*:USCOC |

 
Coding system of United States Census Occupation Codes, published by the US Governmetn Bureau of the Census. Doucmentation and Crosswalk mapping between the COC and the SOC and NAICS code systems available at http://www.census.gov/hhes/www/ioindex/view.html 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/USCOC |
| Version | 2.1.0 |
| Name | USCOC |
| Title | US Census Occupation Code |
| Status | retired |
| Definition | Coding system of United States Census Occupation Codes, published by the US Governmetn Bureau of the Census. Doucmentation and Crosswalk mapping between the COC and the SOC and NAICS code systems available at http://www.census.gov/hhes/www/ioindex/view.html |
| Publisher | US Government |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.240
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/USCOC
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "USCOC",
  "url" : "http://terminology.hl7.org/NamingSystem/USCOC",
  "version" : "2.1.0",
  "name" : "USCOC",
  "title" : "US Census Occupation Code",
  "status" : "retired",
  "kind" : "codesystem",
  "date" : "2021-11-09T10:00:00+10:00",
  "publisher" : "US Government",
  "contact" : [
    {
      "name" : "US Census Bureau"
    }
  ],
  "responsible" : "US Government",
  "description" : "Coding system of United States Census Occupation Codes, published by the US Governmetn Bureau of the Census. Doucmentation and Crosswalk mapping between the COC and the SOC and NAICS code systems available at http://www.census.gov/hhes/www/ioindex/view.html",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.240",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/USCOC",
      "preferred" : true
    }
  ]
}

```
