# National Association of Insurance Commissioners (NAIC) Company Codes - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **National Association of Insurance Commissioners (NAIC) Company Codes**

## NamingSystem: National Association of Insurance Commissioners (NAIC) Company Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/NAICCompanyCodes | *Version*:1.0.0 | |
| Active as of 2025-05-05 | *Responsible:*[National Association of Insurance Commissioners (NAIC)](https://content.naic.org/) | *Computable Name*:NAIC_Company_Codes |
| **Copyright/Legal**: See[https://content.naic.org/privacy_statement.htm](https://content.naic.org/privacy_statement.htm) | | |

 
NAIC company codes, also referred to as NAIC numbers, are five-digit identification codes assigned by the National Association of Insurance Commissioners (NAIC) to every insurance company to identify them. NAIC maintains a list of all lines of insurance the company sells and a list of all jurisdictions in which the company is licensed. 
For more information, see[https://content.naic.org/cis_consumer_information.htm](https://content.naic.org/cis_consumer_information.htm) 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/NAICCompanyCodes |
| Version | 1.0.0 |
| Name | NAIC_Company_Codes |
| Title | National Association of Insurance Commissioners (NAIC) Company Codes |
| Status | active |
| Definition | NAIC company codes, also referred to as NAIC numbers, are five-digit identification codes assigned by the National Association of Insurance Commissioners (NAIC) to every insurance company to identify them. NAIC maintains a list of all lines of insurance the company sells and a list of all jurisdictions in which the company is licensed.For more information, see [https://content.naic.org/cis_consumer_information.htm](https://content.naic.org/cis_consumer_information.htm) |
| Publisher | National Association of Insurance Commissioners (NAIC) |
| Copyright | See [https://content.naic.org/privacy_statement.htm](https://content.naic.org/privacy_statement.htm) |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.300
  * **Preferred**: true
* **Type**: URI
  * **Value**: urn:oid:2.16.840.1.113883.6.300
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "NAICCompanyCodes",
  "url" : "http://terminology.hl7.org/NamingSystem/NAICCompanyCodes",
  "version" : "1.0.0",
  "name" : "NAIC_Company_Codes",
  "title" : "National Association of Insurance Commissioners (NAIC) Company Codes",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2025-05-05T00:00:00-00:00",
  "publisher" : "National Association of Insurance Commissioners (NAIC)",
  "contact" : [
    {
      "name" : "National Association of Insurance Commissioners (NAIC); 1101 K Street, N.W., Suite 650; Washington, DC 20005",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://content.naic.org/"
        },
        {
          "system" : "email",
          "value" : "info@naic.org"
        },
        {
          "system" : "phone",
          "value" : "816.783.8500"
        }
      ]
    }
  ],
  "responsible" : "National Association of Insurance Commissioners (NAIC)",
  "description" : "NAIC company codes, also referred to as NAIC numbers, are five-digit identification codes assigned by the National Association of Insurance Commissioners (NAIC) to every insurance company to identify them. NAIC maintains a list of all lines of insurance the company sells and a list of all jurisdictions in which the company is licensed.\r\n\r\nFor more information, see [https://content.naic.org/cis_consumer_information.htm](https://content.naic.org/cis_consumer_information.htm)",
  "copyright" : "See [https://content.naic.org/privacy_statement.htm](https://content.naic.org/privacy_statement.htm)",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.300",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "urn:oid:2.16.840.1.113883.6.300",
      "preferred" : true
    }
  ]
}

```
