# Medication Reference Terminology (MED-RT) - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Medication Reference Terminology (MED-RT)**

## NamingSystem: Medication Reference Terminology (MED-RT) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/MEDRT | *Version*:1.0.0 | |
| Active as of 2022-02-16 | *Responsible:*[National Cancer Institute (NCI) Enterprise Vocabulary Services (EVS)](https://www.va.gov/) | *Computable Name*:MEDRT |
| **Copyright/Legal**: MED-RT has no copyright acknowledgement required. However, users must adhere to the UMLS license. | | |

 
Medication Reference Terminology (MED-RT) is the evolutionary successor to the Veterans Health Administration National Drug File – Reference Terminology (VHA NDF-RT). Both are formal ontology representations of medication terminology, pharmacologic classifications, and asserted authoritative relationships between them. 
The MED-RT code system includes relationships between MED-RT concepts and concepts in external code systems, as well as relationships between concepts only in the external code systems. The external code systems that MED-RT references include RxNorm, MeSH, and SNOMED CT US Edition. 
MED-RT can be downloaded from https://evs.nci.nih.gov/ftp1/MED-RT/ 
For more information, please see https://ncit.nci.nih.gov/ncitbrowser/pages/vocabulary.jsf?dictionary=MED-RT 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/MEDRT |
| Version | 1.0.0 |
| Name | MEDRT |
| Title | Medication Reference Terminology (MED-RT) |
| Status | active |
| Definition | Medication Reference Terminology (MED-RT) is the evolutionary successor to the Veterans Health Administration National Drug File – Reference Terminology (VHA NDF-RT). Both are formal ontology representations of medication terminology, pharmacologic classifications, and asserted authoritative relationships between them.The MED-RT code system includes relationships between MED-RT concepts and concepts in external code systems, as well as relationships between concepts only in the external code systems. The external code systems that MED-RT references include RxNorm, MeSH, and SNOMED CT US Edition.MED-RT can be downloaded from https://evs.nci.nih.gov/ftp1/MED-RT/For more information, please see https://ncit.nci.nih.gov/ncitbrowser/pages/vocabulary.jsf?dictionary=MED-RT |
| Publisher | National Cancer Institute (NCI) Enterprise Vocabulary Services (EVS) |
| Copyright | MED-RT has no copyright acknowledgement required. However, users must adhere to the UMLS license. |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.345
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://va.gov/terminology/medrt
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "MEDRT",
  "url" : "http://terminology.hl7.org/NamingSystem/MEDRT",
  "version" : "1.0.0",
  "name" : "MEDRT",
  "title" : "Medication Reference Terminology (MED-RT)",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2022-02-16T00:00:00-00:00",
  "publisher" : "National Cancer Institute (NCI) Enterprise Vocabulary Services (EVS)",
  "contact" : [
    {
      "name" : "US Department of Veterans Affairs; John Kilbourne, MD",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.va.gov/"
        },
        {
          "system" : "email",
          "value" : "medrt@jpsys.com"
        },
        {
          "system" : "email",
          "value" : "John.Kilbourne@va.gov"
        }
      ]
    }
  ],
  "responsible" : "US Department of Veterans Affairs; John Kilbourne, MD",
  "description" : "Medication Reference Terminology (MED-RT) is the evolutionary successor to the Veterans Health Administration National Drug File – Reference Terminology (VHA NDF-RT). Both are formal ontology representations of medication terminology, pharmacologic classifications, and asserted authoritative relationships between them.\r\n\r\nThe MED-RT code system includes relationships between MED-RT concepts and concepts in external code systems, as well as relationships between concepts only in the external code systems. The external code systems that MED-RT references include RxNorm, MeSH, and SNOMED CT US Edition.\r\n\r\nMED-RT can be downloaded from https://evs.nci.nih.gov/ftp1/MED-RT/ \r\n\r\nFor more information, please see https://ncit.nci.nih.gov/ncitbrowser/pages/vocabulary.jsf?dictionary=MED-RT",
  "copyright" : "MED-RT has no copyright acknowledgement required. However, users must adhere to the UMLS license.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.345",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://va.gov/terminology/medrt",
      "preferred" : true
    }
  ]
}

```
