# International System for Human Cytogenomic Nomenclature (ISCN) - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **International System for Human Cytogenomic Nomenclature (ISCN)**

## NamingSystem: International System for Human Cytogenomic Nomenclature (ISCN) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/ISCN | *Version*:1.0.1 | |
| Active as of 2022-06-07 | *Responsible:*[S. Karger AG](https://www.karger.com/) | *Computable Name*:ISCN |
| **Copyright/Legal**: The content on the Website including but not limited to the content of ISCN 2020 in whole or in parts, the title, the logo, graphic designs or adverts are the intellectual property of S. Karger AG (Basel) or published with permission from the legal copyright owner. All rights are reserved. Unless otherwise noted, no part of the content on the Website may be translated into other languages, reproduced or utilized in any form or by any means, electronic or mechanical, including photocopying, recording, microcopying, or by any information storage and retrieval system, without permission in writing from Karger.For further information or permission requests please see the explanations under Rights and Permissions (https://www.karger.com/Services/RightsPermissions). | | |

 
The International System for Human Cytogenetic Nomenclature (ISCN) was created by the International Standing committee on Human Cytogenetic Nomenclature to represent the outcome of cytogenetic tests. ISCN specifies the nomenclature to describe karyotypes, chromosome abnormalities, in situ hybridization, etc. ISCN provides a list of symbols and abbreviated terms in adjunction with a set of rules, which can be used in the description of chromosomes and chromosome abnormalities, such as p for short arm of chromosome, q for long arm of chromosome, cen for centromere, del for deletion, ish for in situ hybridization, and plus sign (+) for gain, etc. 
A LOINC code is created to represent "chromosome analysis results in ISCN expression". In HL7 v2 messages, this LOINC code is used in OBX-3 with a coded result (CWE data type) that will be sent in OBX-5. The value of the coded result is an ISCN expression, and ISCN will be the code system for the coded result. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/ISCN |
| Version | 1.0.1 |
| Name | ISCN |
| Title | International System for Human Cytogenomic Nomenclature (ISCN) |
| Status | active |
| Definition | The International System for Human Cytogenetic Nomenclature (ISCN) was created by the International Standing committee on Human Cytogenetic Nomenclature to represent the outcome of cytogenetic tests. ISCN specifies the nomenclature to describe karyotypes, chromosome abnormalities, in situ hybridization, etc. ISCN provides a list of symbols and abbreviated terms in adjunction with a set of rules, which can be used in the description of chromosomes and chromosome abnormalities, such as p for short arm of chromosome, q for long arm of chromosome, cen for centromere, del for deletion, ish for in situ hybridization, and plus sign (+) for gain, etc.A LOINC code is created to represent "chromosome analysis results in ISCN expression". In HL7 v2 messages, this LOINC code is used in OBX-3 with a coded result (CWE data type) that will be sent in OBX-5. The value of the coded result is an ISCN expression, and ISCN will be the code system for the coded result. |
| Publisher | S. Karger AG |
| Copyright | The content on the Website including but not limited to the content of ISCN 2020 in whole or in parts, the title, the logo, graphic designs or adverts are the intellectual property of S. Karger AG (Basel) or published with permission from the legal copyright owner. All rights are reserved. Unless otherwise noted, no part of the content on the Website may be translated into other languages, reproduced or utilized in any form or by any means, electronic or mechanical, including photocopying, recording, microcopying, or by any information storage and retrieval system, without permission in writing from Karger.For further information or permission requests please see the explanations under Rights and Permissions (https://www.karger.com/Services/RightsPermissions). |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.299
  * **Preferred**: true
  * **Period**: 
  * **Comment**: 
* **Type**: URI
  * **Value**: https://iscn.karger.com
  * **Preferred**: true
  * **Period**: 2021-01-27 --> (ongoing)
  * **Comment**: Official canonical URL going forward.

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "ISCN",
  "url" : "http://terminology.hl7.org/NamingSystem/ISCN",
  "version" : "1.0.1",
  "name" : "ISCN",
  "title" : "International System for Human Cytogenomic Nomenclature (ISCN)",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2022-06-07T00:00:00-00:00",
  "publisher" : "S. Karger AG",
  "contact" : [
    {
      "name" : "S. Karger AG; P.O Box, CH-4009 Basel (Switzerland) Allschwilerstrasse 10, CH-4055 Basel",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.karger.com/"
        },
        {
          "system" : "email",
          "value" : "info@signaturegenomics.com"
        },
        {
          "system" : "phone",
          "value" : "+41 61 306 11 11"
        }
      ]
    }
  ],
  "description" : "The International System for Human Cytogenetic Nomenclature (ISCN) was created by the International Standing committee on Human Cytogenetic Nomenclature to represent the outcome of cytogenetic tests. ISCN specifies the nomenclature to describe karyotypes, chromosome abnormalities, in situ hybridization, etc. ISCN provides a list of symbols and abbreviated terms in adjunction with a set of rules, which can be used in the description of chromosomes and chromosome abnormalities, such as p for short arm of chromosome, q for long arm of chromosome, cen for centromere, del for deletion, ish for in situ hybridization, and plus sign (+) for gain, etc.\r\n\r\nA LOINC code is created to represent \"chromosome analysis results in ISCN expression\". In HL7 v2 messages, this LOINC code is used in OBX-3 with a coded result (CWE data type) that will be sent in OBX-5. The value of the coded result is an ISCN expression, and ISCN will be the code system for the coded result.",
  "copyright" : "The content on the Website including but not limited to the content of ISCN 2020 in whole or in parts, the title, the logo, graphic designs or adverts are the intellectual property of S. Karger AG (Basel) or published with permission from the legal copyright owner. All rights are reserved. Unless otherwise noted, no part of the content on the Website may be translated into other languages, reproduced or utilized in any form or by any means, electronic or mechanical, including photocopying, recording, microcopying, or by any information storage and retrieval system, without permission in writing from Karger.\r\n\r\nFor further information or permission requests please see the explanations under Rights and Permissions (https://www.karger.com/Services/RightsPermissions).",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.299",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "https://iscn.karger.com",
      "preferred" : true,
      "comment" : "Official canonical URL going forward.",
      "period" : {
        "start" : "2021-01-27"
      }
    }
  ]
}

```
