# International Classification of Diseases, 11th Revision Mortality and Morbidity Statistics (MMS) - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **International Classification of Diseases, 11th Revision Mortality and Morbidity Statistics (MMS)**

## NamingSystem: International Classification of Diseases, 11th Revision Mortality and Morbidity Statistics (MMS) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/ICD11MMS | *Version*:1.0.0 | |
| Active as of 2022-11-15 | *Responsible:*[The World Health Organization](https://icd.who.int/en) | *Computable Name*:ICD11MMS |
| **Copyright/Legal**: The WHO grants a license for "commercial and non-commercial use" of ICD-11CC BY-ND 3.0 IGODetailed information can be found here:[https://icd.who.int/en/docs/icd11-license.pdf](https://icd.who.int/en/docs/icd11-license.pdf)Contact licensing@who.int to obtain further information. | | |

 
The International Classification of Diseases, 11th Revision Mortality and Morbidity Statistics (MMS) is one of the ICD11 linearizations. Information about the ICD Foundation Component and the ICD11 Linearizations can be found in the complete reference guide here:[https://icd.who.int/icd11refguide/en/index.html](https://icd.who.int/icd11refguide/en/index.html) 
"**The ICD11 Linearizations (Tabular lists)** 
A linearization is a subset of the foundation component, that is: 
1. fit for a particular purpose: reporting mortality, morbidity, primary care or other uses;
1. composed of entities that are Mutually Exclusive of each other;
1. each entity is given a single parent.
 
Linearization is similar to the classical print versions of ICD Tabular List (e.g. volume I of ICD-10 or other previous editions). The main linearization of ICD-11 is Mortality and Morbidity Statistics (MMS). Various linearizations could be built at different granularity, use case or other purposes such as for Primary Care, Clinical Care or Research. The linkage from the foundation component to a particular linearization will ensure consistent use of the ICD." 
ICD-11 for Mortality and Morbidity (ICD-11 MMS) can be downloaded in either print or electronic (spreadsheet) format from the browser in the Info tab located[here](https://icd.who.int/browse11/l-m/en) 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/ICD11MMS |
| Version | 1.0.0 |
| Name | ICD11MMS |
| Title | International Classification of Diseases, 11th Revision Mortality and Morbidity Statistics (MMS) |
| Status | active |
| Definition | The International Classification of Diseases, 11th Revision Mortality and Morbidity Statistics (MMS) is one of the ICD11 linearizations. Information about the ICD Foundation Component and the ICD11 Linearizations can be found in the complete reference guide here: [https://icd.who.int/icd11refguide/en/index.html](https://icd.who.int/icd11refguide/en/index.html)"**The ICD11 Linearizations (Tabular lists)**A linearization is a subset of the foundation component, that is:1. fit for a particular purpose: reporting mortality, morbidity, primary care or other uses;
1. composed of entities that are Mutually Exclusive of each other;
1. each entity is given a single parent.
Linearization is similar to the classical print versions of ICD Tabular List (e.g. volume I of ICD-10 or other previous editions). The main linearization of ICD-11 is Mortality and Morbidity Statistics (MMS). Various linearizations could be built at different granularity, use case or other purposes such as for Primary Care, Clinical Care or Research. The linkage from the foundation component to a particular linearization will ensure consistent use of the ICD."ICD-11 for Mortality and Morbidity (ICD-11 MMS) can be downloaded in either print or electronic (spreadsheet) format from the browser in the Info tab located [here](https://icd.who.int/browse11/l-m/en) |
| Publisher | The World Health Organization |
| Copyright | The WHO grants a license for "commercial and non-commercial use" of ICD-11CC BY-ND 3.0 IGODetailed information can be found here: [https://icd.who.int/en/docs/icd11-license.pdf](https://icd.who.int/en/docs/icd11-license.pdf)Contact licensing@who.int to obtain further information. |

### Identifiers

* **Type**: URI
  * **Value**: http://id.who.int/icd/release/11/mms
  * **Preferred**: true
  * **Period**: 2022-10-27 --> (ongoing)
  * **Comment**: This is the URL as specified by the terminology owner, and is considered authoritative.

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "ICD11MMS",
  "url" : "http://terminology.hl7.org/NamingSystem/ICD11MMS",
  "version" : "1.0.0",
  "name" : "ICD11MMS",
  "title" : "International Classification of Diseases, 11th Revision Mortality and Morbidity Statistics (MMS)",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2022-11-15T00:00:00-00:00",
  "publisher" : "The World Health Organization",
  "contact" : [
    {
      "name" : "The World Health Organization; 20, avenue Appia 1211 Geneva 27, Switzerland",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://icd.who.int/en"
        }
      ]
    }
  ],
  "responsible" : "The World Health Organization",
  "description" : "The International Classification of Diseases, 11th Revision Mortality and Morbidity Statistics (MMS) is one of the ICD11 linearizations. Information about the ICD Foundation Component and the ICD11 Linearizations can be found in the complete reference guide here: [https://icd.who.int/icd11refguide/en/index.html](https://icd.who.int/icd11refguide/en/index.html)\r\n\r\n\"**The ICD11 Linearizations (Tabular lists)**\r\n\r\nA linearization is a subset of the foundation component, that is:\r\n\r\n1. fit for a particular purpose: reporting mortality, morbidity, primary care or other uses;\r\n\r\n 2. composed of entities that are Mutually Exclusive of each other; \r\n\r\n3. each entity is given a single parent.\r\n\r\nLinearization is similar to the classical print versions of ICD Tabular List (e.g. volume I of ICD-10 or other previous editions). The main linearization of ICD-11 is Mortality and Morbidity Statistics (MMS). Various linearizations could be built at different granularity, use case or other purposes such as for Primary Care, Clinical Care or Research. The linkage from the foundation component to a particular linearization will ensure consistent use of the ICD.\"\r\n\r\nICD-11 for Mortality and Morbidity (ICD-11 MMS) can be downloaded in either print or electronic (spreadsheet) format from the  browser in the Info tab located [here](https://icd.who.int/browse11/l-m/en)",
  "copyright" : "The WHO grants a license for \"commercial and non-commercial use\" of ICD-11\r\n\r\nCC BY-ND 3.0 IGO\r\n\r\nDetailed information can be found here: [https://icd.who.int/en/docs/icd11-license.pdf](https://icd.who.int/en/docs/icd11-license.pdf)\r\n\r\nContact licensing@who.int to obtain further information.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://id.who.int/icd/release/11/mms",
      "preferred" : true,
      "comment" : "This is the URL as specified by the terminology owner, and is considered authoritative.",
      "period" : {
        "start" : "2022-10-27"
      }
    }
  ]
}

```
