# ICD-9-CM (procedure codes) - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ICD-9-CM (procedure codes)**

## NamingSystem: ICD-9-CM (procedure codes) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/ICD-9CM-procedurecodes | *Version*:3.0.0 | |
| Active as of 2023-08-22 | *Responsible:*Centers for Disease Control and Prevention (CDC) | *Computable Name*:ICD9CMProcedurecodes |

 
The International Classification of Diseases, 9th Revision, Clinical Modification (ICD-9-CM), Volumes I, II (diagnoses) and III (procedures) describes the classification of morbidity and mortality information for statistical purposes and for the indexing of healthcare records by diseases and procedures. The ICD-9-CM codes can be used as the value of the Act.cd attribute. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/ICD-9CM-procedurecodes |
| Version | 3.0.0 |
| Name | ICD9CMProcedurecodes |
| Title | ICD-9-CM (procedure codes) |
| Status | active |
| Definition | The International Classification of Diseases, 9th Revision, Clinical Modification (ICD-9-CM), Volumes I, II (diagnoses) and III (procedures) describes the classification of morbidity and mortality information for statistical purposes and for the indexing of healthcare records by diseases and procedures. The ICD-9-CM codes can be used as the value of the Act.cd attribute. |
| Publisher | Centers for Disease Control and Prevention (CDC) |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.6.104
  * **Preferred**: true
* **Type**: URI
  * **Value**: http://hl7.org/fhir/sid/icd-9-cm
  * **Preferred**: true

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "ICD-9CM-procedurecodes",
  "url" : "http://terminology.hl7.org/NamingSystem/ICD-9CM-procedurecodes",
  "version" : "3.0.0",
  "name" : "ICD9CMProcedurecodes",
  "title" : "ICD-9-CM (procedure codes)",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2023-08-22T10:00:00+10:00",
  "publisher" : "Centers for Disease Control and Prevention (CDC)",
  "contact" : [
    {
      "name" : "National Center for Health Statistics"
    }
  ],
  "responsible" : "National Center for Health Statistics",
  "description" : "The International Classification of Diseases, 9th Revision, Clinical Modification (ICD-9-CM), Volumes I, II (diagnoses) and III (procedures) describes the classification of morbidity and mortality information for statistical purposes and for the indexing of healthcare records by diseases and procedures. The ICD-9-CM codes can be used as the value of the Act.cd attribute.",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.6.104",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://hl7.org/fhir/sid/icd-9-cm",
      "preferred" : true
    }
  ]
}

```
