# CMS Prescription Drug Hierarchical Condition Categories - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CMS Prescription Drug Hierarchical Condition Categories**

## NamingSystem: CMS Prescription Drug Hierarchical Condition Categories 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/CMSRxHCC | *Version*:1.0.0 |
| Active as of 2021-12-02 | *Responsible:*Centers for Medicare & Medicaid Services /td>*Computable Name*:CMSRxHCCStarting in 2006, with the implementation of the Part D program, CMS introduced a second major HCC-based risk adjustment model. Created with the passage of the Medicare Modernization Act (MMA) of 2003, the Medicare Part D Prescription Drug benefit became the second major Medicare capitated payment system. CMS developed the Part D RxHCC risk adjustment model to apply to monthly capitated payments to both Medicare Advantage (MA-PDs) and standalone prescription drug plans (PDPs). The Part D RxHCC risk adjustment model implemented in 2006 was developed using a structure similar to the CMS-HCC model, in that it included demographic and diagnosis information clustered into hierarchical condition categories. CMS obtains diagnoses for all Medicare beneficiaries from either fee-for-service claims or Medicare Advantage reporting. In 2011, CMS implemented an updated Part D RxHCC risk adjustment model, incorporating program data derived from prescription drug event (PDE) data. The data used to calibrate this updated model was more recent cost and utilization data, resulting in a model that reflects more recent drug cost and utilization patterns.For more information, see: https://www.cms.gov/Medicare/Health-Plans/MedicareAdvtgSpecRateStats/Risk-AdjustorsThe CMS RxHCCs are in the public domain and are free to use without restriction.### Summary
| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/CMSRxHCC |
| Version | 1.0.0 |
| Name | CMSRxHCC |
| Title | CMS Prescription Drug Hierarchical Condition Categories |
| Status | active |
| Definition | Starting in 2006, with the implementation of the Part D program, CMS introduced a second major HCC-based risk adjustment model. Created with the passage of the Medicare Modernization Act (MMA) of 2003, the Medicare Part D Prescription Drug benefit became the second major Medicare capitated payment system. CMS developed the Part D RxHCC risk adjustment model to apply to monthly capitated payments to both Medicare Advantage (MA-PDs) and standalone prescription drug plans (PDPs). The Part D RxHCC risk adjustment model implemented in 2006 was developed using a structure similar to the CMS-HCC model, in that it included demographic and diagnosis information clustered into hierarchical condition categories. CMS obtains diagnoses for all Medicare beneficiaries from either fee-for-service claims or Medicare Advantage reporting. In 2011, CMS implemented an updated Part D RxHCC risk adjustment model, incorporating program data derived from prescription drug event (PDE) data. The data used to calibrate this updated model was more recent cost and utilization data, resulting in a model that reflects more recent drug cost and utilization patterns.For more information, see: https://www.cms.gov/Medicare/Health-Plans/MedicareAdvtgSpecRateStats/Risk-AdjustorsThe CMS RxHCCs are in the public domain and are free to use without restriction. |
| Publisher | Centers for Medicare & Medicaid Services |
### Identifiers
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/cmsrxhcc
  * **Preferred**: true
  * **Period**: 2021-12-02 --> (ongoing)

-------
**History** |



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "CMSRxHCC",
  "url" : "http://terminology.hl7.org/NamingSystem/CMSRxHCC",
  "version" : "1.0.0",
  "name" : "CMSRxHCC",
  "title" : "CMS Prescription Drug Hierarchical Condition Categories",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2021-12-02T00:00:00-00:00",
  "publisher" : "Centers for Medicare & Medicaid Services",
  "responsible" : "Centers for Medicare & Medicaid Services",
  "description" : "Starting in 2006, with the implementation of the Part D program, CMS introduced a second major HCC-based risk adjustment model. Created with the passage of the Medicare Modernization Act (MMA) of 2003, the Medicare Part D Prescription Drug benefit became the second major Medicare capitated payment system. CMS developed the Part D RxHCC risk adjustment model to apply to monthly capitated payments to both Medicare Advantage (MA-PDs) and standalone prescription drug plans (PDPs). The Part D RxHCC risk adjustment model implemented in 2006 was developed using a structure similar to the CMS-HCC model, in that it included demographic and diagnosis information clustered into hierarchical condition categories. CMS obtains diagnoses for all Medicare beneficiaries from either fee-for-service claims or Medicare Advantage reporting. In 2011, CMS implemented an updated Part D RxHCC risk adjustment model, incorporating program data derived from prescription drug event (PDE) data. The data used to calibrate this updated model was more recent cost and utilization data, resulting in a model that reflects more recent drug cost and utilization patterns.\r\n\r\nFor more information, see: https://www.cms.gov/Medicare/Health-Plans/MedicareAdvtgSpecRateStats/Risk-Adjustors\r\n\r\nThe CMS RxHCCs are in the public domain and are free to use without restriction.",
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/cmsrxhcc",
      "preferred" : true,
      "period" : {
        "start" : "2021-12-02"
      }
    }
  ]
}

```
