# Canadian Clinical Drug Data Set - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Canadian Clinical Drug Data Set**

## NamingSystem: Canadian Clinical Drug Data Set 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/NamingSystem/CCDD | *Version*:1.1.0 | |
| Active as of 2024-11-04 | *Responsible:*[Health Canada](https://tgateway.infoway-inforoute.ca/ccdd.html) | *Computable Name*:CCDD |

 
The Canadian Clinical Drug Data Set provides codes for identification and a consistent approach to naming of medications and some medical devices in Canada. It has been designed and developed to reflect current clinical practice and safety advice and is freely available for use in digital health solutions and design applications. CCDD is available in English and Canadian French. 
To request content changes, send an email to[clinicaldrug@infoway-inforoute.ca](mailto:clinicaldrug@infoway-inforoute.ca). 
Canada Health Infoway has developed a FHIR representation of CCDD, which can be viewed at:[https://ontoserver.csiro.au/shrimp/launch.html?iss=https://terminologystandardsservice.ca/fhir](https://ontoserver.csiro.au/shrimp/launch.html?iss=https://terminologystandardsservice.ca/fhir) 
The CCDD FHIR representation contains supplemental property codes, as defined in the Health Canada Drug Product Database (DPD), managed by Health Canada, as follows: 
* Anatomical Therapeutical Chemical (ATC): The purpose of the ATC classification system is to be used as a tool for drug utilization research to improve the quality of drug use.
* Biosimilar: Identifies biosimilar products.
* Pediatric: Identifies pediatric products.
* Schedule: Each drug is assigned one or more schedules according to the Food and Drug Regulations and the Controlled Drugs and Substances Act.
 
Further information on the supplemental properties may be obtained by reviewing the information at[https://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database.html](https://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database.html)or by emailing[pharma_drug_enquiries-renseignements_medicaments_pharma@hc-sc.gc.ca](mailto:pharma_drug_enquiries-renseignements_medicaments_pharma@hc-sc.gc.ca) 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://terminology.hl7.org/NamingSystem/CCDD |
| Version | 1.1.0 |
| Name | CCDD |
| Title | Canadian Clinical Drug Data Set |
| Status | active |
| Definition | The Canadian Clinical Drug Data Set provides codes for identification and a consistent approach to naming of medications and some medical devices in Canada. It has been designed and developed to reflect current clinical practice and safety advice and is freely available for use in digital health solutions and design applications. CCDD is available in English and Canadian French.To request content changes, send an email to [clinicaldrug@infoway-inforoute.ca](mailto:clinicaldrug@infoway-inforoute.ca).Canada Health Infoway has developed a FHIR representation of CCDD, which can be viewed at: [https://ontoserver.csiro.au/shrimp/launch.html?iss=https://terminologystandardsservice.ca/fhir](https://ontoserver.csiro.au/shrimp/launch.html?iss=https://terminologystandardsservice.ca/fhir)The CCDD FHIR representation contains supplemental property codes, as defined in the Health Canada Drug Product Database (DPD), managed by Health Canada, as follows:* Anatomical Therapeutical Chemical (ATC): The purpose of the ATC classification system is to be used as a tool for drug utilization research to improve the quality of drug use.
* Biosimilar: Identifies biosimilar products.
* Pediatric: Identifies pediatric products.
* Schedule: Each drug is assigned one or more schedules according to the Food and Drug Regulations and the Controlled Drugs and Substances Act.
Further information on the supplemental properties may be obtained by reviewing the information at [https://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database.html](https://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database.html) or by emailing [pharma_drug_enquiries-renseignements_medicaments_pharma@hc-sc.gc.ca](mailto:pharma_drug_enquiries-renseignements_medicaments_pharma@hc-sc.gc.ca) |
| Publisher | Health Canada |

### Identifiers

* **Type**: OID
  * **Value**: 2.16.840.1.113883.2.20.6.1
  * **Preferred**: true
  * **Period**: 
  * **Comment**: 
* **Type**: URI
  * **Value**: http://terminology.hl7.org/CodeSystem/hc-CCDD
  * **Preferred**: true
  * **Period**: 2021-04-14 --> (ongoing)
  * **Comment**: Official canonical URL going forward.
* **Type**: URI
  * **Value**: https://fhir.infoway-inforoute.ca/CodeSystem/canadianclinicaldrugdataset
  * **Preferred**: false
  * **Period**: 
  * **Comment**: Maintained for backward compatibility.

-------

**History**



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "CCDD",
  "url" : "http://terminology.hl7.org/NamingSystem/CCDD",
  "version" : "1.1.0",
  "name" : "CCDD",
  "title" : "Canadian Clinical Drug Data Set",
  "status" : "active",
  "kind" : "codesystem",
  "date" : "2024-11-04T00:00:00-00:00",
  "publisher" : "Health Canada",
  "contact" : [
    {
      "name" : "Health Canada; Health Products and Food Branch; Daniel Buijs",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://tgateway.infoway-inforoute.ca/ccdd.html"
        },
        {
          "system" : "email",
          "value" : "clinicaldrug@infoway-inforoute.ca"
        }
      ]
    }
  ],
  "responsible" : "Health Canada; Health Products and Food Branch",
  "description" : "The Canadian Clinical Drug Data Set provides codes for identification and a consistent approach to naming of medications and some medical devices in Canada. It has been designed and developed to reflect current clinical practice and safety advice and is freely available for use in digital health solutions and design applications. CCDD is available in English and Canadian French.\r\n\r\nTo request content changes, send an email to [clinicaldrug@infoway-inforoute.ca](mailto:clinicaldrug@infoway-inforoute.ca).\r\n\r\nCanada Health Infoway has developed a FHIR representation of CCDD, which can be viewed at: [https://ontoserver.csiro.au/shrimp/launch.html?iss=https://terminologystandardsservice.ca/fhir](https://ontoserver.csiro.au/shrimp/launch.html?iss=https://terminologystandardsservice.ca/fhir)\r\n\r\nThe CCDD FHIR representation contains supplemental property codes, as defined in the Health Canada Drug Product Database (DPD), managed by Health Canada, as follows:\r\n\r\n- Anatomical Therapeutical Chemical (ATC): The purpose of the ATC classification system is to be used as a tool for drug utilization research to improve the quality of drug use.\r\n\r\n- Biosimilar: Identifies biosimilar products.\r\n\r\n- Pediatric: Identifies pediatric products.\r\n\r\n- Schedule: Each drug is assigned one or more schedules according to the Food and Drug Regulations and the Controlled Drugs and Substances Act.\r\n\r\nFurther information on the supplemental properties may be obtained by reviewing the information at [https://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database.html](https://www.canada.ca/en/health-canada/services/drugs-health-products/drug-products/drug-product-database.html) or by emailing [pharma_drug_enquiries-renseignements_medicaments_pharma@hc-sc.gc.ca](mailto:pharma_drug_enquiries-renseignements_medicaments_pharma@hc-sc.gc.ca)",
  "uniqueId" : [
    {
      "type" : "oid",
      "value" : "2.16.840.1.113883.2.20.6.1",
      "preferred" : true
    },
    {
      "type" : "uri",
      "value" : "http://terminology.hl7.org/CodeSystem/hc-CCDD",
      "preferred" : true,
      "comment" : "Official canonical URL going forward.",
      "period" : {
        "start" : "2021-04-14"
      }
    },
    {
      "type" : "uri",
      "value" : "https://fhir.infoway-inforoute.ca/CodeSystem/canadianclinicaldrugdataset",
      "preferred" : false,
      "comment" : "Maintained for backward compatibility."
    }
  ]
}

```
