# EvidenceVariableRoleSubtype - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EvidenceVariableRoleSubtype**

## CodeSystem: EvidenceVariableRoleSubtype 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/variable-role-subtype | *Version*:1.0.0 | | |
| Active as of 2024-04-24 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:EvidenceVariableRoleSubtype |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
The subclassification of the role that the assertion variable plays. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [EvidenceVariableRoleSubtype](ValueSet-variable-role-subtype.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "variable-role-subtype",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cds"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/variable-role-subtype",
  "version" : "1.0.0",
  "name" : "EvidenceVariableRoleSubtype",
  "title" : "EvidenceVariableRoleSubtype",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The subclassification of the role that the assertion variable plays.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/variable-role-subtype",
  "content" : "complete",
  "concept" : [
    {
      "code" : "population",
      "display" : "population",
      "definition" : "variable represents a population."
    },
    {
      "code" : "subpopulation",
      "display" : "subpopulation",
      "definition" : "variable represents a subpopulation."
    },
    {
      "code" : "exposure",
      "display" : "exposure",
      "definition" : "variable represents an exposure."
    },
    {
      "code" : "referenceExposure",
      "display" : "reference exposure",
      "definition" : "variable represents a reference exposure."
    },
    {
      "code" : "measuredVariable",
      "display" : "measured variable",
      "definition" : "variable represents a measured variable."
    },
    {
      "code" : "confounder",
      "display" : "confounder",
      "definition" : "variable represents a confounder."
    },
    {
      "code" : "measuredVariableA",
      "display" : "measured variable A",
      "definition" : "variable represents a first of two measured variables to be used in a measured variable that is a mathematical operation of two measured variables."
    },
    {
      "code" : "measuredVariableB",
      "display" : "measured variable B",
      "definition" : "variable represents a second of two measured variables to be used in a measured variable that is a mathematical operation of two measured variables."
    },
    {
      "code" : "measuredVariableAB",
      "display" : "measured variable A to B",
      "definition" : "variable represents a result of a mathematical operation of two measured variables."
    }
  ]
}

```
