# Style Type - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Style Type**

## CodeSystem: Style Type 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-styleType | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:StyleType |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1095 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
The style code is used within the CDA/SPL narrative block to give the instance author some control over various aspects of style. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [FontStyle](ValueSet-v3-FontStyle.md)
* [ListStyle](ValueSet-v3-ListStyle.md)
* [OrderedListStyle](ValueSet-v3-OrderedListStyle.md)
* [StyleType](ValueSet-v3-StyleType.md)
* [TableRuleStyle](ValueSet-v3-TableRuleStyle.md)
* [UnorderedListStyle](ValueSet-v3-UnorderedListStyle.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-styleType",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-styleType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1095"
    }
  ],
  "version" : "3.0.0",
  "name" : "StyleType",
  "title" : "Style Type",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The style code is used within the CDA/SPL narrative block to give the instance author some control over various aspects of style.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Specializes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Generalizes"
        }
      ],
      "code" : "Specializes",
      "description" : "The child code is a more narrow version of the concept represented by the parent code.  I.e. Every child concept is also a valid parent concept.  Used to allow determination of subsumption.  Must be transitive, irreflexive, antisymmetric.",
      "type" : "Coding"
    },
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Generalizes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Specializes"
        }
      ],
      "code" : "Generalizes",
      "description" : "Inverse of Specializes.  Only included as a derived relationship.",
      "type" : "Coding"
    },
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Indicates that the code is abstract - only intended to be used as a selector for other concepts",
      "type" : "boolean"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    },
    {
      "code" : "synonymCode",
      "uri" : "http://hl7.org/fhir/concept-properties#synonym",
      "description" : "An additional concept code that was also attributed to a concept",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "_FontStyle",
      "display" : "Font Style",
      "definition" : "Defines font rendering characteristics",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21334"
        }
      ],
      "concept" : [
        {
          "code" : "bold",
          "display" : "Bold Font",
          "definition" : "Render with a bold font",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21335"
            }
          ]
        },
        {
          "code" : "emphasis",
          "display" : "Emphasised Font",
          "definition" : "Render with with some type of emphasis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21338"
            }
          ]
        },
        {
          "code" : "italics",
          "display" : "Italics Font",
          "definition" : "Render italicized",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21337"
            }
          ]
        },
        {
          "code" : "underline",
          "display" : "Underline Font",
          "definition" : "Render with an underline font",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21336"
            }
          ]
        }
      ]
    },
    {
      "code" : "_ListStyle",
      "display" : "List Style",
      "definition" : "Defines list rendering characteristics",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21344"
        }
      ],
      "concept" : [
        {
          "code" : "_OrderedListStyle",
          "display" : "Ordered List Style",
          "definition" : "Defines rendering characteristics for ordered lists",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21345"
            }
          ],
          "concept" : [
            {
              "code" : "Arabic",
              "display" : "Arabic",
              "definition" : "List is ordered using Arabic numerals: 1, 2, 3",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21346"
                }
              ]
            },
            {
              "code" : "BigAlpha",
              "display" : "Big Alpha",
              "definition" : "List is ordered using big alpha characters: A, B, C",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "synonymCode",
                  "valueCode" : "BIG.ALPHA"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21350"
                }
              ]
            },
            {
              "code" : "BIG.ALPHA",
              "display" : "Big Alpha",
              "definition" : "List is ordered using big alpha characters: A, B, C",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "retired"
                },
                {
                  "code" : "synonymCode",
                  "valueCode" : "BigAlpha"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21350"
                }
              ]
            },
            {
              "code" : "BigRoman",
              "display" : "Big Roman",
              "definition" : "List is ordered using big Roman numerals: I, II, III",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "synonymCode",
                  "valueCode" : "BIG.ROMAN"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21348"
                }
              ]
            },
            {
              "code" : "BIG.ROMAN",
              "display" : "Big Roman",
              "definition" : "List is ordered using big Roman numerals: I, II, III",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "retired"
                },
                {
                  "code" : "synonymCode",
                  "valueCode" : "BigRoman"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21348"
                }
              ]
            },
            {
              "code" : "LittleAlpha",
              "display" : "Little Alpha",
              "definition" : "List is order using little alpha characters: a, b, c",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "synonymCode",
                  "valueCode" : "LITTLE.ALPHA"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21349"
                }
              ]
            },
            {
              "code" : "LITTLE.ALPHA",
              "display" : "Little Alpha",
              "definition" : "List is order using little alpha characters: a, b, c",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "retired"
                },
                {
                  "code" : "synonymCode",
                  "valueCode" : "LittleAlpha"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21349"
                }
              ]
            },
            {
              "code" : "LittleRoman",
              "display" : "Little Roman",
              "definition" : "List is ordered using little Roman numerals: i, ii, iii",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "synonymCode",
                  "valueCode" : "LITTLE.ROMAN"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21347"
                }
              ]
            },
            {
              "code" : "LITTLE.ROMAN",
              "display" : "Little Roman",
              "definition" : "List is ordered using little Roman numerals: i, ii, iii",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "retired"
                },
                {
                  "code" : "synonymCode",
                  "valueCode" : "LittleRoman"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21347"
                }
              ]
            }
          ]
        },
        {
          "code" : "_UnorderedListStyle",
          "display" : "Unordered List Style",
          "definition" : "Defines rendering characteristics for unordered lists",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21351"
            }
          ],
          "concept" : [
            {
              "code" : "Circle",
              "display" : "Circle",
              "definition" : "List bullets are hollow discs",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21353"
                }
              ]
            },
            {
              "code" : "Disc",
              "display" : "Disc",
              "definition" : "List bullets are simple solid discs",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21352"
                }
              ]
            },
            {
              "code" : "Square",
              "display" : "Square",
              "definition" : "List bullets are solid squares",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21354"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "_TableRuleStyle",
      "display" : "Table Rule Style",
      "definition" : "Defines table cell rendering characteristics",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21339"
        }
      ],
      "concept" : [
        {
          "code" : "Botrule",
          "display" : "Bottom Rule",
          "definition" : "Render cell with rule on bottom",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21343"
            }
          ]
        },
        {
          "code" : "Lrule",
          "display" : "Left-sided rule",
          "definition" : "Render cell with left-sided rule",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21340"
            }
          ]
        },
        {
          "code" : "Rrule",
          "display" : "Right-sided rule",
          "definition" : "Render cell with right-sided rule",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21341"
            }
          ]
        },
        {
          "code" : "Toprule",
          "display" : "Top Rule",
          "definition" : "Render cell with rule on top",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "synonymCode",
              "valueCode" : "TORULE"
            },
            {
              "code" : "internalId",
              "valueCode" : "21342"
            }
          ]
        },
        {
          "code" : "TORULE",
          "display" : "Top Rule",
          "definition" : "Render cell with rule on top",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "retired"
            },
            {
              "code" : "synonymCode",
              "valueCode" : "Toprule"
            },
            {
              "code" : "internalId",
              "valueCode" : "21342"
            }
          ]
        }
      ]
    }
  ]
}

```
