# RoleClass - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **RoleClass**

## CodeSystem: RoleClass 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-RoleClass | *Version*:4.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:RoleClass |
| *Other Identifiers:*OID:2.16.840.1.113883.5.110 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Codes for the Role class hierarchy. The values in this hierarchy, represent a Role which is an association or relationship between two entities - the entity that plays the role and the entity that scopes the role. Roles names are derived from the name of the playing entity in that role. 
The role hierarchy stems from three core concepts, or abstract domains: 
* **RoleClassOntological** is an abstract domain that collects roles in which the playing entity is defined or specified by the scoping entity.
* **RoleClassPartitive** collects roles in which the playing entity is in some sense a "part" of the scoping entity.
* **RoleClassAssociative** collects all of the remaining forms of association between the playing entity and the scoping entity. This set of roles is further partitioned between:
 
The hierarchy discussed above is represented In the current vocabulary tables as a set of abstract domains, with the exception of the "Personal relationship" which is a leaf concept. 
**OpenIssue:**Description copied from Concept Domain of same name. Must be verified. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [RoleClass](ValueSet-v3-RoleClass.md)
* [RoleClassAccess](ValueSet-v3-RoleClassAccess.md)
* [RoleClassActiveIngredient](ValueSet-v3-RoleClassActiveIngredient.md)
* [RoleClassActiveIngredientBasis](ValueSet-v3-RoleClassActiveIngredientBasis.md)
* [RoleClassActiveIngredientMoietyBasis](ValueSet-v3-RoleClassActiveIngredientMoietyBasis.md)
* [RoleClassActiveIngredientReferenceBasis](ValueSet-v3-RoleClassActiveIngredientReferenceBasis.md)
* [RoleClassActiveMoiety](ValueSet-v3-RoleClassActiveMoiety.md)
* [RoleClassAdditive](ValueSet-v3-RoleClassAdditive.md)
* [RoleClassAdjacency](ValueSet-v3-RoleClassAdjacency.md)
* [RoleClassAdjuvant](ValueSet-v3-RoleClassAdjuvant.md)
* [RoleClassAdministerableMaterial](ValueSet-v3-RoleClassAdministerableMaterial.md)
* [RoleClassAffiliate](ValueSet-v3-RoleClassAffiliate.md)
* [RoleClassAgent](ValueSet-v3-RoleClassAgent.md)
* [RoleClassAliquot](ValueSet-v3-RoleClassAliquot.md)
* [RoleClassAssignedEntity](ValueSet-v3-RoleClassAssignedEntity.md)
* [RoleClassAssociative](ValueSet-v3-RoleClassAssociative.md)
* [RoleClassBase](ValueSet-v3-RoleClassBase.md)
* [RoleClassBirthplace](ValueSet-v3-RoleClassBirthplace.md)
* [RoleClassCaregiver](ValueSet-v3-RoleClassCaregiver.md)
* [RoleClassCaseSubject](ValueSet-v3-RoleClassCaseSubject.md)
* [RoleClassChild](ValueSet-v3-RoleClassChild.md)
* [RoleClassCitizen](ValueSet-v3-RoleClassCitizen.md)
* [RoleClassClaimant](ValueSet-v3-RoleClassClaimant.md)
* [RoleClassClinicalResearchInvestigator](ValueSet-v3-RoleClassClinicalResearchInvestigator.md)
* [RoleClassClinicalResearchSponsor](ValueSet-v3-RoleClassClinicalResearchSponsor.md)
* [RoleClassColorAdditive](ValueSet-v3-RoleClassColorAdditive.md)
* [RoleClassCommissioningParty](ValueSet-v3-RoleClassCommissioningParty.md)
* [RoleClassConnection](ValueSet-v3-RoleClassConnection.md)
* [RoleClassContact](ValueSet-v3-RoleClassContact.md)
* [RoleClassContactCode](ValueSet-v3-RoleClassContactCode.md)
* [RoleClassContaminantIngredient](ValueSet-v3-RoleClassContaminantIngredient.md)
* [RoleClassContent](ValueSet-v3-RoleClassContent.md)
* [RoleClassContinuity](ValueSet-v3-RoleClassContinuity.md)
* [RoleClassCoverageSponsor](ValueSet-v3-RoleClassCoverageSponsor.md)
* [RoleClassCoveredParty](ValueSet-v3-RoleClassCoveredParty.md)
* [RoleClassCredentialedEntity](ValueSet-v3-RoleClassCredentialedEntity.md)
* [RoleClassDedicatedServiceDeliveryLocation](ValueSet-v3-RoleClassDedicatedServiceDeliveryLocation.md)
* [RoleClassDependent](ValueSet-v3-RoleClassDependent.md)
* [RoleClassDistributedMaterial](ValueSet-v3-RoleClassDistributedMaterial.md)
* [RoleClassEmergencyContact](ValueSet-v3-RoleClassEmergencyContact.md)
* [RoleClassEmployee](ValueSet-v3-RoleClassEmployee.md)
* [RoleClassEquivalentEntity](ValueSet-v3-RoleClassEquivalentEntity.md)
* [RoleClassEventLocation](ValueSet-v3-RoleClassEventLocation.md)
* [RoleClassExposedEntity](ValueSet-v3-RoleClassExposedEntity.md)
* [RoleClassExposureAgentCarrier](ValueSet-v3-RoleClassExposureAgentCarrier.md)
* [RoleClassExposureVector](ValueSet-v3-RoleClassExposureVector.md)
* [RoleClassFlavorAdditive](ValueSet-v3-RoleClassFlavorAdditive.md)
* [RoleClassFomite](ValueSet-v3-RoleClassFomite.md)
* [RoleClassGuarantor](ValueSet-v3-RoleClassGuarantor.md)
* [RoleClassGuardian](ValueSet-v3-RoleClassGuardian.md)
* [RoleClassHasGeneric](ValueSet-v3-RoleClassHasGeneric.md)
* [RoleClassHealthChart](ValueSet-v3-RoleClassHealthChart.md)
* [RoleClassHealthcareProvider](ValueSet-v3-RoleClassHealthcareProvider.md)
* [RoleClassHeldEntity](ValueSet-v3-RoleClassHeldEntity.md)
* [RoleClassICSRInvestigationSubject](ValueSet-v3-RoleClassICSRInvestigationSubject.md)
* [RoleClassIdentifiedEntity](ValueSet-v3-RoleClassIdentifiedEntity.md)
* [RoleClassInactiveIngredient](ValueSet-v3-RoleClassInactiveIngredient.md)
* [RoleClassIncidentalServiceDeliveryLocation](ValueSet-v3-RoleClassIncidentalServiceDeliveryLocation.md)
* [RoleClassIndividual](ValueSet-v3-RoleClassIndividual.md)
* [RoleClassIngredientEntity](ValueSet-v3-RoleClassIngredientEntity.md)
* [RoleClassInstance](ValueSet-v3-RoleClassInstance.md)
* [RoleClassInvestigationSubject](ValueSet-v3-RoleClassInvestigationSubject.md)
* [RoleClassInvoicePayor](ValueSet-v3-RoleClassInvoicePayor.md)
* [RoleClassIsSpeciesEntity](ValueSet-v3-RoleClassIsSpeciesEntity.md)
* [RoleClassIsolate](ValueSet-v3-RoleClassIsolate.md)
* [RoleClassLicensedEntity](ValueSet-v3-RoleClassLicensedEntity.md)
* [RoleClassLocatedEntity](ValueSet-v3-RoleClassLocatedEntity.md)
* [RoleClassMaintainedEntity](ValueSet-v3-RoleClassMaintainedEntity.md)
* [RoleClassManagedEntity](ValueSet-v3-RoleClassManagedEntity.md)
* [RoleClassManufacturedProduct](ValueSet-v3-RoleClassManufacturedProduct.md)
* [RoleClassMechanicalIngredient](ValueSet-v3-RoleClassMechanicalIngredient.md)
* [RoleClassMember](ValueSet-v3-RoleClassMember.md)
* [RoleClassMilitaryPerson](ValueSet-v3-RoleClassMilitaryPerson.md)
* [RoleClassMolecularBond](ValueSet-v3-RoleClassMolecularBond.md)
* [RoleClassMolecularFeatures](ValueSet-v3-RoleClassMolecularFeatures.md)
* [RoleClassMolecularPart](ValueSet-v3-RoleClassMolecularPart.md)
* [RoleClassMutualRelationship](ValueSet-v3-RoleClassMutualRelationship.md)
* [RoleClassNamedInsured](ValueSet-v3-RoleClassNamedInsured.md)
* [RoleClassNextOfKin](ValueSet-v3-RoleClassNextOfKin.md)
* [RoleClassNotaryPublic](ValueSet-v3-RoleClassNotaryPublic.md)
* [RoleClassNurse](ValueSet-v3-RoleClassNurse.md)
* [RoleClassNursePractitioner](ValueSet-v3-RoleClassNursePractitioner.md)
* [RoleClassOntological](ValueSet-v3-RoleClassOntological.md)
* [RoleClassOwnedEntity](ValueSet-v3-RoleClassOwnedEntity.md)
* [RoleClassPart](ValueSet-v3-RoleClassPart.md)
* [RoleClassPartitive](ValueSet-v3-RoleClassPartitive.md)
* [RoleClassPassive](ValueSet-v3-RoleClassPassive.md)
* [RoleClassPatient](ValueSet-v3-RoleClassPatient.md)
* [RoleClassPayee](ValueSet-v3-RoleClassPayee.md)
* [RoleClassPersonalRelationship](ValueSet-v3-RoleClassPersonalRelationship.md)
* [RoleClassPhysician](ValueSet-v3-RoleClassPhysician.md)
* [RoleClassPhysicianAssistant](ValueSet-v3-RoleClassPhysicianAssistant.md)
* [RoleClassPlaceOfDeath](ValueSet-v3-RoleClassPlaceOfDeath.md)
* [RoleClassPolicyHolder](ValueSet-v3-RoleClassPolicyHolder.md)
* [RoleClassPreservative](ValueSet-v3-RoleClassPreservative.md)
* [RoleClassProductRelated](ValueSet-v3-RoleClassProductRelated.md)
* [RoleClassProgramEligible](ValueSet-v3-RoleClassProgramEligible.md)
* [RoleClassQualifiedEntity](ValueSet-v3-RoleClassQualifiedEntity.md)
* [RoleClassRegulatedProduct](ValueSet-v3-RoleClassRegulatedProduct.md)
* [RoleClassRelationshipFormal](ValueSet-v3-RoleClassRelationshipFormal.md)
* [RoleClassResearchSubject](ValueSet-v3-RoleClassResearchSubject.md)
* [RoleClassRetailedMaterial](ValueSet-v3-RoleClassRetailedMaterial.md)
* [RoleClassRoot](ValueSet-v3-RoleClassRoot.md)
* [RoleClassSame](ValueSet-v3-RoleClassSame.md)
* [RoleClassServiceDeliveryLocation](ValueSet-v3-RoleClassServiceDeliveryLocation.md)
* [RoleClassSigningAuthorityOrOfficer](ValueSet-v3-RoleClassSigningAuthorityOrOfficer.md)
* [RoleClassSpecimen](ValueSet-v3-RoleClassSpecimen.md)
* [RoleClassStabilizer](ValueSet-v3-RoleClassStabilizer.md)
* [RoleClassStoredEntity](ValueSet-v3-RoleClassStoredEntity.md)
* [RoleClassStudent](ValueSet-v3-RoleClassStudent.md)
* [RoleClassSubscriber](ValueSet-v3-RoleClassSubscriber.md)
* [RoleClassSubstancePresence](ValueSet-v3-RoleClassSubstancePresence.md)
* [RoleClassSubsumedBy](ValueSet-v3-RoleClassSubsumedBy.md)
* [RoleClassSubsumer](ValueSet-v3-RoleClassSubsumer.md)
* [RoleClassTerritoryOfAuthority](ValueSet-v3-RoleClassTerritoryOfAuthority.md)
* [RoleClassTherapeuticAgent](ValueSet-v3-RoleClassTherapeuticAgent.md)
* [RoleClassUnderwriter](ValueSet-v3-RoleClassUnderwriter.md)
* [RoleClassUsedEntity](ValueSet-v3-RoleClassUsedEntity.md)
* [RoleClassWarrantedProduct](ValueSet-v3-RoleClassWarrantedProduct.md)
* [XAccommodationRequestorRole](ValueSet-v3-xAccommodationRequestorRole.md)
* [XDocumentEntrySubject](ValueSet-v3-xDocumentEntrySubject.md)
* [XDocumentSubject](ValueSet-v3-xDocumentSubject.md)
* [XInformationRecipientRole](ValueSet-v3-xInformationRecipientRole.md)
* [XRoleClassAccommodationRequestor](ValueSet-v3-xRoleClassAccommodationRequestor.md)
* [XRoleClassCoverage](ValueSet-v3-xRoleClassCoverage.md)
* [XRoleClassCoverageInvoice](ValueSet-v3-xRoleClassCoverageInvoice.md)
* [XRoleClassCredentialedEntity](ValueSet-v3-xRoleClassCredentialedEntity.md)
* [XRoleClassPayeePolicyRelationship](ValueSet-v3-xRoleClassPayeePolicyRelationship.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-RoleClass",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-RoleClass",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.110"
    }
  ],
  "version" : "4.0.0",
  "name" : "RoleClass",
  "title" : "RoleClass",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Codes for the Role class hierarchy. The values in this hierarchy, represent a Role which is an association or relationship between two entities - the entity that plays the role and the entity that scopes the role. Roles names are derived from the name of the playing entity in that role.\r\n\r\nThe role hierarchy stems from three core concepts, or abstract domains:\r\n\r\n *  **RoleClassOntological** is an abstract domain that collects roles in which the playing entity is defined or specified by the scoping entity.\r\n *  **RoleClassPartitive** collects roles in which the playing entity is in some sense a \"part\" of the scoping entity.\r\n *  **RoleClassAssociative** collects all of the remaining forms of association between the playing entity and the scoping entity. This set of roles is further partitioned between:\r\n    \r\n     *  **RoleClassPassive** which are roles in which the playing entity is used, known, treated, handled, built, or destroyed, etc. under the auspices of the scoping entity. The playing entity is passive in these roles in that the role exists without an agreement from the playing entity.\r\n     *  **RoleClassMutualRelationship** which are relationships based on mutual behavior of the two entities. The basis of these relationship may be formal agreements or they may be *de facto* behavior. Thus, this sub-domain is further divided into:\r\n        \r\n         *  **RoleClassRelationshipFormal** in which the relationship is formally defined, frequently by a contract or agreement.\r\n         *  **Personal relationship** which inks two people in a personal relationship.\r\n\r\nThe hierarchy discussed above is represented In the current vocabulary tables as a set of abstract domains, with the exception of the \"Personal relationship\" which is a leaf concept.\r\n\r\n*OpenIssue:* Description copied from Concept Domain of same name. Must be verified.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Specializes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Generalizes"
        }
      ],
      "code" : "Specializes",
      "description" : "The child code is a more narrow version of the concept represented by the parent code.  I.e. Every child concept is also a valid parent concept.  Used to allow determination of subsumption.  Must be transitive, irreflexive, antisymmetric.",
      "type" : "Coding"
    },
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Generalizes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Specializes"
        }
      ],
      "code" : "Generalizes",
      "description" : "Inverse of Specializes.  Only included as a derived relationship.",
      "type" : "Coding"
    },
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A property that indicates the status of the concept. One of active, experimental, deprecated, or retired.",
      "type" : "code"
    },
    {
      "code" : "deprecationDate",
      "uri" : "http://hl7.org/fhir/concept-properties#deprecationDate",
      "description" : "The date at which a concept was deprecated. Concepts that are deprecated but not inactive can still be used, but their use is discouraged.",
      "type" : "dateTime"
    },
    {
      "code" : "Name:Class",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-Class",
      "description" : "The formal name for the class clone under this code",
      "type" : "string"
    },
    {
      "code" : "Name:Role:player:Entity",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-Role-player",
      "description" : "The name of the relationship from Role to the payer Entity",
      "type" : "string"
    },
    {
      "code" : "Name:Role:scoper:Entity",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-Role-scoper",
      "description" : "The name of the relationship from Role to the scoper Entity",
      "type" : "string"
    },
    {
      "code" : "Sort:Entity:playedRole:Role",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-Entity-played-sort",
      "description" : "Sort key for the relationship from the Entity to the playedRole",
      "type" : "string"
    },
    {
      "code" : "Sort:Entity:scopedRole:Role",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-Entity-scoped-sort",
      "description" : "The sort key for the relationship from the Entity to the scopedRole",
      "type" : "string"
    },
    {
      "code" : "Name:Entity:playedRole:Role",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-Entity-played",
      "description" : "The name of the relationship from the Entity to the playedRole",
      "type" : "string"
    },
    {
      "code" : "Name:Entity:scopedRole:Role",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-Entity-scoped",
      "description" : "The name of the relationship from the Entity to the scopedRole",
      "type" : "string"
    },
    {
      "code" : "Name:Participation:role:Role",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#rim-Participation-role",
      "description" : "The name of the relationship from Participation to Role",
      "type" : "string"
    },
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Indicates that the code is abstract - only intended to be used as a selector for other concepts",
      "type" : "boolean"
    }
  ],
  "concept" : [
    {
      "code" : "ROL",
      "display" : "role",
      "definition" : "Corresponds to the Role class",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13940"
        },
        {
          "code" : "Name:Class",
          "valueString" : "role"
        },
        {
          "code" : "Name:Entity:playedRole:Role",
          "valueString" : "as&"
        },
        {
          "code" : "Name:Entity:scopedRole:Role",
          "valueString" : "&"
        },
        {
          "code" : "Name:Participation:role:Role",
          "valueString" : "&"
        },
        {
          "code" : "Name:Role:player:Entity",
          "valueString" : "(playing&)|player"
        },
        {
          "code" : "Name:Role:scoper:Entity",
          "valueString" : "(scoping&)|scoper"
        },
        {
          "code" : "Sort:Entity:playedRole:Role",
          "valueString" : "A________"
        },
        {
          "code" : "Sort:Entity:scopedRole:Role",
          "valueString" : "A________"
        }
      ],
      "concept" : [
        {
          "code" : "_RoleClassAssociative",
          "display" : "RoleClassAssociative",
          "definition" : "A general association between two entities that is neither partitive nor ontological.",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21113"
            },
            {
              "code" : "Name:Class",
              "valueString" : "associatedEntity"
            },
            {
              "code" : "Name:Role:player:Entity",
              "valueString" : "associated&"
            },
            {
              "code" : "Name:Role:scoper:Entity",
              "valueString" : "scoping&"
            },
            {
              "code" : "Sort:Entity:playedRole:Role",
              "valueString" : "AA_______"
            },
            {
              "code" : "Sort:Entity:scopedRole:Role",
              "valueString" : "AA_______"
            },
            {
              "code" : "Name:Entity:playedRole:Role",
              "valueString" : "as&"
            },
            {
              "code" : "Name:Entity:scopedRole:Role",
              "valueString" : "&"
            },
            {
              "code" : "Name:Participation:role:Role",
              "valueString" : "&"
            }
          ],
          "concept" : [
            {
              "code" : "_RoleClassMutualRelationship",
              "display" : "RoleClassMutualRelationship",
              "definition" : "A relationship that is based on mutual behavior of the two Entities as being related. The basis of such relationship may be agreements (e.g., spouses, contract parties) or they may be *de facto* behavior (e.g. friends) or may be an incidental involvement with each other (e.g. parties over a dispute, siblings, children).",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21114"
                },
                {
                  "code" : "Name:Class",
                  "valueString" : "relatedEntity"
                },
                {
                  "code" : "Name:Role:player:Entity",
                  "valueString" : "related&"
                },
                {
                  "code" : "Name:Role:scoper:Entity",
                  "valueString" : "scoping&"
                },
                {
                  "code" : "Sort:Entity:playedRole:Role",
                  "valueString" : "AAA______"
                },
                {
                  "code" : "Sort:Entity:scopedRole:Role",
                  "valueString" : "AAA______"
                },
                {
                  "code" : "Name:Entity:playedRole:Role",
                  "valueString" : "as&"
                },
                {
                  "code" : "Name:Entity:scopedRole:Role",
                  "valueString" : "&"
                },
                {
                  "code" : "Name:Participation:role:Role",
                  "valueString" : "&"
                }
              ],
              "concept" : [
                {
                  "code" : "_RoleClassRelationshipFormal",
                  "display" : "RoleClassRelationshipFormal",
                  "definition" : "A relationship between two entities that is formally recognized, frequently by a contract or similar agreement.",
                  "property" : [
                    {
                      "code" : "notSelectable",
                      "valueBoolean" : true
                    },
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "21118"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "formalRelation"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "related&"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "related&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "AAAA_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "AAAA_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "AFFL",
                      "display" : "affiliate",
                      "definition" : "Player of the Affiliate role has a business/professional relationship with scoper. Player and scoper may be persons or organization. The Affiliate relationship does not imply membership in a group, nor does it exist for resource scheduling purposes.\r\n\r\n*Example:* A healthcare provider is affiliated with another provider as a business associate.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "21438"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "affiliate"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueString" : "affiliate&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueString" : "affiliated&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueString" : "AAAAR____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueString" : "AAAAR____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "AGNT",
                      "display" : "agent",
                      "definition" : "An entity (player) that acts or is authorized to act on behalf of another entity (scoper).",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "14006"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "agent"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueString" : "agent&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueString" : "(represented&)|representee"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueString" : "AAAAD____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueString" : "AAAAD____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "ASSIGNED",
                          "display" : "assigned entity",
                          "definition" : "An agent role in which the agent is an Entity acting in the employ of an organization. The focus is on functional role on behalf of the organization, unlike the Employee role where the focus is on the 'Human Resources' relationship between the employee and the organization.",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "11595"
                            },
                            {
                              "code" : "Name:Class",
                              "valueString" : "assignedEntity"
                            },
                            {
                              "code" : "Name:Role:player:Entity",
                              "valueString" : "(assigned&)|assignee"
                            },
                            {
                              "code" : "Name:Role:scoper:Entity",
                              "valueString" : "(represented&)|representee"
                            },
                            {
                              "code" : "Sort:Entity:playedRole:Role",
                              "valueString" : "AAAADA___"
                            },
                            {
                              "code" : "Sort:Entity:scopedRole:Role",
                              "valueString" : "AAAADA___"
                            },
                            {
                              "code" : "Name:Entity:playedRole:Role",
                              "valueString" : "as&"
                            },
                            {
                              "code" : "Name:Entity:scopedRole:Role",
                              "valueString" : "&"
                            },
                            {
                              "code" : "Name:Participation:role:Role",
                              "valueString" : "&"
                            }
                          ],
                          "concept" : [
                            {
                              "code" : "COMPAR",
                              "display" : "commissioning party",
                              "definition" : "An Entity that is authorized to issue or instantiate permissions, privileges, credentials or other formal/legal authorizations.",
                              "property" : [
                                {
                                  "code" : "status",
                                  "valueCode" : "active"
                                },
                                {
                                  "code" : "internalId",
                                  "valueCode" : "21303"
                                },
                                {
                                  "code" : "Name:Class",
                                  "valueString" : "commissioningParty"
                                },
                                {
                                  "code" : "Name:Role:player:Entity",
                                  "valueString" : "commissioning&"
                                },
                                {
                                  "code" : "Name:Role:scoper:Entity",
                                  "valueString" : "commissioningScoper"
                                },
                                {
                                  "code" : "Sort:Entity:playedRole:Role",
                                  "valueString" : "AAAADAC__"
                                },
                                {
                                  "code" : "Sort:Entity:scopedRole:Role",
                                  "valueString" : "AAAADAC__"
                                },
                                {
                                  "code" : "Name:Entity:playedRole:Role",
                                  "valueString" : "as&"
                                },
                                {
                                  "code" : "Name:Entity:scopedRole:Role",
                                  "valueString" : "&"
                                },
                                {
                                  "code" : "Name:Participation:role:Role",
                                  "valueString" : "&"
                                }
                              ]
                            },
                            {
                              "code" : "SGNOFF",
                              "display" : "signing authority or officer",
                              "definition" : "The role of a person (player) who is the officer or signature authority for of a scoping entity, usually an organization (scoper).",
                              "property" : [
                                {
                                  "code" : "status",
                                  "valueCode" : "active"
                                },
                                {
                                  "code" : "internalId",
                                  "valueCode" : "14007"
                                },
                                {
                                  "code" : "Name:Class",
                                  "valueString" : "signatureAuthority"
                                },
                                {
                                  "code" : "Name:Role:player:Entity",
                                  "valueString" : "signing(&|Authority)"
                                },
                                {
                                  "code" : "Name:Role:scoper:Entity",
                                  "valueString" : "(represented&)|representee"
                                },
                                {
                                  "code" : "Sort:Entity:playedRole:Role",
                                  "valueString" : "AAAADAB__"
                                },
                                {
                                  "code" : "Sort:Entity:scopedRole:Role",
                                  "valueString" : "AAAADAB__"
                                },
                                {
                                  "code" : "Name:Entity:playedRole:Role",
                                  "valueString" : "as&"
                                },
                                {
                                  "code" : "Name:Entity:scopedRole:Role",
                                  "valueString" : "&"
                                },
                                {
                                  "code" : "Name:Participation:role:Role",
                                  "valueString" : "&"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "code" : "CON",
                          "display" : "contact",
                          "definition" : "A person or an organization (player) which provides or receives information regarding another entity (scoper). Examples; patient NOK and emergency contacts; guarantor contact; employer contact.",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "12205"
                            },
                            {
                              "code" : "Name:Class",
                              "valueString" : "contactParty"
                            },
                            {
                              "code" : "Name:Role:player:Entity",
                              "valueString" : "contact(&|Party)"
                            },
                            {
                              "code" : "Name:Role:scoper:Entity",
                              "valueString" : "(represented&)|representee"
                            },
                            {
                              "code" : "Sort:Entity:playedRole:Role",
                              "valueString" : "AAAADAA__"
                            },
                            {
                              "code" : "Sort:Entity:scopedRole:Role",
                              "valueString" : "AAAADAA__"
                            },
                            {
                              "code" : "Name:Entity:playedRole:Role",
                              "valueString" : "as&"
                            },
                            {
                              "code" : "Name:Entity:scopedRole:Role",
                              "valueString" : "&"
                            },
                            {
                              "code" : "Name:Participation:role:Role",
                              "valueString" : "&"
                            }
                          ],
                          "concept" : [
                            {
                              "code" : "ECON",
                              "display" : "emergency contact",
                              "definition" : "An entity to be contacted in the event of an emergency.",
                              "property" : [
                                {
                                  "code" : "status",
                                  "valueCode" : "active"
                                },
                                {
                                  "code" : "internalId",
                                  "valueCode" : "19140"
                                },
                                {
                                  "code" : "Name:Class",
                                  "valueString" : "emergencyContact"
                                },
                                {
                                  "code" : "Name:Role:player:Entity",
                                  "valueString" : "emergencyContact(&|Party)"
                                },
                                {
                                  "code" : "Name:Role:scoper:Entity",
                                  "valueString" : "(represented&)|representee"
                                },
                                {
                                  "code" : "Sort:Entity:playedRole:Role",
                                  "valueString" : "AAAADAAB_"
                                },
                                {
                                  "code" : "Sort:Entity:scopedRole:Role",
                                  "valueString" : "AAAADAAB_"
                                },
                                {
                                  "code" : "Name:Entity:playedRole:Role",
                                  "valueString" : "as&"
                                },
                                {
                                  "code" : "Name:Entity:scopedRole:Role",
                                  "valueString" : "&"
                                },
                                {
                                  "code" : "Name:Participation:role:Role",
                                  "valueString" : "&"
                                }
                              ]
                            },
                            {
                              "code" : "NOK",
                              "display" : "next of kin",
                              "definition" : "An individual designated for notification as the next of kin for a given entity.",
                              "property" : [
                                {
                                  "code" : "status",
                                  "valueCode" : "active"
                                },
                                {
                                  "code" : "internalId",
                                  "valueCode" : "19141"
                                },
                                {
                                  "code" : "Name:Class",
                                  "valueString" : "nextOfKin"
                                },
                                {
                                  "code" : "Name:Role:player:Entity",
                                  "valueString" : "nextOfKinContact&"
                                },
                                {
                                  "code" : "Name:Role:scoper:Entity",
                                  "valueString" : "(represented&)|representee"
                                },
                                {
                                  "code" : "Sort:Entity:playedRole:Role",
                                  "valueString" : "AAAADAAA_"
                                },
                                {
                                  "code" : "Sort:Entity:scopedRole:Role",
                                  "valueString" : "AAAADAAA_"
                                },
                                {
                                  "code" : "Name:Entity:playedRole:Role",
                                  "valueString" : "as&"
                                },
                                {
                                  "code" : "Name:Entity:scopedRole:Role",
                                  "valueString" : "&"
                                },
                                {
                                  "code" : "Name:Participation:role:Role",
                                  "valueString" : "&"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "code" : "GUARD",
                          "display" : "guardian",
                          "definition" : "Guardian of a ward",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "16324"
                            },
                            {
                              "code" : "Name:Class",
                              "valueString" : "guardian"
                            },
                            {
                              "code" : "Name:Role:player:Entity",
                              "valueString" : "guardian&"
                            },
                            {
                              "code" : "Name:Role:scoper:Entity",
                              "valueString" : "ward&"
                            },
                            {
                              "code" : "Sort:Entity:playedRole:Role",
                              "valueString" : "AAAADB___"
                            },
                            {
                              "code" : "Sort:Entity:scopedRole:Role",
                              "valueString" : "AAAADB___"
                            },
                            {
                              "code" : "Name:Entity:playedRole:Role",
                              "valueString" : "as&"
                            },
                            {
                              "code" : "Name:Entity:scopedRole:Role",
                              "valueString" : "&"
                            },
                            {
                              "code" : "Name:Participation:role:Role",
                              "valueString" : "&"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "code" : "CIT",
                      "display" : "citizen",
                      "definition" : "Citizen of apolitical entity",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "11568"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "citizen"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueString" : "citizen&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueString" : "political(&|Entity)"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueString" : "AAAAF____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueString" : "AAAAF____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "COVPTY",
                      "display" : "covered party",
                      "definition" : "A role class played by a person who receives benefit coverage under the terms of a particular insurance policy. The underwriter of that policy is the scoping entity. The covered party receives coverage because of some contractual or other relationship with the holder of that policy.\r\n\r\n*Discussion:*This reason for coverage is captured in 'Role.code' and a relationship link with type code of indirect authority should be included using the policy holder role as the source, and the covered party role as the target.\r\n\r\nNote that a particular policy may cover several individuals one of whom may be, but need not be, the policy holder. Thus the notion of covered party is a role that is distinct from that of the policy holder.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "14011"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "coveredParty"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueString" : "covered(&|Party)"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueString" : "(underwriting&)|underwriter"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueString" : "AAAAI____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueString" : "AAAAI____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "CLAIM",
                          "display" : "claimant",
                          "definition" : "**Description:** A role played by a party making a claim for coverage under a policy or program. A claimant must be either a person or organization, or a group of persons or organizations. A claimant is not a named insured or a program eligible.\r\n\r\n**Discussion:** With respect to liability insurance such as property and casualty insurance, a claimant must file a claim requesting indemnification for a loss that the claimant considers covered under the policy of a named insured. The claims adjuster for the policy underwriter will review the claim to determine whether the loss meets the benefit coverage criteria under a policy, and base any indemnification or coverage payment on that review. If a third party is liable in whole or part for the loss, the underwriter may pursue third party liability recovery. A claimant may be involved in civil or criminal legal proceedings involving claims against a defendant party that is indemnified by an insurance policy or to protest the finding of a claims adjustor. With respect to life insurance, a beneficiary designated by a named insured becomes a claimant of the proceeds of coverage, as in the case of a life insurance policy. However, a claimant for coverage under life insurance is not necessarily a designated beneficiary.\r\n\r\n**Note:** A claimant is not a named insured. However, a named insured may make a claim under a policy, e.g., an insured driver may make a claim for an injury under his or her comprehensive automobile insurance policy. Similarly, a program eligible may make a claim under program, e.g., an unemployed worker may claim benefits under an unemployment insurance program, but parties playing these covered party role classes are not, for purposes of this vocabulary and in an effort to clearly distinguish role classes, considered claimants.\r\n\r\nIn the case of a named insured making a claim, a role type code INSCLM (insured claimant) subtypes the class to indicate that either a named insured or an individual insured has filed a claim for a loss. In the case of a program eligible, a role type code INJWKR (injured worker) subtypes the class to indicate that the covered party in a workers compensation program is an injured worker, and as such, has filed a \"claim\" under the program for benefits. Likewise, a covered role type code UNEMP (unemployed worker) subtypes the program eligible class to indicate that the covered party in an unemployment insurance program has filed a claim for unemployment benefits.\r\n\r\n**Example:** A claimant under automobile policy that is not the named insured.",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "21955"
                            },
                            {
                              "code" : "Name:Class",
                              "valueString" : "claimant"
                            },
                            {
                              "code" : "Name:Entity:playedRole:Role",
                              "valueString" : "as&"
                            },
                            {
                              "code" : "Name:Entity:scopedRole:Role",
                              "valueString" : "&"
                            },
                            {
                              "code" : "Name:Participation:role:Role",
                              "valueString" : "&"
                            }
                          ]
                        },
                        {
                          "code" : "NAMED",
                          "display" : "named insured",
                          "definition" : "**Description:** A role played by a party to an insurance policy to which the insurer agrees to indemnify for losses, provides benefits for, or renders services. A named insured may be either a person, non-person living subject, or an organization, or a group of persons, non-person living subjects, or organizations.\r\n\r\n**Discussion:** The coded concept NAMED should not be used where a more specific child concept in this Specializable value set applies. In some cases, the named insured may not be the policy holder, e.g., where a policy holder purchases life insurance policy in which another party is the named insured and the policy holder is the beneficiary of the policy.\r\n\r\n**Note:** The party playing the role of a named insured is not a claimant in the sense conveyed by the RoleClassCoveredParty CLAIM (claimant). However, a named insured may make a claim under a policy, e.g., e.g., a party that is the named insured and policy holder under a comprehensive automobile insurance policy may become the claimant for coverage under that policy e.g., if injured in an automobile accident and there is no liable third party. In the case of a named insured making a claim, a role type code INSCLM (insured claimant) subtypes the class to indicate that a named insured has filed a claim for a loss.\r\n\r\n**Example:** The named insured under a comprehensive automobile, disability, or property and casualty policy that is the named insured and may or may not be the policy holder.",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "21957"
                            },
                            {
                              "code" : "Name:Class",
                              "valueString" : "namedInsured"
                            },
                            {
                              "code" : "Name:Entity:playedRole:Role",
                              "valueString" : "as&"
                            },
                            {
                              "code" : "Name:Entity:scopedRole:Role",
                              "valueString" : "&"
                            },
                            {
                              "code" : "Name:Participation:role:Role",
                              "valueString" : "&"
                            }
                          ],
                          "concept" : [
                            {
                              "code" : "DEPEN",
                              "display" : "dependent",
                              "definition" : "**Description:** A role played by a person covered under a policy or program based on an association with a subscriber, which is recognized by the policy holder.\r\n\r\n**Note:** The party playing the role of a dependent is not a claimant in the sense conveyed by the RoleClassCoveredParty CLAIM (claimant). However, a dependent may make a claim under a policy, e.g., a dependent under a health insurance policy may become the claimant for coverage under that policy for wellness examines or if injured and there is no liable third party. In the case of a dependent making a claim, a role type code INSCLM (insured claimant) subtypes the class to indicate that the dependent has filed a claim for services covered under the health insurance policy.\r\n\r\n**Example:** The dependent has an association with the subscriber such as a financial dependency or personal relationship such as that of a spouse, or a natural or adopted child. The policy holder may be required by law to recognize certain associations or may have discretion about the associations. For example, a policy holder may dictate the criteria for the dependent status of adult children who are students, such as requiring full time enrollment, or may recognize domestic partners as dependents. Under certain circumstances, the dependent may be under the indirect authority of a responsible party acting as a surrogate for the subscriber, for example, if the subscriber is differently abled or deceased, a guardian ad Lidem or estate executor may be appointed to assume the subscriberaTMs legal standing in the relationship with the dependent.",
                              "property" : [
                                {
                                  "code" : "status",
                                  "valueCode" : "active"
                                },
                                {
                                  "code" : "internalId",
                                  "valueCode" : "21960"
                                },
                                {
                                  "code" : "Name:Class",
                                  "valueString" : "dependent"
                                },
                                {
                                  "code" : "Name:Entity:playedRole:Role",
                                  "valueString" : "as&"
                                },
                                {
                                  "code" : "Name:Entity:scopedRole:Role",
                                  "valueString" : "&"
                                },
                                {
                                  "code" : "Name:Participation:role:Role",
                                  "valueString" : "&"
                                }
                              ]
                            },
                            {
                              "code" : "INDIV",
                              "display" : "individual",
                              "definition" : "**Description:** A role played by a party covered under a policy as the policy holder. An individual may be either a person or an organization.\r\n\r\n**Note:** The party playing the role of an individual insured is not a claimant in the sense conveyed by the RoleClassCoveredParty CLAIM (claimant). However, a named insured may make a claim under a policy, e.g., a party that is the named insured and policy holder under a comprehensive automobile insurance policy may become the claimant for coverage under that policy if injured in an automobile accident and there is no liable third party. In the case of an individual insured making a claim, a role type code INSCLM (insured claimant) subtypes the class to indicate that an individual insured has filed a claim for a loss.\r\n\r\n**Example:** The individual insured under a comprehensive automobile, disability, or property and casualty policy that is the policy holder.",
                              "property" : [
                                {
                                  "code" : "status",
                                  "valueCode" : "active"
                                },
                                {
                                  "code" : "internalId",
                                  "valueCode" : "21958"
                                },
                                {
                                  "code" : "Name:Class",
                                  "valueString" : "individual"
                                },
                                {
                                  "code" : "Name:Entity:playedRole:Role",
                                  "valueString" : "as&"
                                },
                                {
                                  "code" : "Name:Entity:scopedRole:Role",
                                  "valueString" : "&"
                                },
                                {
                                  "code" : "Name:Participation:role:Role",
                                  "valueString" : "&"
                                }
                              ]
                            },
                            {
                              "code" : "SUBSCR",
                              "display" : "subscriber",
                              "definition" : "**Description:** A role played by a person covered under a policy based on association with a sponsor who is the policy holder, and whose association may provide for the eligibility of dependents for coverage.\r\n\r\n**Discussion:** The policy holder holds the contract with the policy or program underwriter. The subscriber holds a certificate of coverage under the contract. In legal proceedings concerning the policy or program, the terms of the contract takes precedence over the terms of the certificate of coverage if there are any inconsistencies.\r\n\r\n**Note:** The party playing the role of a subscriber is not a claimant in the sense conveyed by the RoleClassCoveredParty CLAIM (claimant). However, a subscriber may make a claim under a policy, e.g., a subscriber under a health insurance policy may become the claimant for coverage under that policy for wellness examines or if injured and there is no liable third party. In the case of a subscriber making a claim, a role type code INSCLM (insured claimant) subtypes the class to indicate that the subscriber has filed a claim for services covered under the health insurance policy.\r\n\r\n**Example:** An employee or a member of an association.",
                              "property" : [
                                {
                                  "code" : "status",
                                  "valueCode" : "active"
                                },
                                {
                                  "code" : "internalId",
                                  "valueCode" : "21959"
                                },
                                {
                                  "code" : "Name:Class",
                                  "valueString" : "subscriber"
                                },
                                {
                                  "code" : "Name:Entity:playedRole:Role",
                                  "valueString" : "as&"
                                },
                                {
                                  "code" : "Name:Entity:scopedRole:Role",
                                  "valueString" : "&"
                                },
                                {
                                  "code" : "Name:Participation:role:Role",
                                  "valueString" : "&"
                                }
                              ]
                            }
                          ]
                        },
                        {
                          "code" : "PROG",
                          "display" : "program eligible",
                          "definition" : "**Description:** A role played by a party that meets the eligibility criteria for coverage under a program. A program eligible may be either a person, non-person living subject, or an organization, or a group of persons, non-person living subjects, or organizations.\r\n\r\n**Discussion:** A program as typically government administered coverage for parties determined eligible under the terms of the program.\r\n\r\n**Note:** The party playing a program eligible is not a claimant in the sense conveyed by the RoleClassCoveredParty CLAIM (claimant). However a program eligible may make a claim under program, e.g., an unemployed worker may claim benefits under an unemployment insurance program, but parties playing these covered party role classes are not, for purposes of this vocabulary and in an effort to clearly distinguish role classes, considered claimants.\r\n\r\nIn the case of a program eligible, a role type code INJWKR (injured worker) subtypes the class to indicate that the covered party in a workers compensation program is an injured worker, and as such, has filed a \"claim\" under the program for benefits. Likewise, a covered role type code UNEMP (unemployed worker) subtypes the program eligible class to indicate that the covered party in an unemployment insurance program has filed a claim for unemployment benefits.\r\n\r\n**Example:** A party meeting eligibility criteria related to health or financial status, e.g., in the U.S., persons meeting health, demographic, or financial criteria established by state and federal law are eligible for Medicaid.",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "21956"
                            },
                            {
                              "code" : "Name:Class",
                              "valueString" : "programEligible"
                            },
                            {
                              "code" : "Name:Entity:playedRole:Role",
                              "valueString" : "as&"
                            },
                            {
                              "code" : "Name:Entity:scopedRole:Role",
                              "valueString" : "&"
                            },
                            {
                              "code" : "Name:Participation:role:Role",
                              "valueString" : "&"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "code" : "CRINV",
                      "display" : "clinical research investigator",
                      "definition" : "A role played by a provider, always a person, who has agency authority from a Clinical Research Sponsor to direct the conduct of a clinical research trial or study on behalf of the sponsor.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "19164"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "clinicalResearchInvestigator"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueString" : "investigator&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueString" : "sponsoring&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueString" : "AAAAH____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueString" : "AAAAH____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "CRSPNSR",
                      "display" : "clinical research sponsor",
                      "definition" : "A role played by an entity, usually an organization, that is the sponsor of a clinical research trial or study. The sponsor commissions the study, bears the expenses, is responsible for satisfying all legal requirements concerning subject safety and privacy, and is generally responsible for collection, storage and analysis of the data generated during the trial. No scoper is necessary, as a clinical research sponsor undertakes the role on its own authority and declaration. Clinical research sponsors are usually educational or other research organizations, government agencies or biopharmaceutical companies.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "19165"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "clinicalResearchSponsor"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueString" : "sponsor&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueString" : "sponsorshipAuthorizing&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueString" : "AAAAG____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueString" : "AAAAG____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "EMP",
                      "display" : "employee",
                      "definition" : "A relationship between a person or organization and a person or organization formed for the purpose of exchanging work for compensation. The purpose of the role is to identify the type of relationship the employee has to the employer, rather than the nature of the work actually performed. (Contrast with AssignedEntity.)",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "11569"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "employment"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueString" : "employee&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueString" : "employer&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueString" : "AAAAE____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueString" : "AAAAE____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "MIL",
                          "display" : "military person",
                          "definition" : "A role played by a member of a military service. Scoper is the military service (e.g. Army, Navy, Air Force, etc.) or, more specifically, the unit (e.g. Company C, 3rd Battalion, 4th Division, etc.)",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "11570"
                            },
                            {
                              "code" : "Name:Class",
                              "valueString" : "militaryPerson"
                            },
                            {
                              "code" : "Name:Role:player:Entity",
                              "valueString" : "military&"
                            },
                            {
                              "code" : "Name:Role:scoper:Entity",
                              "valueString" : "militaryService(&-ORG)"
                            },
                            {
                              "code" : "Sort:Entity:playedRole:Role",
                              "valueString" : "AAAAEA___"
                            },
                            {
                              "code" : "Sort:Entity:scopedRole:Role",
                              "valueString" : "AAAAEA___"
                            },
                            {
                              "code" : "Name:Entity:playedRole:Role",
                              "valueString" : "as&"
                            },
                            {
                              "code" : "Name:Entity:scopedRole:Role",
                              "valueString" : "&"
                            },
                            {
                              "code" : "Name:Participation:role:Role",
                              "valueString" : "&"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "code" : "GUAR",
                      "display" : "guarantor",
                      "definition" : "A person or organization (player) that serves as a financial guarantor for another person or organization (scoper).",
                      "designation" : [
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "GuarantorRole"
                        }
                      ],
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "13941"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "guarantor"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueString" : "guarantor&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueString" : "promisor&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueString" : "AAAAJ____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueString" : "AAAAJ____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "INVSBJ",
                      "display" : "Investigation Subject",
                      "definition" : "An entity that is the subject of an investigation. This role is scoped by the party responsible for the investigation.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "21464"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "investigativeSubject"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueString" : "subject&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueString" : "investigationSponsor"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueString" : "AAAAB____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueString" : "AAAAB____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "CASEBJ",
                          "display" : "Case Subject",
                          "definition" : "A person, non-person living subject, or place that is the subject of an investigation related to a notifiable condition (health circumstance that is reportable within the applicable public health jurisdiction)",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "21465"
                            },
                            {
                              "code" : "Name:Class",
                              "valueString" : "caseSubject"
                            },
                            {
                              "code" : "Name:Role:player:Entity",
                              "valueString" : "subject&"
                            },
                            {
                              "code" : "Name:Role:scoper:Entity",
                              "valueString" : "caseMonitor"
                            },
                            {
                              "code" : "Sort:Entity:playedRole:Role",
                              "valueString" : "AAAABA___"
                            },
                            {
                              "code" : "Sort:Entity:scopedRole:Role",
                              "valueString" : "AAAABA___"
                            },
                            {
                              "code" : "Name:Entity:playedRole:Role",
                              "valueString" : "as&"
                            },
                            {
                              "code" : "Name:Entity:scopedRole:Role",
                              "valueString" : "&"
                            },
                            {
                              "code" : "Name:Participation:role:Role",
                              "valueString" : "&"
                            }
                          ]
                        },
                        {
                          "code" : "RESBJ",
                          "display" : "research subject",
                          "definition" : "**Definition:**Specifies the administrative functionality within a formal experimental design for which the ResearchSubject role was established.\r\n\r\n**Examples:** Screening - role is used for pre-enrollment evaluation portion of the design; enrolled - role is used for subjects admitted to the experimental portion of the design.",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "19166"
                            },
                            {
                              "code" : "Name:Class",
                              "valueString" : "researchSubject"
                            },
                            {
                              "code" : "Name:Role:player:Entity",
                              "valueString" : "subject&"
                            },
                            {
                              "code" : "Name:Role:scoper:Entity",
                              "valueString" : "researchSponsor"
                            },
                            {
                              "code" : "Sort:Entity:playedRole:Role",
                              "valueString" : "AAAABB___"
                            },
                            {
                              "code" : "Sort:Entity:scopedRole:Role",
                              "valueString" : "AAAABB___"
                            },
                            {
                              "code" : "Name:Entity:playedRole:Role",
                              "valueString" : "as&"
                            },
                            {
                              "code" : "Name:Entity:scopedRole:Role",
                              "valueString" : "&"
                            },
                            {
                              "code" : "Name:Participation:role:Role",
                              "valueString" : "&"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "code" : "LIC",
                      "display" : "licensed entity",
                      "definition" : "A relationship in which the scoper certifies the player ( e. g. a medical care giver, a medical device or a provider organization) to perform certain activities that fall under the jurisdiction of the scoper (e.g., a health authority licensing healthcare providers, a medical quality authority certifying healthcare professionals).",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "16773"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "licensedEntity"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueString" : "subject&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueString" : "(issuing&)|issuer"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueString" : "AAAAC____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueString" : "AAAAC____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "NOT",
                          "display" : "notary public",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "11576"
                            },
                            {
                              "code" : "Name:Class",
                              "valueString" : "notaryPublic"
                            },
                            {
                              "code" : "Name:Role:player:Entity",
                              "valueString" : "notaryPublic&"
                            },
                            {
                              "code" : "Name:Role:scoper:Entity",
                              "valueString" : "political(&|Entity)"
                            },
                            {
                              "code" : "Sort:Entity:playedRole:Role",
                              "valueString" : "AAAACB___"
                            },
                            {
                              "code" : "Sort:Entity:scopedRole:Role",
                              "valueString" : "AAAACB___"
                            },
                            {
                              "code" : "Name:Entity:playedRole:Role",
                              "valueString" : "as&"
                            },
                            {
                              "code" : "Name:Entity:scopedRole:Role",
                              "valueString" : "&"
                            },
                            {
                              "code" : "Name:Participation:role:Role",
                              "valueString" : "&"
                            }
                          ]
                        },
                        {
                          "code" : "PROV",
                          "display" : "healthcare provider",
                          "definition" : "An Entity (player) that is authorized to provide health care services by some authorizing agency (scoper).",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "11599"
                            },
                            {
                              "code" : "Name:Class",
                              "valueString" : "healthCareProvider"
                            },
                            {
                              "code" : "Name:Role:player:Entity",
                              "valueString" : "healthCare(&|Provider)"
                            },
                            {
                              "code" : "Name:Role:scoper:Entity",
                              "valueString" : "(issuing&)|issuer"
                            },
                            {
                              "code" : "Sort:Entity:playedRole:Role",
                              "valueString" : "AAAACA___"
                            },
                            {
                              "code" : "Sort:Entity:scopedRole:Role",
                              "valueString" : "AAAACA___"
                            },
                            {
                              "code" : "Name:Entity:playedRole:Role",
                              "valueString" : "as&"
                            },
                            {
                              "code" : "Name:Entity:scopedRole:Role",
                              "valueString" : "&"
                            },
                            {
                              "code" : "Name:Participation:role:Role",
                              "valueString" : "&"
                            }
                          ]
                        }
                      ]
                    },
                    {
                      "code" : "PAT",
                      "display" : "patient",
                      "definition" : "A Role of a LivingSubject (player) as an actual or potential recipient of health care services from a healthcare provider organization (scoper).\r\n\r\n*Usage Note:* Communication about relationships between patients and specific healthcare practitioners (people) is not done via scoper. Instead this is generally done using the CareProvision act. This allows linkage between patient and a particular healthcare practitioner role and also allows description of the type of care involved in the relationship.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "11577"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "patient"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueString" : "patient&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueString" : "provider&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueString" : "AAAAA____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueString" : "AAAAA____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "PAYEE",
                      "display" : "payee",
                      "definition" : "The role of an organization or individual designated to receive payment for a claim against a particular coverage. The scoping entity is the organization that is the submitter of the invoice in question.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "14015"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "payee"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueString" : "payee&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueString" : "invoicing&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueString" : "AAAAK____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueString" : "AAAAK____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "PAYOR",
                      "display" : "invoice payor",
                      "definition" : "The role of an organization that undertakes to accept claims invoices, assess the coverage or payments due for those invoices and pay to the designated payees for those invoices. This role may be either the underwriter or a third-party organization authorized by the underwriter. The scoping entity is the organization that underwrites the claimed coverage.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "14014"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "payor"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueString" : "invoicePayor&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueString" : "(underwriting&)|underwriter"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueString" : "AAAAL____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueString" : "AAAAL____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "POLHOLD",
                      "display" : "policy holder",
                      "definition" : "A role played by a person or organization that holds an insurance policy. The underwriter of that policy is the scoping entity.\r\n\r\n*Discussion:*The identifier of the policy is captured in 'Role.id' when the Role is a policy holder.\r\n\r\nA particular policy may cover several individuals one of whom may be, but need not be, the policy holder. Thus the notion of covered party is a role that is distinct from that of the policy holder.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "14010"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "policyHolder"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueString" : "policyHolder&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueString" : "(underwriting&)|underwriter"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueString" : "AAAAM____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueString" : "AAAAM____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "QUAL",
                      "display" : "qualified entity",
                      "definition" : "An entity (player) that has been recognized as having certain training/experience or other characteristics that would make said entity an appropriate performer for a certain activity. The scoper is an organization that educates or qualifies entities.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "11619"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "qualifiedEntity"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueString" : "qualified(&|Entity)"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueString" : "qualificationGranting(&|Entity)"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueString" : "AAAAP____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueString" : "AAAAP____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "SPNSR",
                      "display" : "coverage sponsor",
                      "definition" : "A role played by an entity, usually an organization that is the sponsor of an insurance plan or a health program. A sponsor is the party that is ultimately accountable for the coverage by employment contract or by law. A sponsor can be an employer, union, government agency, or association. Fully insured sponsors establish the terms of the plan and contract with health insurance plans to assume the risk and to administer the plan. Self-insured sponsors delegate coverage administration, but not risk, to third-party administrators. Program sponsors designate services to be covered in accordance with statute. Program sponsors may administer the coverage themselves, delegate coverage administration, but not risk to third-party administrators, or contract with health insurance plans to assume the risk and administrator a program. Sponsors qualify individuals who may become\r\n\r\n1.  a policy holder of the plan;\r\n2.  where the sponsor is the policy holder, who may become a subscriber or a dependent to a policy under the plan; or\r\n3.  where the sponsor is a government agency, who may become program eligibles under a program.\r\n\r\nThe sponsor role may be further qualified by the SponsorRole.code. Entities playing the sponsor role may also play the role of a Coverage Administrator.\r\n\r\n*Example:* An employer, union, government agency, or association.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "14012"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "sponsor"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueString" : "sponsor&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueString" : "(underwriting&)|underwriter"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueString" : "AAAAN____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueString" : "AAAAN____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "STD",
                      "display" : "student",
                      "definition" : "A role played by an individual who is a student of a school, which is the scoping entity.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "12248"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "student"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueString" : "student"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueString" : "school(&|Entity)"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueString" : "AAAAQ____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueString" : "AAAAQ____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "UNDWRT",
                      "display" : "underwriter",
                      "definition" : "A role played by a person or an organization. It is the party that\r\n\r\n1.  accepts fiscal responsibility for insurance plans and the policies created under those plans;\r\n2.  administers and accepts fiscal responsibility for a program that provides coverage for services to eligible individuals; and/or\r\n3.  has the responsibility to assess the merits of each risk and decide a suitable premium for accepting all or part of the risk. If played by an organization, this role may be further specified by an appropriate RoleCode.\r\n\r\n*Example:*\r\n\r\n1.  A health insurer;\r\n2.  Medicaid Program;\r\n3.  Lloyd's of London",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "14009"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "underwriter"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueString" : "(underwriting&)|underwriter"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueString" : "scoper&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueString" : "AAAAO____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueString" : "AAAAO____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "CAREGIVER",
                  "display" : "caregiver",
                  "definition" : "A person responsible for the primary care of a patient at home.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "21355"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "careGiver"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "careGiver&"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "careGiverScoper"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "AAAC_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "AAAC_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "PRS",
                  "display" : "personal relationship",
                  "definition" : "Links two entities with classCode PSN (person) in a personal relationship. The character of the relationship must be defined by a PersonalRelationshipRoleType code. The player and scoper are determined by PersonalRelationshipRoleType code as well.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "19167"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "personalRelationship"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "relationshipHolder"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "personalRelationshipWith"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "AAAB_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "AAAB_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "SELF",
                  "display" : "self",
                  "definition" : "The \"same\" roleclass asserts an identity between playing and scoping entities: that they are in fact instances of the same entity and, in the case of discrepancies (e.g different DOB, gender), that one or both are in error.\r\n\r\n*Usage:*\r\n\r\nplaying and scoping entities must have same classcode, but need not have identical attributes or values.\r\n\r\n*Example:* \r\n\r\na provider registry maintains sets of conflicting demographic data for what is reported to be the same individual.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "retired"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "21437"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "_RoleClassPassive",
              "display" : "RoleClassPassive",
              "definition" : "An association for a playing Entity that is used, known, treated, handled, built, or destroyed, etc. under the auspices of the scoping Entity. The playing Entity is passive in these roles (even though it may be active in other roles), in the sense that the kinds of things done to it in this role happen without an agreement from the playing Entity.",
              "property" : [
                {
                  "code" : "notSelectable",
                  "valueBoolean" : true
                },
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21117"
                },
                {
                  "code" : "Name:Class",
                  "valueString" : "passiveRelation"
                },
                {
                  "code" : "Name:Role:player:Entity",
                  "valueString" : "playing&"
                },
                {
                  "code" : "Name:Role:scoper:Entity",
                  "valueString" : "scoping&"
                },
                {
                  "code" : "Sort:Entity:playedRole:Role",
                  "valueString" : "AAB______"
                },
                {
                  "code" : "Sort:Entity:scopedRole:Role",
                  "valueString" : "AAB______"
                },
                {
                  "code" : "Name:Entity:playedRole:Role",
                  "valueString" : "as&"
                },
                {
                  "code" : "Name:Entity:scopedRole:Role",
                  "valueString" : "&"
                },
                {
                  "code" : "Name:Participation:role:Role",
                  "valueString" : "&"
                }
              ],
              "concept" : [
                {
                  "code" : "ACCESS",
                  "display" : "access",
                  "definition" : "A role in which the playing entity (material) provides access to another entity. The principal use case is intravenous (or other bodily) access lines that preexist and need to be referred to for medication routing instructions.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "11592"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "access"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "access&"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "accessed&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "AABM_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "AABM_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "ADJY",
                  "display" : "adjacency",
                  "definition" : "A physical association whereby two Entities are in some (even lose) spatial relationship with each other such that they touch each other in some way.\r\n\r\n*Examples:* the colon is connected (and therefore adjacent) to the jejunum; the colon is adjacent to the liver (even if not actually connected.)\r\n\r\n*UsageConstraints:* Adjacency is in principle a symmetrical connection, but scoper and player of the role should, where applicable, be assigned to have scoper be the larger, more central Entity and player the smaller, more distant, appendage.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23095"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "adjacency"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "distal&"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "proximal&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "AAB______"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "AAB______"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "CONC",
                      "display" : "connection",
                      "definition" : "An adjacency of two Entities held together by a bond which attaches to each of the two entities.\r\n\r\n*Examples:* biceps brachii muscle connected to the radius bone, port 3 on a network switch connected to port 5 on a patch panel.\r\n\r\n*UsageConstraints:* See Adjacency for the assignment of scoper (larger, more central) and player (smaller, more distant).",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "23096"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "connection"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueString" : "distal&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueString" : "proximal&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueString" : "AAB______"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueString" : "AAB______"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "BOND",
                          "display" : "molecular bond",
                          "definition" : "A connection between two atoms of a molecule.\r\n\r\n*Examples:* double bond between first and second C in ethane, peptide bond between two amino-acid, disulfide bridge between two proteins, chelate and ion associations, even the much weaker van-der-Waals bonds can be considered molecular bonds.\r\n\r\n*UsageConstraints:* See connection and adjacency for the assignment of player and scoper.",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "23098"
                            },
                            {
                              "code" : "Name:Class",
                              "valueString" : "bond"
                            },
                            {
                              "code" : "Name:Role:player:Entity",
                              "valueString" : "distal&"
                            },
                            {
                              "code" : "Name:Role:scoper:Entity",
                              "valueString" : "proximal&"
                            },
                            {
                              "code" : "Sort:Entity:playedRole:Role",
                              "valueString" : "AAB______"
                            },
                            {
                              "code" : "Sort:Entity:scopedRole:Role",
                              "valueString" : "AAB______"
                            },
                            {
                              "code" : "Name:Entity:playedRole:Role",
                              "valueString" : "as&"
                            },
                            {
                              "code" : "Name:Entity:scopedRole:Role",
                              "valueString" : "&"
                            },
                            {
                              "code" : "Name:Participation:role:Role",
                              "valueString" : "&"
                            }
                          ]
                        },
                        {
                          "code" : "CONY",
                          "display" : "continuity",
                          "definition" : "A connection between two regional parts.\r\n\r\n*Examples:*  the connection between ascending aorta and the aortic arc, connection between descending colon and sigmoid.\r\n\r\n*UsageConstraints:* See connection and adjacency for the assignment of player and scoper.",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "23097"
                            },
                            {
                              "code" : "Name:Class",
                              "valueString" : "continuity"
                            },
                            {
                              "code" : "Name:Role:player:Entity",
                              "valueString" : "distal&"
                            },
                            {
                              "code" : "Name:Role:scoper:Entity",
                              "valueString" : "proximal&"
                            },
                            {
                              "code" : "Sort:Entity:playedRole:Role",
                              "valueString" : "AAB______"
                            },
                            {
                              "code" : "Sort:Entity:scopedRole:Role",
                              "valueString" : "AAB______"
                            },
                            {
                              "code" : "Name:Entity:playedRole:Role",
                              "valueString" : "as&"
                            },
                            {
                              "code" : "Name:Entity:scopedRole:Role",
                              "valueString" : "&"
                            },
                            {
                              "code" : "Name:Participation:role:Role",
                              "valueString" : "&"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "ADMM",
                  "display" : "Administerable Material",
                  "definition" : "A material (player) that can be administered to an Entity (scoper).",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "21435"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "administrableMaterial"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "administrable(&|Product)"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "(scoping&)|scoper"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "AABO_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "AABO_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "BIRTHPL",
                  "display" : "birthplace",
                  "definition" : "Relates a place (playing Entity) as the location where a living subject (scoping Entity) was born.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "11589"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "birthplace"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "birthplace"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "birthplaceFor&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "AABL_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "AABL_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "DEATHPLC",
                  "display" : "place of death",
                  "definition" : "Definition: Relates a place (playing Entity) as the location where a living subject (scoping Entity) died.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "21640"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "placeOfDeath"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "DST",
                  "display" : "distributed material",
                  "definition" : "A material (player) distributed by a distributor (scoper) who functions between a manufacturer and a buyer or retailer.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "10418"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "distributedProduct"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "distributed(&|Product)"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "(distributing&)|distributor"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "AABB_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "AABB_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "RET",
                      "display" : "retailed material",
                      "definition" : "Material (player) sold by a retailer (scoper), who also give advice to prospective buyers.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "10419"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "retailedProduct"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueString" : "retailed(&|Product)"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueString" : "retailer&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueString" : "AABBA____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueString" : "AABBA____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "EXLOC",
                  "display" : "event location",
                  "definition" : "A role played by a place at which the location of an event may be recorded.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23368"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "eventLocation"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "EventLocation(&-PLC)"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "initiator&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "AABI_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "AABI_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "SDLOC",
                      "display" : "service delivery location",
                      "definition" : "A role played by a place at which services may be provided.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "16927"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "serviceDeliveryLocation"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueString" : "location(&-PLC)"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueString" : "serviceProvider&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueString" : "AABJ_____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueString" : "AABJ_____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ],
                      "concept" : [
                        {
                          "code" : "DSDLOC",
                          "display" : "dedicated service delivery location",
                          "definition" : "A role of a place (player) that is intended to house the provision of services. Scoper is the Entity (typically Organization) that provides these services. This is not synonymous with \"ownership.\"",
                          "designation" : [
                            {
                              "language" : "en",
                              "use" : {
                                "system" : "http://snomed.info/sct",
                                "code" : "900000000000013009"
                              },
                              "value" : "health care facility"
                            }
                          ],
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "11600"
                            },
                            {
                              "code" : "Name:Class",
                              "valueString" : "dedicatedServiceDeliveryLocation"
                            },
                            {
                              "code" : "Name:Role:player:Entity",
                              "valueString" : "location(&-PLC)"
                            },
                            {
                              "code" : "Name:Role:scoper:Entity",
                              "valueString" : "recognizing&"
                            },
                            {
                              "code" : "Sort:Entity:playedRole:Role",
                              "valueString" : "AABJB____"
                            },
                            {
                              "code" : "Sort:Entity:scopedRole:Role",
                              "valueString" : "AABJB____"
                            },
                            {
                              "code" : "Name:Entity:playedRole:Role",
                              "valueString" : "as&"
                            },
                            {
                              "code" : "Name:Entity:scopedRole:Role",
                              "valueString" : "&"
                            },
                            {
                              "code" : "Name:Participation:role:Role",
                              "valueString" : "&"
                            }
                          ]
                        },
                        {
                          "code" : "ISDLOC",
                          "display" : "incidental service delivery location",
                          "definition" : "A role played by a place at which health care services may be provided without prior designation or authorization.",
                          "property" : [
                            {
                              "code" : "status",
                              "valueCode" : "active"
                            },
                            {
                              "code" : "internalId",
                              "valueCode" : "16929"
                            },
                            {
                              "code" : "Name:Class",
                              "valueString" : "incidentalServiceDeliveryLocation"
                            },
                            {
                              "code" : "Name:Role:player:Entity",
                              "valueString" : "location(&-PLC)"
                            },
                            {
                              "code" : "Name:Role:scoper:Entity",
                              "valueString" : "recognizing&"
                            },
                            {
                              "code" : "Sort:Entity:playedRole:Role",
                              "valueString" : "AABJA____"
                            },
                            {
                              "code" : "Sort:Entity:scopedRole:Role",
                              "valueString" : "AABJA____"
                            },
                            {
                              "code" : "Name:Entity:playedRole:Role",
                              "valueString" : "as&"
                            },
                            {
                              "code" : "Name:Entity:scopedRole:Role",
                              "valueString" : "&"
                            },
                            {
                              "code" : "Name:Participation:role:Role",
                              "valueString" : "&"
                            }
                          ]
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "EXPR",
                  "display" : "exposed entity",
                  "definition" : "A role played by an entity that has been exposed to a person or animal suffering a contagious disease, or with a location from which a toxin has been distributed. The player of the role is normally a person or animal, but it is possible that other entity types could become exposed. The role is scoped by the source of the exposure, and it is quite possible for a person playing the role of exposed party to also become the scoper a role played by another person. That is to say, once a person has become infected, it is possible, perhaps likely, for that person to infect others.\r\n\r\nManagement of exposures and tracking exposed parties is a key function within public health, and within most public health contexts - exposed parties are known as \"contacts.\"",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "19131"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "exposedEntity"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "exposed&"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "exposing&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "AABN_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "AABN_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "HLD",
                  "display" : "held entity",
                  "definition" : "Entity that is currently in the possession of a holder (scoper), who holds, or uses it, usually based on some agreement with the owner.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "10422"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "heldEntity"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "held(&|Entity)"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "(holding&)|holder"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "AABC_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "AABC_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "HLTHCHRT",
                  "display" : "health chart",
                  "definition" : "The role of a material (player) that is the physical health chart belonging to an organization (scoper).",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "11618"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "healthChart"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "healthChart&"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "subject&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "AABI_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "AABI_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "IDENT",
                  "display" : "identified entity",
                  "definition" : "A role in which the scoping entity designates an identifier for a playing entity.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "16721"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "identifiedEntity"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "identified(&|Entity)"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "assigning(&|Authority)"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "AABA_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "AABA_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "MANU",
                  "display" : "manufactured product",
                  "definition" : "Scoped by the manufacturer",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "11580"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "manufacturedProduct"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "manufactured(&|Product)"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "manufacturer&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "AABD_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "AABD_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "THER",
                      "display" : "therapeutic agent",
                      "definition" : "A manufactured material (player) that is used for its therapeutic properties. The manufacturer is the scoper.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "11581"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "manufacturedProduct"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueString" : "manufactured(&|Product)"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueString" : "manufacturer&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueString" : "AABDA____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueString" : "AABDA____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "MNT",
                  "display" : "maintained entity",
                  "definition" : "An entity (player) that is maintained by another entity (scoper). This is typical role held by durable equipment. The scoper assumes responsibility for proper operation, quality, and safety.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "10427"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "maintainedEntity"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "maintained(&|Entity)"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "(maintaining&)|maintainer"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "AABE_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "AABE_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "OWN",
                  "display" : "owned entity",
                  "definition" : "An Entity (player) for which someone (scoper) is granted by law the right to call the material (player) his own. This entitles the scoper to make decisions about the disposition of that material.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "10421"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "ownedEntity"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "owned(&|Entity)"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "(owning&)|owner"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "AABF_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "AABF_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "RGPR",
                  "display" : "regulated product",
                  "definition" : "A product regulated by some governmentatl orgnization. The role is played by Material and scoped by Organization.\r\n\r\nRationale: To support an entity clone used to identify the NDC number for a drug product.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "19132"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "regulatedProduct"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "regulated(&|Product)"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "regulator&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "AABH_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "AABH_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "TERR",
                  "display" : "territory of authority",
                  "definition" : "Relates a place entity (player) as the region over which the scoper (typically an Organization) has certain authority (jurisdiction). For example, the Calgary Regional Health Authority (scoper) has authority over the territory \"Region 4 of Alberta\" (player) in matters of health.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "11583"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "territorialAuthority"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "territory(&-PLC)"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "governing&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "AABK_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "AABK_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "USED",
                  "display" : "used entity",
                  "definition" : "**Description:**An entity (player) that is used by another entity (scoper)",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "22755"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "usedEntity"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "WRTE",
                  "display" : "warranted product",
                  "definition" : "A role a product plays when a guarantee is given to the purchaser by the seller (scoping entity) stating that the product is reliable and free from known defects and that the seller will repair or replace defective parts within a given time limit and under certain conditions.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "16300"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "warrantedProduct"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "warranted(&|Product)"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "(warranting&)|warranter"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "AABG_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "AABG_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "code" : "_RoleClassOntological",
          "display" : "RoleClassOntological",
          "definition" : "A relationship in which the scoping Entity defines or specifies what the playing Entity is. Thus, the player's \"being\" (Greek: ontos) is specified.",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21115"
            },
            {
              "code" : "Name:Class",
              "valueString" : "definedEntity"
            },
            {
              "code" : "Name:Role:player:Entity",
              "valueString" : "defined&"
            },
            {
              "code" : "Name:Role:scoper:Entity",
              "valueString" : "defining&"
            },
            {
              "code" : "Sort:Entity:playedRole:Role",
              "valueString" : "AC_______"
            },
            {
              "code" : "Sort:Entity:scopedRole:Role",
              "valueString" : "AC_______"
            },
            {
              "code" : "Name:Entity:playedRole:Role",
              "valueString" : "as&"
            },
            {
              "code" : "Name:Entity:scopedRole:Role",
              "valueString" : "&"
            },
            {
              "code" : "Name:Participation:role:Role",
              "valueString" : "&"
            }
          ],
          "concept" : [
            {
              "code" : "EQUIV",
              "display" : "equivalent entity",
              "definition" : "**Description:** Specifies the player Entity (the equivalent Entity) as an Entity that is considered to be equivalent to a reference Entity (scoper). The equivalence is in principle a symmetric relationship, however, it is expected that the scoper is a reference entity which serves as reference entity for multiple different equivalent entities.\r\n\r\n**Examples:** An innovator's medicine formulation is the reference for \"generics\", i.e., formulations manufactured differently but having been proven to be biologically equivalent to the reference medicine. Another example is a reference ingredient that serves as basis for quantity specifications (basis of strength, e.g., metoprolol succinate specified in terms of metoprolol tartrate.)",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22399"
                },
                {
                  "code" : "Name:Class",
                  "valueString" : "equivalentEntity"
                },
                {
                  "code" : "Name:Entity:playedRole:Role",
                  "valueString" : "as&"
                },
                {
                  "code" : "Name:Entity:scopedRole:Role",
                  "valueString" : "&"
                },
                {
                  "code" : "Name:Participation:role:Role",
                  "valueString" : "&"
                }
              ],
              "concept" : [
                {
                  "code" : "SAME",
                  "display" : "same",
                  "definition" : "The \"same\" role asserts an identity between playing and scoping entities, i.e., that they are in fact two records of the same entity instance, and, in the case of discrepancies (e.g different DOB, gender), that one or both are in error.\r\n\r\n*Usage:*\r\n\r\nplaying and scoping entities must have same classCode, but need not have identical attributes or values.\r\n\r\n*Example:* \r\n\r\na provider registry maintains sets of conflicting demographic data for what is reported to be the same individual.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "21488"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "same"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "same&"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "same&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "ACE______"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "ACE______"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "SUBY",
                  "display" : "subsumed by",
                  "definition" : "Relates a prevailing record of an Entity (scoper) with another record (player) that it subsumes.\r\n\r\n*Examples:* Show a correct new Person object (scoper) that subsumes one or more duplicate Person objects that had accidentally been created for the same physical person.\r\n\r\n*Constraints:* Both the player and scoper must have the same classCode.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "20070"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "subsumedBy"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "subsuming&"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "subsumed&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "ACD______"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "ACD______"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "GEN",
              "display" : "has generalization",
              "definition" : "Relates a specialized material concept (player) to its generalization (scoper).",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10441"
                },
                {
                  "code" : "Name:Class",
                  "valueString" : "specializedKind"
                },
                {
                  "code" : "Name:Role:player:Entity",
                  "valueString" : "specialized(&|Kind)"
                },
                {
                  "code" : "Name:Role:scoper:Entity",
                  "valueString" : "generalized(&|Kind)"
                },
                {
                  "code" : "Sort:Entity:playedRole:Role",
                  "valueString" : "ACA______"
                },
                {
                  "code" : "Sort:Entity:scopedRole:Role",
                  "valueString" : "ACA______"
                },
                {
                  "code" : "Name:Entity:playedRole:Role",
                  "valueString" : "as&"
                },
                {
                  "code" : "Name:Entity:scopedRole:Role",
                  "valueString" : "&"
                },
                {
                  "code" : "Name:Participation:role:Role",
                  "valueString" : "&"
                }
              ],
              "concept" : [
                {
                  "code" : "GRIC",
                  "display" : "has generic",
                  "definition" : "A special link between pharmaceuticals indicating that the target (scoper) is a generic for the source (player).",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "10442"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "entityWithGeneric"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "specialized(&|Kind)"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "generic(&|Kind)"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "ACAA_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "ACAA_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "INST",
              "display" : "instance",
              "definition" : "An individual piece of material (player) instantiating a class of material (scoper).",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10443"
                },
                {
                  "code" : "Name:Class",
                  "valueString" : "instanceOfKind"
                },
                {
                  "code" : "Name:Role:player:Entity",
                  "valueString" : "&Instance"
                },
                {
                  "code" : "Name:Role:scoper:Entity",
                  "valueString" : "kindOf&"
                },
                {
                  "code" : "Sort:Entity:playedRole:Role",
                  "valueString" : "ACB______"
                },
                {
                  "code" : "Sort:Entity:scopedRole:Role",
                  "valueString" : "ACB______"
                },
                {
                  "code" : "Name:Entity:playedRole:Role",
                  "valueString" : "as&"
                },
                {
                  "code" : "Name:Entity:scopedRole:Role",
                  "valueString" : "&"
                },
                {
                  "code" : "Name:Participation:role:Role",
                  "valueString" : "&"
                }
              ]
            },
            {
              "code" : "SUBS",
              "display" : "subsumer",
              "definition" : "An entity that subsumes the identity of another. Used in the context of merging documented entity instances. Both the player and scoper must have the same classCode.\r\n\r\nThe use of this code is **deprecated** in favor of the term SUBY which is its inverse and is more ontologically correct.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "deprecated"
                },
                {
                  "code" : "deprecationDate",
                  "valueDateTime" : "2011-12-01"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "16241"
                },
                {
                  "code" : "Name:Entity:playedRole:Role",
                  "valueString" : "as&"
                },
                {
                  "code" : "Name:Entity:scopedRole:Role",
                  "valueString" : "&"
                },
                {
                  "code" : "Name:Participation:role:Role",
                  "valueString" : "&"
                }
              ]
            }
          ]
        },
        {
          "code" : "_RoleClassPartitive",
          "display" : "RoleClassPartitive",
          "definition" : "An association between two Entities where the playing Entity is considered in some way \"part\" of the scoping Entity, e.g., as a member, component, ingredient, or content. Being \"part\" in the broadest sense of the word can mean anything from being an integral structural component to a mere incidental temporary association of a playing Entity with a (generally larger) scoping Entity.",
          "property" : [
            {
              "code" : "notSelectable",
              "valueBoolean" : true
            },
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21116"
            },
            {
              "code" : "Name:Class",
              "valueString" : "partOfWhole"
            },
            {
              "code" : "Name:Role:player:Entity",
              "valueString" : "part&"
            },
            {
              "code" : "Name:Role:scoper:Entity",
              "valueString" : "whole&"
            },
            {
              "code" : "Sort:Entity:playedRole:Role",
              "valueString" : "AB_______"
            },
            {
              "code" : "Sort:Entity:scopedRole:Role",
              "valueString" : "AB_______"
            },
            {
              "code" : "Name:Entity:playedRole:Role",
              "valueString" : "as&"
            },
            {
              "code" : "Name:Entity:scopedRole:Role",
              "valueString" : "&"
            },
            {
              "code" : "Name:Participation:role:Role",
              "valueString" : "&"
            }
          ],
          "concept" : [
            {
              "code" : "CONT",
              "display" : "content",
              "definition" : "Relates a material as the content (player) to a container (scoper). Unlike ingredients, the content and a container remain separate (not mixed) and the content can be removed from the container. A content is not part of an empty container.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10438"
                },
                {
                  "code" : "Name:Class",
                  "valueString" : "content"
                },
                {
                  "code" : "Name:Role:player:Entity",
                  "valueString" : "(contained(&-MAT))|content"
                },
                {
                  "code" : "Name:Role:scoper:Entity",
                  "valueString" : "container&"
                },
                {
                  "code" : "Sort:Entity:playedRole:Role",
                  "valueString" : "ABB______"
                },
                {
                  "code" : "Sort:Entity:scopedRole:Role",
                  "valueString" : "ABB______"
                },
                {
                  "code" : "Name:Entity:playedRole:Role",
                  "valueString" : "as&"
                },
                {
                  "code" : "Name:Entity:scopedRole:Role",
                  "valueString" : "&"
                },
                {
                  "code" : "Name:Participation:role:Role",
                  "valueString" : "&"
                }
              ]
            },
            {
              "code" : "EXPAGTCAR",
              "display" : "exposure agent carrier",
              "definition" : "An exposure agent carrier is an entity that is capable of conveying an exposure agent from one entity to another. The scoper of the role must be the exposure agent (e.g., pathogen).",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22350"
                },
                {
                  "code" : "Name:Class",
                  "valueString" : "exposureAgentCarrier"
                },
                {
                  "code" : "Name:Entity:playedRole:Role",
                  "valueString" : "as&"
                },
                {
                  "code" : "Name:Entity:scopedRole:Role",
                  "valueString" : "&"
                },
                {
                  "code" : "Name:Participation:role:Role",
                  "valueString" : "&"
                }
              ],
              "concept" : [
                {
                  "code" : "EXPVECTOR",
                  "display" : "exposure vector",
                  "definition" : "**Description:** A vector is a living subject that carries an exposure agent. The vector does not cause the disease itself, but exposes targets to the exposure agent. A mosquito carrying malaria is an example of a vector. The scoper of the role must be the exposure agent (e.g., pathogen).",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "22351"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "exposureVector"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "FOMITE",
                  "display" : "fomite",
                  "definition" : "**Description:** A fomite is a non-living entity that is capable of conveying exposure agent from one entity to another. A doorknob contaminated with a Norovirus is an example of a fomite. Anyone touching the doorknob would be exposed to the virus. The scoper of the role must be the exposure agent (e.g., pathogen).",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "22352"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "fomite"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "INGR",
              "display" : "ingredient",
              "definition" : "Relates a component (player) to a mixture (scoper). E.g., Glucose and Water are ingredients of D5W, latex may be an ingredient in a tracheal tube.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "10430"
                },
                {
                  "code" : "Name:Class",
                  "valueString" : "ingredient"
                },
                {
                  "code" : "Name:Role:player:Entity",
                  "valueString" : "ingredient&"
                },
                {
                  "code" : "Name:Role:scoper:Entity",
                  "valueString" : "ingredientOf&"
                },
                {
                  "code" : "Sort:Entity:playedRole:Role",
                  "valueString" : "ABD______"
                },
                {
                  "code" : "Sort:Entity:scopedRole:Role",
                  "valueString" : "ABD______"
                },
                {
                  "code" : "Name:Entity:playedRole:Role",
                  "valueString" : "as&"
                },
                {
                  "code" : "Name:Entity:scopedRole:Role",
                  "valueString" : "&"
                },
                {
                  "code" : "Name:Participation:role:Role",
                  "valueString" : "&"
                }
              ],
              "concept" : [
                {
                  "code" : "ACTI",
                  "display" : "active ingredient",
                  "definition" : "**Definition:** a therapeutically active ingredient (player) in a mixture (scoper), where the mixture is typically a manufactured pharmaceutical. It is unknown if the quantity of such an ingredient is expressed precisely in terms of the playing ingredient substance, or, if it is specified in terms of a closely related substance (active moiety or reference substance).",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "10433"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "activeIngredient"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "activeIngredient&"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "ingredientOf&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "ABDA_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "ABDA_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "ACTIB",
                      "display" : "active ingredient - basis of strength",
                      "definition" : "**Description:**  Active ingredient, where the ingredient substance (player) is itself the \"basis of strength\", i.e., where the Role.quantity specifies exactly the quantity of the player substance in the medicine formulation.\r\n\r\n**Examples:** Lopressor 50 mg actually contains 50 mg of metoprolol succinate, even though the active moiety is metoprolol, but also: Tenormin 50 mg contain 50 mg of atenolol, as free base, i.e., where the active ingredient atenolol is also the active moiety.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "22396"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "activeIngredientBasisOfStrength"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "ACTIM",
                      "display" : "active ingredient - moiety is basis of strength",
                      "definition" : "**Description:** Active ingredient, where not the ingredient substance (player), but itaTMs active moiety is the \"basis of strength\", i.e., where the Role.quantity specifies the quantity of the player substance's active moiety in the medicine formulation.\r\n\r\n**Examples:** 1 mL of Betopic 5mg/mL eye drops contains 5.6 mg betaxolol hydrochloride equivalent to betaxolol base 5 mg.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "22397"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "activeIngredientMoietyIsBasisOfStrength"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "ACTIR",
                      "display" : "active ingredient - reference substance is basis of strength",
                      "definition" : "**Description:** Active ingredient, where not the ingredient substance (player) but another reference substance with the same active moiety, is the \"basis of strength\", i.e., where the Role.quantity specifies the quantity of a reference substance, similar but different from the player substance's in the medicine formulation.\r\n\r\n**Examples:** Toprol-XL 50 mg contains 47.5 mg of metoprolol succinate equivalent to 50 mg of metoprolol tartrate.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "22398"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "activeIngredientReferenceSubstanceIsBasisOfStrength"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "ADJV",
                  "display" : "adjuvant",
                  "definition" : "A component (player) added to enhance the action of an active ingredient (scoper) (in the manner of a catalyst) but which has no active effect in and of itself. Such ingredients are significant in defining equivalence of products in a way that inactive ingredients are not.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23059"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "adjuvant"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "ADTV",
                  "display" : "additive",
                  "definition" : "An ingredient (player) that is added to a base (scoper), that amounts to a minor part of the overall mixture.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "10432"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "additive"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "additive&"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "additiveOf&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "ABDE_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "ABDE_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "BASE",
                  "display" : "base",
                  "definition" : "A base ingredient (player) is what comprises the major part of a mixture (scoper). E.g., Water in most i.v. solutions, or Vaseline in salves. Among all ingredients of a material, there should be only one base. A base substance can, in turn, be a mixture.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "10431"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "base"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "base&"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "baseOf&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "ABDC_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "ABDC_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "CNTM",
                  "display" : "contaminant ingredient",
                  "definition" : "An ingredient whose presence is not intended but may not be reasonably avoided given the circumstances of the mixture's nature or origin.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23369"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "contaminant"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "contaminant&"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "contaminantOf&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "ABDF_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "ABDF_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "IACT",
                  "display" : "inactive ingredient",
                  "definition" : "An ingredient which is not considered therapeutically active, e.g., colors, flavors, stabilizers, or preservatives, fillers, or structural components added to an active ingredient in order to facilitate administration of the active ingredient but without being considered therapeutically active. An inactive ingredient need not be biologically inert, e.g., might be active as an allergen or might have a pleasant taste, but is not an essential constituent delivering the therapeutic effect.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "19089"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "inactiveIngredient"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "inactiveIngredient&"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "ingredientOf&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "ABDD_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "ABDD_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ],
                  "concept" : [
                    {
                      "code" : "COLR",
                      "display" : "color additive",
                      "definition" : "A substance (player) influencing the optical aspect of material (scoper).",
                      "designation" : [
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "color"
                        }
                      ],
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "10437"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "colorAdditive"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueString" : "color&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueString" : "additiveOf&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueString" : "ABDDC____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueString" : "ABDDC____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "FLVR",
                      "display" : "flavor additive",
                      "definition" : "A substance (player) added to a mixture (scoper) to make it taste a certain way. In food the use is obvious, in pharmaceuticals flavors can hide disgusting taste of the active ingredient (important in pediatric treatments).",
                      "designation" : [
                        {
                          "language" : "en",
                          "use" : {
                            "system" : "http://snomed.info/sct",
                            "code" : "900000000000013009"
                          },
                          "value" : "flavor"
                        }
                      ],
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "10436"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "flavorAdditive"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueString" : "flavor&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueString" : "additiveOf&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueString" : "ABDDD____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueString" : "ABDDD____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "PRSV",
                      "display" : "preservative",
                      "definition" : "A substance (player) added to a mixture (scoper) to prevent microorganisms (fungi, bacteria) to spoil the mixture.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "10435"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "preservative"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueString" : "preservative&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueString" : "preservativeOf&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueString" : "ABDDA____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueString" : "ABDDA____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    },
                    {
                      "code" : "STBL",
                      "display" : "stabilizer",
                      "definition" : "A stabilizer (player) added to a mixture (scoper) in order to prevent the molecular disintegration of the main substance.",
                      "property" : [
                        {
                          "code" : "status",
                          "valueCode" : "active"
                        },
                        {
                          "code" : "internalId",
                          "valueCode" : "10434"
                        },
                        {
                          "code" : "Name:Class",
                          "valueString" : "stabilizer"
                        },
                        {
                          "code" : "Name:Role:player:Entity",
                          "valueString" : "stabilizer&"
                        },
                        {
                          "code" : "Name:Role:scoper:Entity",
                          "valueString" : "stabilizerOf&"
                        },
                        {
                          "code" : "Sort:Entity:playedRole:Role",
                          "valueString" : "ABDDB____"
                        },
                        {
                          "code" : "Sort:Entity:scopedRole:Role",
                          "valueString" : "ABDDB____"
                        },
                        {
                          "code" : "Name:Entity:playedRole:Role",
                          "valueString" : "as&"
                        },
                        {
                          "code" : "Name:Entity:scopedRole:Role",
                          "valueString" : "&"
                        },
                        {
                          "code" : "Name:Participation:role:Role",
                          "valueString" : "&"
                        }
                      ]
                    }
                  ]
                },
                {
                  "code" : "MECH",
                  "display" : "mechanical ingredient",
                  "definition" : "An ingredient (player) of a medication (scoper) that is inseparable from the active ingredients, but has no intended chemical or pharmaceutical effect itself, but which may have some systemic effect on the patient.\r\n\r\nAn example is a collagen matrix used as a base for transplanting skin cells. The collagen matrix can be left permanently in the graft site. Because it is of bovine origin, the patient may exhibit allergies or may have cultural objections to its use.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "23060"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "mechanicalIngredient"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "LOCE",
              "display" : "located entity",
              "definition" : "Relates an entity (player) to a location (scoper) at which it is present in some way. This presence may be limited in time.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "16815"
                },
                {
                  "code" : "Name:Class",
                  "valueString" : "locatedEntity"
                },
                {
                  "code" : "Name:Role:player:Entity",
                  "valueString" : "located(&|Entity)"
                },
                {
                  "code" : "Name:Role:scoper:Entity",
                  "valueString" : "location(&-PLC)"
                },
                {
                  "code" : "Sort:Entity:playedRole:Role",
                  "valueString" : "ABE______"
                },
                {
                  "code" : "Sort:Entity:scopedRole:Role",
                  "valueString" : "ABE______"
                },
                {
                  "code" : "Name:Entity:playedRole:Role",
                  "valueString" : "as&"
                },
                {
                  "code" : "Name:Entity:scopedRole:Role",
                  "valueString" : "&"
                },
                {
                  "code" : "Name:Participation:role:Role",
                  "valueString" : "&"
                }
              ],
              "concept" : [
                {
                  "code" : "STOR",
                  "display" : "stored entity",
                  "definition" : "Relates an entity (player) (e.g. a device) to a location (scoper) at which it is normally found or stored when not used.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "16817"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "storedEntity"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "stored(&|Entity)"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "storageLocation(&-PLC)"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "ABEA_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "ABEA_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "MBR",
              "display" : "member",
              "definition" : "A role played by an entity that is a member of a group. The group provides the scope for this role.\r\n\r\nAmong other uses, groups as used in insurance (groups of covered individuals) and in scheduling where resources may be grouped for scheduling and logistical purposes.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "12204"
                },
                {
                  "code" : "Name:Class",
                  "valueString" : "member"
                },
                {
                  "code" : "Name:Role:player:Entity",
                  "valueString" : "member&"
                },
                {
                  "code" : "Name:Role:scoper:Entity",
                  "valueString" : "group&"
                },
                {
                  "code" : "Sort:Entity:playedRole:Role",
                  "valueString" : "ABF______"
                },
                {
                  "code" : "Sort:Entity:scopedRole:Role",
                  "valueString" : "ABF______"
                },
                {
                  "code" : "Name:Entity:playedRole:Role",
                  "valueString" : "as&"
                },
                {
                  "code" : "Name:Entity:scopedRole:Role",
                  "valueString" : "&"
                },
                {
                  "code" : "Name:Participation:role:Role",
                  "valueString" : "&"
                }
              ]
            },
            {
              "code" : "PART",
              "display" : "part",
              "definition" : "**Definition:**  an association between two Entities where the playing Entity (the part) is a component of the whole (scoper) in the sense of an integral structural component, that is distinct from other parts in the same whole, has a distinct function in the whole, and, as an effect, the full integrity of the whole depends (to some degree) on the presence of this part, even though the part may often be separable from the whole.\r\n\r\n**Discussion:** Part is defined in opposition to (a) ingredient (not separable), (b) content (not a functional component), and (c) member (not functionally distinct from other members).",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "19102"
                },
                {
                  "code" : "Name:Class",
                  "valueString" : "partOfWhole"
                },
                {
                  "code" : "Name:Role:player:Entity",
                  "valueString" : "part&"
                },
                {
                  "code" : "Name:Role:scoper:Entity",
                  "valueString" : "whole&"
                },
                {
                  "code" : "Sort:Entity:playedRole:Role",
                  "valueString" : "ABC______"
                },
                {
                  "code" : "Sort:Entity:scopedRole:Role",
                  "valueString" : "ABC______"
                },
                {
                  "code" : "Name:Entity:playedRole:Role",
                  "valueString" : "as&"
                },
                {
                  "code" : "Name:Entity:scopedRole:Role",
                  "valueString" : "&"
                },
                {
                  "code" : "Name:Participation:role:Role",
                  "valueString" : "&"
                }
              ],
              "concept" : [
                {
                  "code" : "ACTM",
                  "display" : "active moiety",
                  "definition" : "The molecule or ion that is responsible for the intended pharmacological action of the drug substance, excluding those appended or associated parts of the molecule that make the molecule an ester, salt (including a salt with hydrogen or coordination bonds), or other noncovalent derivative (such as a complex, chelate, or clathrate).\r\n\r\nExamples: heparin-sodium and heparin-potassium have the same active moiety, heparin; the active moiety of morphine-hydrochloride is morphine.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "19088"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "activeMoiety"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "activeMoiety"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "moietyOf&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "ABDB_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "ABDB_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                }
              ]
            },
            {
              "code" : "SPEC",
              "display" : "specimen",
              "definition" : "A role played by a material entity that is a specimen for an act. It is scoped by the source of the specimen.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "11591"
                },
                {
                  "code" : "Name:Class",
                  "valueString" : "specimen"
                },
                {
                  "code" : "Name:Role:player:Entity",
                  "valueString" : "specimen&"
                },
                {
                  "code" : "Name:Role:scoper:Entity",
                  "valueString" : "source&"
                },
                {
                  "code" : "Sort:Entity:playedRole:Role",
                  "valueString" : "ABA______"
                },
                {
                  "code" : "Sort:Entity:scopedRole:Role",
                  "valueString" : "ABA______"
                },
                {
                  "code" : "Name:Entity:playedRole:Role",
                  "valueString" : "as&"
                },
                {
                  "code" : "Name:Entity:scopedRole:Role",
                  "valueString" : "&"
                },
                {
                  "code" : "Name:Participation:role:Role",
                  "valueString" : "&"
                }
              ],
              "concept" : [
                {
                  "code" : "ALQT",
                  "display" : "aliquot",
                  "definition" : "A portion (player) of an original or source specimen (scoper) used for testing or transportation.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "14026"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "aliquot"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "aliquot&"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "source&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "ABAA_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "ABAA_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                },
                {
                  "code" : "ISLT",
                  "display" : "isolate",
                  "definition" : "A microorganism that has been isolated from other microorganisms or a source matrix.",
                  "property" : [
                    {
                      "code" : "status",
                      "valueCode" : "active"
                    },
                    {
                      "code" : "internalId",
                      "valueCode" : "16302"
                    },
                    {
                      "code" : "Name:Class",
                      "valueString" : "isolate"
                    },
                    {
                      "code" : "Name:Role:player:Entity",
                      "valueString" : "isolate&"
                    },
                    {
                      "code" : "Name:Role:scoper:Entity",
                      "valueString" : "source&"
                    },
                    {
                      "code" : "Sort:Entity:playedRole:Role",
                      "valueString" : "ABAB_____"
                    },
                    {
                      "code" : "Sort:Entity:scopedRole:Role",
                      "valueString" : "ABAB_____"
                    },
                    {
                      "code" : "Name:Entity:playedRole:Role",
                      "valueString" : "as&"
                    },
                    {
                      "code" : "Name:Entity:scopedRole:Role",
                      "valueString" : "&"
                    },
                    {
                      "code" : "Name:Participation:role:Role",
                      "valueString" : "&"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "CHILD",
      "display" : "child",
      "definition" : "The player of the role is a child of the scoping entity, in a generic sense.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "11560"
        },
        {
          "code" : "Name:Entity:playedRole:Role",
          "valueString" : "as&"
        },
        {
          "code" : "Name:Entity:scopedRole:Role",
          "valueString" : "&"
        },
        {
          "code" : "Name:Participation:role:Role",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "CRED",
      "display" : "credentialed entity",
      "definition" : "A role played by an entity that receives credentials from the scoping entity.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "16930"
        },
        {
          "code" : "Name:Entity:playedRole:Role",
          "valueString" : "as&"
        },
        {
          "code" : "Name:Entity:scopedRole:Role",
          "valueString" : "&"
        },
        {
          "code" : "Name:Participation:role:Role",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "NURPRAC",
      "display" : "nurse practitioner",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "11574"
        },
        {
          "code" : "Name:Entity:playedRole:Role",
          "valueString" : "as&"
        },
        {
          "code" : "Name:Entity:scopedRole:Role",
          "valueString" : "&"
        },
        {
          "code" : "Name:Participation:role:Role",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "NURS",
      "display" : "nurse",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "11573"
        },
        {
          "code" : "Name:Entity:playedRole:Role",
          "valueString" : "as&"
        },
        {
          "code" : "Name:Entity:scopedRole:Role",
          "valueString" : "&"
        },
        {
          "code" : "Name:Participation:role:Role",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "PA",
      "display" : "physician assistant",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "11575"
        },
        {
          "code" : "Name:Entity:playedRole:Role",
          "valueString" : "as&"
        },
        {
          "code" : "Name:Entity:scopedRole:Role",
          "valueString" : "&"
        },
        {
          "code" : "Name:Participation:role:Role",
          "valueString" : "&"
        }
      ]
    },
    {
      "code" : "PHYS",
      "display" : "physician",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "11572"
        },
        {
          "code" : "Name:Entity:playedRole:Role",
          "valueString" : "as&"
        },
        {
          "code" : "Name:Entity:scopedRole:Role",
          "valueString" : "&"
        },
        {
          "code" : "Name:Participation:role:Role",
          "valueString" : "&"
        }
      ]
    }
  ]
}

```
