# ISO 3166 Numeric country Codes - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ISO 3166 Numeric country Codes**

## CodeSystem: ISO 3166 Numeric country Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-ISO3166-3retired | *Version*:2.0.1 | |
| Retired as of 2019-03-20 | *Responsible:*ISO | *Computable Name*:ISO31663retired |
| *Other Identifiers:*OID:2.16.3 | | |

 
Numeric country codes 
Note that this was erroneously entered into the HL7 system some years ago and has been replaced by 1.0.3166.1.2.1 at the request of ISO. 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-ISO3166-3retired",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-ISO3166-3retired",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.3"
    }
  ],
  "version" : "2.0.1",
  "name" : "ISO31663retired",
  "title" : "ISO 3166 Numeric country Codes",
  "status" : "retired",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "ISO",
  "contact" : [
    {
      "name" : "International Standards Organization (ISO)"
    }
  ],
  "description" : "Numeric country codes\r\n\r\nNote that this was erroneously entered into the HL7 system some years ago and has been replaced by 1.0.3166.1.2.1 at the request of ISO.",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Specializes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Generalizes"
        }
      ],
      "code" : "Specializes",
      "description" : "The child code is a more narrow version of the concept represented by the parent code.  I.e. Every child concept is also a valid parent concept.  Used to allow determination of subsumption.  Must be transitive, irreflexive, antisymmetric.",
      "type" : "Coding"
    },
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Generalizes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Specializes"
        }
      ],
      "code" : "Generalizes",
      "description" : "Inverse of Specializes.  Only included as a derived relationship.",
      "type" : "Coding"
    },
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    }
  ]
}

```
