# Healthcare Provider Taxonomy HIPAA - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Healthcare Provider Taxonomy HIPAA**

## CodeSystem: Healthcare Provider Taxonomy HIPAA 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-HealthcareProviderTaxonomyHIPAA | *Version*:3.0.1 | |
| Retired as of 2019-03-20 | *Responsible:*National Uniform Claims Committee (NUCC) | *Computable Name*:HealthcareProviderTaxonomyHIPAA |
| *Other Identifiers:*OID:2.16.840.1.113883.5.53 | | |
| **Copyright/Legal**: This HL7 specification contains and references intellectual property owned by third parties ("Third Party IP"). Implementers and testers of this specification SHALL abide by the license requirements for each terminology content artifact utilized within a functioning implementation. Terminology licenses SHALL be obtained from the Third Party IP owner for each code system and/or other specified artifact used. It is the sole responsibility of each organization deploying or testing this specification to ensure their implementations comply with licensing requirements of each Third Party IP. Note this code system stub has been retired; there is incomplete and incorrect content, and possible IP restriction violation; it has been superceded. | | |

 
NUCC Healthcare Provider Taxonomy codes, as cited in US HIPAA regulations. This HL7 copy of the content is made available by request of various HL7 Affiliates,so do have have direect access to the NUCC contnet as they are outside the US. In additions, some concept have been added to this set that are pending being added to the NUCC master. 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

Language: en

**Properties**

**This code system defines the following properties for its concepts**

**Concepts**

This case-sensitive code system `http://terminology.hl7.org/CodeSystem/v3-HealthcareProviderTaxonomyHIPAA` provides **a fragment** that includes following codes in a Is-A hierarchy:

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-HealthcareProviderTaxonomyHIPAA",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-HealthcareProviderTaxonomyHIPAA",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.53"
    }
  ],
  "version" : "3.0.1",
  "name" : "HealthcareProviderTaxonomyHIPAA",
  "title" : "Healthcare Provider Taxonomy HIPAA",
  "status" : "retired",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "National Uniform Claims Committee (NUCC)",
  "contact" : [
    {
      "name" : "Health Level Seven"
    }
  ],
  "description" : "NUCC Healthcare Provider Taxonomy codes, as cited in US HIPAA regulations.  This HL7 copy of the content is made available by request of various HL7 Affiliates,so do have have direect access to the NUCC contnet as they are outside the US.  In additions, some concept have been added to this set that are pending being added to the NUCC master.",
  "copyright" : "This HL7 specification contains and references intellectual property owned by third parties (\"Third Party IP\").  Implementers and testers of this specification SHALL abide by the license requirements for each terminology content artifact utilized within a functioning implementation. Terminology licenses SHALL be obtained from the Third Party IP owner for each code system and/or other specified artifact used. It is the sole responsibility of each organization deploying or testing this specification to ensure their implementations comply with licensing requirements of each Third Party IP. Note this code system stub has been retired; there is incomplete and incorrect content, and possible IP restriction violation; it has been superceded.",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "fragment",
  "property" : [
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Specializes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Generalizes"
        }
      ],
      "code" : "Specializes",
      "description" : "The child code is a more narrow version of the concept represented by the parent code.  I.e. Every child concept is also a valid parent concept.  Used to allow determination of subsumption.  Must be transitive, irreflexive, antisymmetric.",
      "type" : "Coding"
    },
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Generalizes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Specializes"
        }
      ],
      "code" : "Generalizes",
      "description" : "Inverse of Specializes.  Only included as a derived relationship.",
      "type" : "Coding"
    },
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "101Y00000N",
      "display" : "Behavioral Health & Social Service; Counselor",
      "definition" : "A provider who is trained and educated in the performance of behavior health services through interpersonal communications and analysis. Training and education at the specialty level usually requires a master's degree and clinical experience and supervision for licensure or certification.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13132"
        }
      ],
      "concept" : [
        {
          "code" : "101YA0400N",
          "display" : "Behavioral Health & Social Service; Counselor; Addiction (Substance Use Disorder)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13141"
            }
          ]
        },
        {
          "code" : "101YM0800N",
          "display" : "Behavioral Health & Social Service; Counselor; Mental Health",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13142"
            }
          ]
        },
        {
          "code" : "101YP1600N",
          "display" : "Behavioral Health & Social Service; Counselor; Pastoral",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13143"
            }
          ]
        },
        {
          "code" : "101YP2500N",
          "display" : "Behavioral Health & Social Service; Counselor; Professional",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13144"
            }
          ]
        },
        {
          "code" : "101YS0200N",
          "display" : "Behavioral Health & Social Service; Counselor; School",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13145"
            }
          ]
        }
      ]
    },
    {
      "code" : "103GC0700N",
      "display" : "Behavioral Health & Social Service; Neuropsychologist; Clinical",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13148"
        }
      ]
    },
    {
      "code" : "103S00000N",
      "display" : "Behavioral Health & Social Service; Psychoanalyst",
      "definition" : "(1) A practitioner of psychoanalysis: methods of eliciting from patients their past emotional experiences and their role in influencing their current mental life, in order to discover the conflicts and mechanisms by which their pathologic mental state has been produced and to furnish hints for psychotherapeutic procedures, the method employs free association, recall and interpretation of dreams and interpretation of transference and resistance phenomena; (2) An individual who is educated with a doctor's degree in psychoanalysis or psychology, trained at an established psychoanalytic institute, and practices or adheres to the principles of psychoanalysis. Psychoanalysis is a form of psychotherapy and a system of investigation for determining and understanding mental processes, which was originally conceived by Sigmund Freud. Psychoanalysis involves the analysis and interpretation of dreams, resistances, and transferences, and uses free association and catharsis. Clinical practice requires licensure.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13149"
        }
      ],
      "concept" : [
        {
          "code" : "103SA1400N",
          "display" : "Behavioral Health & Social Service; Psychoanalyst; Associate",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13151"
            }
          ]
        },
        {
          "code" : "103SA1800N",
          "display" : "Behavioral Health & Social Service; Psychoanalyst; Affiliate",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13150"
            }
          ]
        }
      ]
    },
    {
      "code" : "103T00000N",
      "display" : "Behavioral Health & Social Service; Psychologist",
      "definition" : "An individual who specializes in psychological research, testing, and/or therapy. Psychology is the branch of science that deals with mental processes and behavior, composed of the following major fields: abnormal, clinical, comparative, counseling, developmental, educational, engineering, experimental, industrial, learning, motivation, perception, personality, physiological, psychometrics, school, and social psychology.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13152"
        }
      ],
      "concept" : [
        {
          "code" : "103TA0400N",
          "display" : "Behavioral Health & Social Service; Psychologist; Addiction (Substance Use Disorder)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13153"
            }
          ]
        },
        {
          "code" : "103TA0700N",
          "display" : "Behavioral Health & Social Service; Psychologist; Adult Development & Aging",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13154"
            }
          ]
        },
        {
          "code" : "103TB0200N",
          "display" : "Behavioral Health & Social Service; Psychologist; Behavioral",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13155"
            }
          ]
        },
        {
          "code" : "103TC0700N",
          "display" : "Behavioral Health & Social Service; Psychologist; Clinical",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13157"
            }
          ]
        },
        {
          "code" : "103TC1900N",
          "display" : "Behavioral Health & Social Service; Psychologist; Counseling",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13158"
            }
          ]
        },
        {
          "code" : "103TC2200N",
          "display" : "Behavioral Health & Social Service; Psychologist; Child, Youth & Family",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13156"
            }
          ]
        },
        {
          "code" : "103TE1000N",
          "display" : "Behavioral Health & Social Service; Psychologist; Educational",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13159"
            }
          ]
        },
        {
          "code" : "103TE1100N",
          "display" : "Behavioral Health & Social Service; Psychologist; Exercise & Sports",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13160"
            }
          ]
        },
        {
          "code" : "103TF0000N",
          "display" : "Behavioral Health & Social Service; Psychologist; Family",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13161"
            }
          ]
        },
        {
          "code" : "103TF0200N",
          "display" : "Behavioral Health & Social Service; Psychologist; Forensic",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13162"
            }
          ]
        },
        {
          "code" : "103TH0100N",
          "display" : "Behavioral Health & Social Service; Psychologist; Health",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13163"
            }
          ]
        },
        {
          "code" : "103TM1700N",
          "display" : "Behavioral Health & Social Service; Psychologist; Men & Masculinity",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13164"
            }
          ]
        },
        {
          "code" : "103TM1800N",
          "display" : "Behavioral Health & Social Service; Psychologist; Mental Retardation & Developmental Disabilities",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13165"
            }
          ]
        },
        {
          "code" : "103TP2700N",
          "display" : "Behavioral Health & Social Service; Psychologist; Psychotherapy",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13166"
            }
          ]
        },
        {
          "code" : "103TP2701N",
          "display" : "Behavioral Health & Social Service; Psychologist; Psychotherapy, Group",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13167"
            }
          ]
        },
        {
          "code" : "103TR0400N",
          "display" : "Behavioral Health & Social Service; Psychologist; Rehabilitation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13168"
            }
          ]
        },
        {
          "code" : "103TS0200N",
          "display" : "Behavioral Health & Social Service; Psychologist; School",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13169"
            }
          ]
        },
        {
          "code" : "103TW0100N",
          "display" : "Behavioral Health & Social Service; Psychologist; Women",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13170"
            }
          ]
        }
      ]
    },
    {
      "code" : "104100000N",
      "display" : "Behavioral Health & Social Service; Social Worker",
      "definition" : "A clinical social worker is a person who is qualified by a master of Social Work (M.S.W.) degree, licensed, certified or registered by the state as a social worker and practicing within the scope of that license. A social worker provides assistance and counseling to patients and their families and dealing with social, emotional and environmental problems.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13171"
        }
      ],
      "concept" : [
        {
          "code" : "1041C0700N",
          "display" : "Behavioral Health & Social Service; Social Worker; Clinical",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13172"
            }
          ]
        },
        {
          "code" : "1041S0200N",
          "display" : "Behavioral Health & Social Service; Social Worker; School",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13173"
            }
          ]
        }
      ]
    },
    {
      "code" : "106H00000N",
      "display" : "Behavioral Health & Social Service; Marriage & Family Therapist",
      "definition" : "A mental health provider, e.g. social worker, psychologist, etc. who concentrates his/her practice on the social, emotional and psychological treatment of married couples and families.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13146"
        }
      ]
    },
    {
      "code" : "111N00000N",
      "display" : "Chiropracters; Chiropractor",
      "definition" : "A provider qualified by a Doctor of Chiropractic (D.C.), licensed by the State and who practices chiropractic medicine -that discipline within the healing arts which deals with the nervous system and its relationship to the spinal column and its interrelationship with other body systems.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13175"
        }
      ],
      "concept" : [
        {
          "code" : "111NI0900N",
          "display" : "Chiropracters; Chiropractor; Internist",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13176"
            }
          ]
        },
        {
          "code" : "111NN0400N",
          "display" : "Chiropracters; Chiropractor; Neurology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13177"
            }
          ]
        },
        {
          "code" : "111NN1001N",
          "display" : "Chiropracters; Chiropractor; Nutrition",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13178"
            }
          ]
        },
        {
          "code" : "111NR0200N",
          "display" : "Chiropracters; Chiropractor; Radiology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13181"
            }
          ]
        },
        {
          "code" : "111NS0005N",
          "display" : "Chiropracters; Chiropractor; Sports Physician",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13182"
            }
          ]
        },
        {
          "code" : "111NT0100N",
          "display" : "Chiropracters; Chiropractor; Thermography",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13183"
            }
          ]
        },
        {
          "code" : "111NX0100N",
          "display" : "Chiropracters; Chiropractor; Occupational Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13179"
            }
          ]
        },
        {
          "code" : "111NX0800N",
          "display" : "Chiropracters; Chiropractor; Orthopedic",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13180"
            }
          ]
        }
      ]
    },
    {
      "code" : "122300000N",
      "display" : "Dental Service Providers; Dentist",
      "definition" : "A dentist is a person qualified by a doctorate in dental surgery (D.D. S.) or dental medicine (D.M.D.). licensed by the state to practice dentistry, and practicing within the scope of that license. Many dentists are general practitioners who handle a wide variety of dental needs. Other dentists practice in one of eight specialty areas recognized by the American Dental Association: oral and maxillofacial surgery, orthodontics, periodontics, prosthodontics, endodontics, public health, oral pathology and pediatric dentistry.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13188"
        }
      ],
      "concept" : [
        {
          "code" : "1223D0001Y",
          "display" : "Dental Service Providers; Dentist; Dental Public Health",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13189"
            }
          ]
        },
        {
          "code" : "1223E0200Y",
          "display" : "Dental Service Providers; Dentist; Endodontics",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13190"
            }
          ]
        },
        {
          "code" : "1223P0106Y",
          "display" : "Dental Service Providers; Dentist; Pathology, Oral & Maxillofacial",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13192"
            }
          ]
        },
        {
          "code" : "1223P0221Y",
          "display" : "Dental Service Providers; Dentist; Pediatrics Dentistry (Pedodontics)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13193"
            }
          ]
        },
        {
          "code" : "1223P0300Y",
          "display" : "Dental Service Providers; Dentist; Periodontics",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13194"
            }
          ]
        },
        {
          "code" : "1223P0700Y",
          "display" : "Dental Service Providers; Dentist; Prosthodontics",
          "designation" : [
            {
              "language" : "en",
              "use" : {
                "system" : "http://snomed.info/sct",
                "code" : "900000000000013009"
              },
              "value" : "Prosthodontics"
            }
          ],
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13195"
            }
          ]
        },
        {
          "code" : "1223S0112Y",
          "display" : "Dental Service Providers; Dentist; Surgery, Oral & Maxillofacial",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13196"
            }
          ]
        },
        {
          "code" : "1223X0400Y",
          "display" : "Dental Service Providers; Dentist; Orthodontics",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13191"
            }
          ]
        }
      ]
    },
    {
      "code" : "124Q00000N",
      "display" : "Dental Service Providers; Dental Hygienist",
      "definition" : "An individual who assists at the chairside in a dental operatory, performs reception and clerical functions, and does dental radiograph and selected dental laboratory procedures under the direction and supervision of a dentist. Post-high school education and education is not required, but many dental assistants are graduates of one or two-year post-high school education programs accredited by the Commission on Dental Accreditation. The balance of dental assistants are trained by the dentists who employ them.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13186"
        }
      ]
    },
    {
      "code" : "126800000N",
      "display" : "Dental Service Providers; Dental Assistant",
      "definition" : "An individual who assists at the chairside in a dental operatory, performs reception and clerical functions, and does dental radiograph and selected dental laboratory procedures under the direction and supervision of a dentist. Post-high school education and education is not required, but many dental assistants are graduates of one or two-year post-high school education programs accredited by the Commission on Dental Accreditation. The balance of dental assistants are trained by the dentists who employ them.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13185"
        }
      ]
    },
    {
      "code" : "126900000N",
      "display" : "Dental Service Providers; Dental Laboratory Technician",
      "definition" : "An individual trained or educated to perform one or more phases of the dental laboratory procedures required in the creation of a dental prosthetic, fabricated under a dental prescription (work authorization).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13187"
        }
      ]
    },
    {
      "code" : "1327D0700N",
      "display" : "Dietary & Nutritional Service Providers; Dietary Manager; Dietary Management",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13199"
        }
      ]
    },
    {
      "code" : "133N00000N",
      "display" : "Dietary & Nutritional Service Providers; Nutritionist",
      "definition" : "A specialist in adapting and applying food and nutrient knowledge to the solution of food and nutritional problems, the control of disease, and the promotion of health. Nutritionists perform research, instruct groups and individuals about nutritional requirements, and assist people in developing meal patterns that meet their nutritional needs; (2) A nutritionist is someone who has completed undergraduate and/or graduate training in the discipline of nutrition without necessarily meeting the academic and experience requirements to qualify for the Registered Dietitian designation.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13205"
        }
      ],
      "concept" : [
        {
          "code" : "133NN1002N",
          "display" : "Dietary & Nutritional Service Providers; Nutritionist; Nutrition, Education",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13206"
            }
          ]
        }
      ]
    },
    {
      "code" : "133V00000N",
      "display" : "Dietary & Nutritional Service Providers; Dietician, Registered",
      "definition" : "A registered dietician (RD) is a food and nutrition expert who has successfully completed a minimum of a bachelor's degree at a US regionally accredited university or college and course work approved by The American Dietetic Association (ADA); an ADA-accredited or approved, supervised practice program, typically 6 to 12 months in length; a national examination administered by the Commission on Dietetic Registration; and continuing professional educational requirements to maintain registration.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13201"
        }
      ],
      "concept" : [
        {
          "code" : "133VN1004N",
          "display" : "Dietary & Nutritional Service Providers; Dietician, Registered; Nutrition, Pediatric",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13203"
            }
          ]
        },
        {
          "code" : "133VN1005N",
          "display" : "Dietary & Nutritional Service Providers; Dietician, Registered; Nutrition, Renal",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13204"
            }
          ]
        },
        {
          "code" : "133VN1006N",
          "display" : "Dietary & Nutritional Service Providers; Dietician, Registered; Nutrition, Metabolic",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13202"
            }
          ]
        }
      ]
    },
    {
      "code" : "136A00000N",
      "display" : "Dietary & Nutritional Service Providers; Dietetic Technician",
      "definition" : "A person trained in food and nutrition who is an integral part of health care and foodservice management teams. A dietetic technician, registered (DTR) has successfully completed at least a two-year associate's degree at a US regionally accredited college or university; a dietetic technician program approved by The American Dietetic Association, including 450 hours of supervised practice experience; a national examination administered by the Commission on Dietetic Registration; and continuing professional educational requirements to maintain registration.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13200"
        }
      ]
    },
    {
      "code" : "146L00000N",
      "display" : "Emergency Medical Service Providers; Emergency Medical Technician, Paramedic",
      "definition" : "An EMT, Paramedic is an individual trained and certified to perform advanced life support (ALS) in medical emergencies based on individual state boards.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13210"
        }
      ]
    },
    {
      "code" : "146M00000N",
      "display" : "Emergency Medical Service Providers; Emergency Medical Technician, Intermediate",
      "definition" : "An Intermediate EMT is an individual trained and certified to perform intermediate life support treatment in medical emergencies based on individual state boards.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13209"
        }
      ]
    },
    {
      "code" : "146N00000N",
      "display" : "Emergency Medical Service Providers; Emergency Medical Technician, Basic",
      "definition" : "A Basic EMT is an individual trained and certified to perform basic life support treatment in medical emergencies based on individual state boards.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13208"
        }
      ]
    },
    {
      "code" : "152W00000N",
      "display" : "Eye and Vision Service Providers; Optometrist",
      "definition" : "An optometrist is a person qualified by a Doctor of Optometry (O.D. ) degree, licensed by the state and practicing within the scope of that license. Optometrists examine the eyes and related structures to determine the presence of any abnormality and prescribe and adapt lenses or optical aids. They use drugs for diagnosis in all states and for treatment in some states. They do not perform surgery.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13212"
        }
      ],
      "concept" : [
        {
          "code" : "152WC0800N",
          "display" : "Eye and Vision Service Providers; Optometrist; Contact Lens",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13213"
            }
          ]
        },
        {
          "code" : "152WL0500N",
          "display" : "Eye and Vision Service Providers; Optometrist; Low Vision",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13214"
            }
          ]
        },
        {
          "code" : "152WP0200N",
          "display" : "Eye and Vision Service Providers; Optometrist; Pediatrics",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13216"
            }
          ]
        },
        {
          "code" : "152WS0006N",
          "display" : "Eye and Vision Service Providers; Optometrist; Sports Vision",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13217"
            }
          ]
        },
        {
          "code" : "152WV0400N",
          "display" : "Eye and Vision Service Providers; Optometrist; Vision Therapy",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13218"
            }
          ]
        },
        {
          "code" : "152WX0102N",
          "display" : "Eye and Vision Service Providers; Optometrist; Occupational Vision",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13215"
            }
          ]
        }
      ]
    },
    {
      "code" : "156FC0800N",
      "display" : "Eye and Vision Service Providers; Technician/Technologist; Contact Lens",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13220"
        }
      ]
    },
    {
      "code" : "156FC0801N",
      "display" : "Eye and Vision Service Providers; Technician/Technologist; Contact Lens Fitter",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13221"
        }
      ]
    },
    {
      "code" : "156FX1100N",
      "display" : "Eye and Vision Service Providers; Technician/Technologist; Ophthalmic",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13223"
        }
      ]
    },
    {
      "code" : "156FX1101N",
      "display" : "Eye and Vision Service Providers; Technician/Technologist; Ophthalmic Medical Assistant",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13224"
        }
      ]
    },
    {
      "code" : "156FX1201N",
      "display" : "Eye and Vision Service Providers; Technician/Technologist; Optometric Assistant",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13226"
        }
      ]
    },
    {
      "code" : "156FX1202N",
      "display" : "Eye and Vision Service Providers; Technician/Technologist; Optometric Technician",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13227"
        }
      ]
    },
    {
      "code" : "156FX1700N",
      "display" : "Eye and Vision Service Providers; Technician/Technologist; Ocularist",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13222"
        }
      ]
    },
    {
      "code" : "156FX1800N",
      "display" : "Eye and Vision Service Providers; Technician/Technologist; Optician",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13225"
        }
      ]
    },
    {
      "code" : "156FX1900N",
      "display" : "Eye and Vision Service Providers; Technician/Technologist; Orthoptist",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13228"
        }
      ]
    },
    {
      "code" : "163W00000N",
      "display" : "Nursing Service Providers; Registered Nurse",
      "definition" : "(1) A registered nurse is a person qualified by graduation from an accredited nursing school (depending upon schooling, a registered nurse may receive either a diploma from a hospital program, an associate degree in nursing (A.D.N.) or a Bachelor of Science degree in nursing (B.S.N.), who is licensed or certified by the state, and is practicing within the scope of that license or certification. R.N.'s assist patient in recovering and maintaining their physical or mental health. They assist physicians during treatments and examinations and administer medications. (2) A provider who is trained and educated in a formal nursing education program at an accredited school of nursing, passes a national certification examination, and is licensed by the state to practice nursing. The individual provides nursing services to patients or clients in areas such as health promotion, disease prevention, acute and chronic care and restoration and maintenance of health across the life span.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13232"
        }
      ],
      "concept" : [
        {
          "code" : "163WA0400N",
          "display" : "Nursing Service Providers; Registered Nurse; Addiction (Substance Use Disorder)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13233"
            }
          ]
        },
        {
          "code" : "163WA2000N",
          "display" : "Nursing Service Providers; Registered Nurse; Administrator",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13234"
            }
          ]
        },
        {
          "code" : "163WC0200N",
          "display" : "Nursing Service Providers; Registered Nurse; Critical Care Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13241"
            }
          ]
        },
        {
          "code" : "163WC0400N",
          "display" : "Nursing Service Providers; Registered Nurse; Case Management",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13236"
            }
          ]
        },
        {
          "code" : "163WC1400N",
          "display" : "Nursing Service Providers; Registered Nurse; College Health",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13237"
            }
          ]
        },
        {
          "code" : "163WC1500N",
          "display" : "Nursing Service Providers; Registered Nurse; Community Health",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13238"
            }
          ]
        },
        {
          "code" : "163WC1600N",
          "display" : "Nursing Service Providers; Registered Nurse; Continuing Education/Staff Development",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13240"
            }
          ]
        },
        {
          "code" : "163WC2100N",
          "display" : "Nursing Service Providers; Registered Nurse; Continence Care",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13239"
            }
          ]
        },
        {
          "code" : "163WC3500N",
          "display" : "Nursing Service Providers; Registered Nurse; Cardiac Rehabilitation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13235"
            }
          ]
        },
        {
          "code" : "163WD0400N",
          "display" : "Nursing Service Providers; Registered Nurse; Diabetes Educator",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13242"
            }
          ]
        },
        {
          "code" : "163WD1100N",
          "display" : "Nursing Service Providers; Registered Nurse; Dialysis, Peritoneal",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13243"
            }
          ]
        },
        {
          "code" : "163WE0003N",
          "display" : "Nursing Service Providers; Registered Nurse; Emergency",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13244"
            }
          ]
        },
        {
          "code" : "163WE0900N",
          "display" : "Nursing Service Providers; Registered Nurse; Enterstomal Therapy",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13245"
            }
          ]
        },
        {
          "code" : "163WF0300N",
          "display" : "Nursing Service Providers; Registered Nurse; Flight",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13246"
            }
          ]
        },
        {
          "code" : "163WG0000N",
          "display" : "Nursing Service Providers; Registered Nurse; General Practice",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13248"
            }
          ]
        },
        {
          "code" : "163WG0100N",
          "display" : "Nursing Service Providers; Registered Nurse; Gastroenterology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13247"
            }
          ]
        },
        {
          "code" : "163WG0600N",
          "display" : "Nursing Service Providers; Registered Nurse; Gerontology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13249"
            }
          ]
        },
        {
          "code" : "163WH0200N",
          "display" : "Nursing Service Providers; Registered Nurse; Home Health",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13251"
            }
          ]
        },
        {
          "code" : "163WH0500N",
          "display" : "Nursing Service Providers; Registered Nurse; Hemodialysis",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13250"
            }
          ]
        },
        {
          "code" : "163WH1000N",
          "display" : "Nursing Service Providers; Registered Nurse; Hospice",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13252"
            }
          ]
        },
        {
          "code" : "163WI0500N",
          "display" : "Nursing Service Providers; Registered Nurse; Infusion Therapy",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13254"
            }
          ]
        },
        {
          "code" : "163WI0600N",
          "display" : "Nursing Service Providers; Registered Nurse; Infection Control",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13253"
            }
          ]
        },
        {
          "code" : "163WL0100N",
          "display" : "Nursing Service Providers; Registered Nurse; Lactation Consultant",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13255"
            }
          ]
        },
        {
          "code" : "163WM0102N",
          "display" : "Nursing Service Providers; Registered Nurse; Maternal Newborn",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13257"
            }
          ]
        },
        {
          "code" : "163WM0705N",
          "display" : "Nursing Service Providers; Registered Nurse; Medical-Surgical",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13258"
            }
          ]
        },
        {
          "code" : "163WM1400N",
          "display" : "Nursing Service Providers; Registered Nurse; Massage Therapy",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13256"
            }
          ]
        },
        {
          "code" : "163WN0002N",
          "display" : "Nursing Service Providers; Registered Nurse; Neonatal Intensive Care",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13259"
            }
          ]
        },
        {
          "code" : "163WN0003N",
          "display" : "Nursing Service Providers; Registered Nurse; Neonatal, Low-Risk",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13260"
            }
          ]
        },
        {
          "code" : "163WN0300N",
          "display" : "Nursing Service Providers; Registered Nurse; Nephrology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13261"
            }
          ]
        },
        {
          "code" : "163WN0800N",
          "display" : "Nursing Service Providers; Registered Nurse; Neuroscience",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13262"
            }
          ]
        },
        {
          "code" : "163WN1003N",
          "display" : "Nursing Service Providers; Registered Nurse; Nutrition Support",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13263"
            }
          ]
        },
        {
          "code" : "163WP0000N",
          "display" : "Nursing Service Providers; Registered Nurse; Pain Management",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13273"
            }
          ]
        },
        {
          "code" : "163WP0200N",
          "display" : "Nursing Service Providers; Registered Nurse; Pediatrics",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13275"
            }
          ]
        },
        {
          "code" : "163WP0218N",
          "display" : "Nursing Service Providers; Registered Nurse; Pediatric Oncology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13274"
            }
          ]
        },
        {
          "code" : "163WP0807N",
          "display" : "Nursing Service Providers; Registered Nurse; Psychiatric/Mental Health, Child & Adolescent",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13281"
            }
          ]
        },
        {
          "code" : "163WP0808N",
          "display" : "Nursing Service Providers; Registered Nurse; Psychiatric/Mental Health",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13279"
            }
          ]
        },
        {
          "code" : "163WP0809N",
          "display" : "Nursing Service Providers; Registered Nurse; Psychiatric/Mental Health, Adult",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13280"
            }
          ]
        },
        {
          "code" : "163WP1700N",
          "display" : "Nursing Service Providers; Registered Nurse; Perinatal",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13276"
            }
          ]
        },
        {
          "code" : "163WP2200N",
          "display" : "Nursing Service Providers; Registered Nurse; Post-Anesthesia",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13277"
            }
          ]
        },
        {
          "code" : "163WP2201N",
          "display" : "Nursing Service Providers; Registered Nurse; Post-Anesthesia, Ambulatory",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13278"
            }
          ]
        },
        {
          "code" : "163WR0400N",
          "display" : "Nursing Service Providers; Registered Nurse; Rehabilitation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13282"
            }
          ]
        },
        {
          "code" : "163WR1000N",
          "display" : "Nursing Service Providers; Registered Nurse; Reproductive Endocrinology/Infertility",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13283"
            }
          ]
        },
        {
          "code" : "163WS0121N",
          "display" : "Nursing Service Providers; Registered Nurse; Surgery, Plastic",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13285"
            }
          ]
        },
        {
          "code" : "163WS0200N",
          "display" : "Nursing Service Providers; Registered Nurse; School",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13284"
            }
          ]
        },
        {
          "code" : "163WU0100N",
          "display" : "Nursing Service Providers; Registered Nurse; Urology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13286"
            }
          ]
        },
        {
          "code" : "163WW0000N",
          "display" : "Nursing Service Providers; Registered Nurse; Wound Care",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13288"
            }
          ]
        },
        {
          "code" : "163WW0101N",
          "display" : "Nursing Service Providers; Registered Nurse; Women's Health Care, Ambulatory",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13287"
            }
          ]
        },
        {
          "code" : "163WX0002N",
          "display" : "Nursing Service Providers; Registered Nurse; Obstetric, High-Risk",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13264"
            }
          ]
        },
        {
          "code" : "163WX0003N",
          "display" : "Nursing Service Providers; Registered Nurse; Obstetric, Inpatient",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13265"
            }
          ]
        },
        {
          "code" : "163WX0106N",
          "display" : "Nursing Service Providers; Registered Nurse; Occupational Health",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13266"
            }
          ]
        },
        {
          "code" : "163WX0200N",
          "display" : "Nursing Service Providers; Registered Nurse; Oncology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13267"
            }
          ]
        },
        {
          "code" : "163WX0601N",
          "display" : "Nursing Service Providers; Registered Nurse; Otorhinolaryngology & Head-Neck",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13272"
            }
          ]
        },
        {
          "code" : "163WX0800N",
          "display" : "Nursing Service Providers; Registered Nurse; Orthopedic",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13270"
            }
          ]
        },
        {
          "code" : "163WX1000N",
          "display" : "Nursing Service Providers; Registered Nurse; Operating Room",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13268"
            }
          ]
        },
        {
          "code" : "163WX1100N",
          "display" : "Nursing Service Providers; Registered Nurse; Ophthalmic",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13269"
            }
          ]
        },
        {
          "code" : "163WX1500N",
          "display" : "Nursing Service Providers; Registered Nurse; Ostomy Care",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13271"
            }
          ]
        }
      ]
    },
    {
      "code" : "164W00000N",
      "display" : "Nursing Service Providers; Licensed Practical Nurse",
      "definition" : "An individual with post-high school vocational training and practical experience in the provision of nursing care at a level less than that required for certification as a Registered Nurse. Requirements for education, experience, licensure, and job responsibilities vary among the states.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13230"
        }
      ]
    },
    {
      "code" : "164X00000N",
      "display" : "Nursing Service Providers; Licensed Vocational Nurse",
      "definition" : "An individual with post-high school vocational training and practical experience in the provision of nursing care at a level less than that required for certification as a Registered Nurse. \\[An alternate term for licensed practical nurse arising from difference in occupational titles between states and post-high school training programs and institutions.\\] Requirements for education, experience, licensure, and job responsibilities vary among the states.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13231"
        }
      ]
    },
    {
      "code" : "171100000N",
      "display" : "Other Service Providers; Acupuncturist",
      "definition" : "An acupuncturist is a person who performs ancient therapy for alleviation of pain, anesthesia and treatment of some diseases. Acupuncturists use long, fine needles inserted into specific points in order to treat painful conditions or produce anesthesia.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13137"
        }
      ]
    },
    {
      "code" : "171WH0202N",
      "display" : "Other Service Providers; Contractor; Home Modifications",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13140"
        }
      ]
    },
    {
      "code" : "172A00000N",
      "display" : "Other Service Providers; Driver",
      "definition" : "A person employed to operate a motor vehicle as a carrier of persons or property.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13341"
        }
      ]
    },
    {
      "code" : "173000000N",
      "display" : "Other Service Providers; Legal Medicine",
      "definition" : "The specialty areas of medicine concerned with matters of, and relations with, substantive law and legal institutions; such as the conduct of medical examinations at crime scenes, performance of autopsies, giving of expert medical testimony in judicial proceedings, medical treatment of inmates of penal institutions, the practice of trauma medicine in law enforcement settings, and other clinical practice and medical science applications in the fields of law, law enforcement, and corrections.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13344"
        }
      ]
    },
    {
      "code" : "1744G0900N",
      "display" : "Other Service Providers; Specialist; Graphics Designer",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13348"
        }
      ]
    },
    {
      "code" : "1744P3200N",
      "display" : "Other Service Providers; Specialist; Prosthetics Case Management",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13349"
        }
      ]
    },
    {
      "code" : "1744R1102N",
      "display" : "Other Service Providers; Specialist; Research Study",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13351"
        }
      ]
    },
    {
      "code" : "1744R1103N",
      "display" : "Other Service Providers; Specialist; Research Data Abstracter/Coder",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13350"
        }
      ]
    },
    {
      "code" : "174MM1900N",
      "display" : "Other Service Providers; Veterinarian; Medical Research",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13353"
        }
      ]
    },
    {
      "code" : "175F00000N",
      "display" : "Other Service Providers; Naturopath",
      "definition" : "An individual who practices naturopathy, a system of therapeutics in which neither surgical nor medicinal agents are used, dependence being placed only on natural (nonmedicinal) forces.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13346"
        }
      ]
    },
    {
      "code" : "175L00000N",
      "display" : "Other Service Providers; Homeopath",
      "definition" : "A provider who is educated and trained in a system of therapeutics in which diseases are treated by drugs which are capable of producing in healthy persons symptoms like those of the disease to be treated. Treatment requires administering a drug in minute doses.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13343"
        }
      ]
    },
    {
      "code" : "175M00000N",
      "display" : "Other Service Providers; Midwife, Lay (Non-nurse)",
      "definition" : "A person qualified by experience and limited specialized training to provide obstetric and neo-natal care in the management of women having normal pregnancy, labor and childbirth. The lay midwife is licensed in some states.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13345"
        }
      ]
    },
    {
      "code" : "176P00000N",
      "display" : "Other Service Providers; Funeral Director",
      "definition" : "A person, usually an embalmer, whose business is to arrange for the burial or cremation of the dead and to assist at the funeral rites.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13342"
        }
      ]
    },
    {
      "code" : "183500000N",
      "display" : "Pharmacy Service Providers; Pharmacist",
      "definition" : "An individual who is licensed to prepare and sell or dispense drugs and compounds and to make up prescriptions.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13355"
        }
      ],
      "concept" : [
        {
          "code" : "1835G0000N",
          "display" : "Pharmacy Service Providers; Pharmacist; General Practice",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13356"
            }
          ]
        },
        {
          "code" : "1835N0905N",
          "display" : "Pharmacy Service Providers; Pharmacist; Nuclear Pharmacy",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13357"
            }
          ]
        },
        {
          "code" : "1835N1003N",
          "display" : "Pharmacy Service Providers; Pharmacist; Nutrition Support",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13358"
            }
          ]
        },
        {
          "code" : "1835P1200N",
          "display" : "Pharmacy Service Providers; Pharmacist; Pharmacotherapy",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13359"
            }
          ]
        },
        {
          "code" : "1835P1300N",
          "display" : "Pharmacy Service Providers; Pharmacist; Psychopharmacy",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13360"
            }
          ]
        }
      ]
    },
    {
      "code" : "1847P3400N",
      "display" : "Pharmacy Service Providers; Technician; Pharmacy",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13362"
        }
      ]
    },
    {
      "code" : "203B00000N",
      "display" : "Physicians; Physician/Osteopath",
      "definition" : "A physician is a person qualified by a doctorate in medicine (M.D.) or osteopathy (D.O.), licensed by the state, and practicing within the scope of that license. A physician generally has primary responsibility for the health care of the patient. While M.D.s and D.O.s may use all accepted methods of treatment, including drugs and surgery, D.O.s place special emphasis on the body's musculoskeletal systems.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13426"
        }
      ],
      "concept" : [
        {
          "code" : "203BA0000Y",
          "display" : "Physicians; Physician/Osteopath; Adolescent Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13428"
            }
          ]
        },
        {
          "code" : "203BA0001N",
          "display" : "Physicians; Physician/Osteopath; Adolescent Medicine: Family Practice",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13429"
            }
          ]
        },
        {
          "code" : "203BA0002Y",
          "display" : "Physicians; Physician/Osteopath; Adolescent Medicine: Internal Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13430"
            }
          ]
        },
        {
          "code" : "203BA0003Y",
          "display" : "Physicians; Physician/Osteopath; Adolescent Medicine: Pediatrics",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13431"
            }
          ]
        },
        {
          "code" : "203BA0100Y",
          "display" : "Physicians; Physician/Osteopath; Aerospace Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13434"
            }
          ]
        },
        {
          "code" : "203BA0101Y",
          "display" : "Physicians; Physician/Osteopath; Aerospace Medicine: Preventive Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13435"
            }
          ]
        },
        {
          "code" : "203BA0200N",
          "display" : "Physicians; Physician/Osteopath; Allergy",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13438"
            }
          ]
        },
        {
          "code" : "203BA0201Y",
          "display" : "Physicians; Physician/Osteopath; Allergy & Immunology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13439"
            }
          ]
        },
        {
          "code" : "203BA0202N",
          "display" : "Physicians; Physician/Osteopath; Allergy & Immunology: Internal Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13440"
            }
          ]
        },
        {
          "code" : "203BA0300Y",
          "display" : "Physicians; Physician/Osteopath; Anesthesiology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13441"
            }
          ]
        },
        {
          "code" : "203BA0401N",
          "display" : "Physicians; Physician/Osteopath; Addiction Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13427"
            }
          ]
        },
        {
          "code" : "203BA0501N",
          "display" : "Physicians; Physician/Osteopath; Adolescent Only, Under 16",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13432"
            }
          ]
        },
        {
          "code" : "203BA0502N",
          "display" : "Physicians; Physician/Osteopath; Adolescent Only, Under 21",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13433"
            }
          ]
        },
        {
          "code" : "203BA0503N",
          "display" : "Physicians; Physician/Osteopath; Age Specific, Greater than 1 Year Old",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13436"
            }
          ]
        },
        {
          "code" : "203BA0504N",
          "display" : "Physicians; Physician/Osteopath; Age Specific, Newborns Only",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13437"
            }
          ]
        },
        {
          "code" : "203BB0000N",
          "display" : "Physicians; Physician/Osteopath; Blood Banking",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13442"
            }
          ]
        },
        {
          "code" : "203BB0001Y",
          "display" : "Physicians; Physician/Osteopath; Blood Banking & Transfusion Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13443"
            }
          ]
        },
        {
          "code" : "203BB0100Y",
          "display" : "Physicians; Physician/Osteopath; Body Imaging",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13444"
            }
          ]
        },
        {
          "code" : "203BC0000Y",
          "display" : "Physicians; Physician/Osteopath; Cardiac Electrophysiology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13445"
            }
          ]
        },
        {
          "code" : "203BC0001Y",
          "display" : "Physicians; Physician/Osteopath; Cardiac Electrophysiology, Clinical",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13446"
            }
          ]
        },
        {
          "code" : "203BC0100Y",
          "display" : "Physicians; Physician/Osteopath; Cardiology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13447"
            }
          ]
        },
        {
          "code" : "203BC0200Y",
          "display" : "Physicians; Physician/Osteopath; Critical Care Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13449"
            }
          ]
        },
        {
          "code" : "203BC0201Y",
          "display" : "Physicians; Physician/Osteopath; Critical Care Medicine: Anesthesiology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13450"
            }
          ]
        },
        {
          "code" : "203BC0202Y",
          "display" : "Physicians; Physician/Osteopath; Critical Care Medicine: Internal Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13451"
            }
          ]
        },
        {
          "code" : "203BC0203Y",
          "display" : "Physicians; Physician/Osteopath; Critical Care Medicine: OB/GYN",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13452"
            }
          ]
        },
        {
          "code" : "203BC0300Y",
          "display" : "Physicians; Physician/Osteopath; Cytogenetics, Clinical",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13453"
            }
          ]
        },
        {
          "code" : "203BC0500Y",
          "display" : "Physicians; Physician/Osteopath; Cytopathology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13454"
            }
          ]
        },
        {
          "code" : "203BC2500Y",
          "display" : "Physicians; Physician/Osteopath; Cardiovascular Disease",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13448"
            }
          ]
        },
        {
          "code" : "203BD0100Y",
          "display" : "Physicians; Physician/Osteopath; Dermatology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13455"
            }
          ]
        },
        {
          "code" : "203BD0101Y",
          "display" : "Physicians; Physician/Osteopath; Dermatology Micrographic Surgery",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13456"
            }
          ]
        },
        {
          "code" : "203BD0300N",
          "display" : "Physicians; Physician/Osteopath; Diabetes",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13459"
            }
          ]
        },
        {
          "code" : "203BD0900Y",
          "display" : "Physicians; Physician/Osteopath; Dermatopathology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13457"
            }
          ]
        },
        {
          "code" : "203BD0901N",
          "display" : "Physicians; Physician/Osteopath; Dermatopathology: Dermatology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13458"
            }
          ]
        },
        {
          "code" : "203BE0004Y",
          "display" : "Physicians; Physician/Osteopath; Emergency Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13460"
            }
          ]
        },
        {
          "code" : "203BE0100Y",
          "display" : "Physicians; Physician/Osteopath; Endocrinology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13461"
            }
          ]
        },
        {
          "code" : "203BE0101Y",
          "display" : "Physicians; Physician/Osteopath; Endocrinology, Diabetes & Metabolism",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13462"
            }
          ]
        },
        {
          "code" : "203BE0102Y",
          "display" : "Physicians; Physician/Osteopath; Endocrinology, Reproductive",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13463"
            }
          ]
        },
        {
          "code" : "203BF0100Y",
          "display" : "Physicians; Physician/Osteopath; Family Practice",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13464"
            }
          ]
        },
        {
          "code" : "203BF0201Y",
          "display" : "Physicians; Physician/Osteopath; Forensic Pathology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13465"
            }
          ]
        },
        {
          "code" : "203BF0202N",
          "display" : "Physicians; Physician/Osteopath; Forensic Psychiatry",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13466"
            }
          ]
        },
        {
          "code" : "203BG0000Y",
          "display" : "Physicians; Physician/Osteopath; General Practice",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13468"
            }
          ]
        },
        {
          "code" : "203BG0100Y",
          "display" : "Physicians; Physician/Osteopath; Gastroenterology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13467"
            }
          ]
        },
        {
          "code" : "203BG0200Y",
          "display" : "Physicians; Physician/Osteopath; Genetics, Medical",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13473"
            }
          ]
        },
        {
          "code" : "203BG0201Y",
          "display" : "Physicians; Physician/Osteopath; Genetics, Clinical (M.D.)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13469"
            }
          ]
        },
        {
          "code" : "203BG0202Y",
          "display" : "Physicians; Physician/Osteopath; Genetics, Clinical Biochemical",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13470"
            }
          ]
        },
        {
          "code" : "203BG0203Y",
          "display" : "Physicians; Physician/Osteopath; Genetics, Clinical Molecular",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13472"
            }
          ]
        },
        {
          "code" : "203BG0204Y",
          "display" : "Physicians; Physician/Osteopath; Genetics, Clinical Biochemical/ Molecular",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13471"
            }
          ]
        },
        {
          "code" : "203BG0300N",
          "display" : "Physicians; Physician/Osteopath; Geriatric Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13474"
            }
          ]
        },
        {
          "code" : "203BG0301Y",
          "display" : "Physicians; Physician/Osteopath; Geriatric Medicine: Family Practice",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13475"
            }
          ]
        },
        {
          "code" : "203BG0302Y",
          "display" : "Physicians; Physician/Osteopath; Geriatric Medicine: General Practice",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13476"
            }
          ]
        },
        {
          "code" : "203BG0303Y",
          "display" : "Physicians; Physician/Osteopath; Geriatric Medicine: Internal Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13477"
            }
          ]
        },
        {
          "code" : "203BG0400N",
          "display" : "Physicians; Physician/Osteopath; Gynecology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13478"
            }
          ]
        },
        {
          "code" : "203BH0000Y",
          "display" : "Physicians; Physician/Osteopath; Hematology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13479"
            }
          ]
        },
        {
          "code" : "203BH0001Y",
          "display" : "Physicians; Physician/Osteopath; Hematology: Internal Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13481"
            }
          ]
        },
        {
          "code" : "203BH0002Y",
          "display" : "Physicians; Physician/Osteopath; Hematology: Pathology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13482"
            }
          ]
        },
        {
          "code" : "203BH0003Y",
          "display" : "Physicians; Physician/Osteopath; Hematology & Oncology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13480"
            }
          ]
        },
        {
          "code" : "203BI0001N",
          "display" : "Physicians; Physician/Osteopath; Immunology, Clinical & Laboratory",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13483"
            }
          ]
        },
        {
          "code" : "203BI0002N",
          "display" : "Physicians; Physician/Osteopath; Immunology, Clinical & Laboratory Dermatological",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13484"
            }
          ]
        },
        {
          "code" : "203BI0003Y",
          "display" : "Physicians; Physician/Osteopath; Immunology, Dermatological",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13488"
            }
          ]
        },
        {
          "code" : "203BI0004Y",
          "display" : "Physicians; Physician/Osteopath; Immunology: Laboratory , Diagnostic",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13489"
            }
          ]
        },
        {
          "code" : "203BI0005N",
          "display" : "Physicians; Physician/Osteopath; Immunology, Clinical & Laboratory: Allergy & Immunology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13485"
            }
          ]
        },
        {
          "code" : "203BI0006N",
          "display" : "Physicians; Physician/Osteopath; Immunology, Clinical & Laboratory: Internal Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13486"
            }
          ]
        },
        {
          "code" : "203BI0007N",
          "display" : "Physicians; Physician/Osteopath; Immunology, Clinical & Laboratory: Pediatric",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13487"
            }
          ]
        },
        {
          "code" : "203BI0100Y",
          "display" : "Physicians; Physician/Osteopath; Immunopathology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13490"
            }
          ]
        },
        {
          "code" : "203BI0200Y",
          "display" : "Physicians; Physician/Osteopath; Infectious Diseases",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13491"
            }
          ]
        },
        {
          "code" : "203BI0300Y",
          "display" : "Physicians; Physician/Osteopath; Internal Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13493"
            }
          ]
        },
        {
          "code" : "203BI0400N",
          "display" : "Physicians; Physician/Osteopath; Infertility",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13492"
            }
          ]
        },
        {
          "code" : "203BL0000Y",
          "display" : "Physicians; Physician/Osteopath; Laboratory Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13494"
            }
          ]
        },
        {
          "code" : "203BM0101Y",
          "display" : "Physicians; Physician/Osteopath; Maternal & Fetal Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13495"
            }
          ]
        },
        {
          "code" : "203BM0200Y",
          "display" : "Physicians; Physician/Osteopath; Medical Diseases of the Chest",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13496"
            }
          ]
        },
        {
          "code" : "203BM0300Y",
          "display" : "Physicians; Physician/Osteopath; Medical Microbiology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13497"
            }
          ]
        },
        {
          "code" : "203BN0001Y",
          "display" : "Physicians; Physician/Osteopath; Neonatal-Perinatal Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13498"
            }
          ]
        },
        {
          "code" : "203BN0100Y",
          "display" : "Physicians; Physician/Osteopath; Neonatology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13499"
            }
          ]
        },
        {
          "code" : "203BN0200N",
          "display" : "Physicians; Physician/Osteopath; Neopathology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13500"
            }
          ]
        },
        {
          "code" : "203BN0300Y",
          "display" : "Physicians; Physician/Osteopath; Nephrology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13501"
            }
          ]
        },
        {
          "code" : "203BN0400Y",
          "display" : "Physicians; Physician/Osteopath; Neurology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13502"
            }
          ]
        },
        {
          "code" : "203BN0402Y",
          "display" : "Physicians; Physician/Osteopath; Neurology, Child",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13503"
            }
          ]
        },
        {
          "code" : "203BN0500Y",
          "display" : "Physicians; Physician/Osteopath; Neuropathology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13504"
            }
          ]
        },
        {
          "code" : "203BN0600Y",
          "display" : "Physicians; Physician/Osteopath; Neurophysiology, Clinical",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13505"
            }
          ]
        },
        {
          "code" : "203BN0700Y",
          "display" : "Physicians; Physician/Osteopath; Neuroradiology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13506"
            }
          ]
        },
        {
          "code" : "203BN0900Y",
          "display" : "Physicians; Physician/Osteopath; Nuclear Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13509"
            }
          ]
        },
        {
          "code" : "203BN0901Y",
          "display" : "Physicians; Physician/Osteopath; Nuclear Cardiology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13507"
            }
          ]
        },
        {
          "code" : "203BN0902Y",
          "display" : "Physicians; Physician/Osteopath; Nuclear Imaging & Therapy",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13508"
            }
          ]
        },
        {
          "code" : "203BN0903Y",
          "display" : "Physicians; Physician/Osteopath; Nuclear Medicine, In Vivo & In Vitro",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13510"
            }
          ]
        },
        {
          "code" : "203BN0904Y",
          "display" : "Physicians; Physician/Osteopath; Nuclear Radiology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13511"
            }
          ]
        },
        {
          "code" : "203BP0001Y",
          "display" : "Physicians; Physician/Osteopath; Pain Management - Anesthesiology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13307"
            }
          ]
        },
        {
          "code" : "203BP0100Y",
          "display" : "Physicians; Physician/Osteopath; Pathology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13309"
            }
          ]
        },
        {
          "code" : "203BP0101Y",
          "display" : "Physicians; Physician/Osteopath; Pathology, Anatomic",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13310"
            }
          ]
        },
        {
          "code" : "203BP0102Y",
          "display" : "Physicians; Physician/Osteopath; Pathology, Anatomic & Clinical",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13311"
            }
          ]
        },
        {
          "code" : "203BP0103Y",
          "display" : "Physicians; Physician/Osteopath; Pathology, Anatomic & Laboratory Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13312"
            }
          ]
        },
        {
          "code" : "203BP0104Y",
          "display" : "Physicians; Physician/Osteopath; Pathology, Chemical",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13313"
            }
          ]
        },
        {
          "code" : "203BP0105Y",
          "display" : "Physicians; Physician/Osteopath; Pathology, Clinical",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13314"
            }
          ]
        },
        {
          "code" : "203BP0107N",
          "display" : "Physicians; Physician/Osteopath; Pathology, Radioisotopic",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13315"
            }
          ]
        },
        {
          "code" : "203BP0200Y",
          "display" : "Physicians; Physician/Osteopath; Pediatrics",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13333"
            }
          ]
        },
        {
          "code" : "203BP0201Y",
          "display" : "Physicians; Physician/Osteopath; Pediatric Allergy & Immunology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13316"
            }
          ]
        },
        {
          "code" : "203BP0202Y",
          "display" : "Physicians; Physician/Osteopath; Pediatric Cardiology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13317"
            }
          ]
        },
        {
          "code" : "203BP0203Y",
          "display" : "Physicians; Physician/Osteopath; Pediatric Critical Care Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13318"
            }
          ]
        },
        {
          "code" : "203BP0204Y",
          "display" : "Physicians; Physician/Osteopath; Pediatric Emergency Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13319"
            }
          ]
        },
        {
          "code" : "203BP0205Y",
          "display" : "Physicians; Physician/Osteopath; Pediatric Endocrinology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13320"
            }
          ]
        },
        {
          "code" : "203BP0206Y",
          "display" : "Physicians; Physician/Osteopath; Pediatric Gastroenterology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13321"
            }
          ]
        },
        {
          "code" : "203BP0207Y",
          "display" : "Physicians; Physician/Osteopath; Pediatric Hematology Oncology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13322"
            }
          ]
        },
        {
          "code" : "203BP0208Y",
          "display" : "Physicians; Physician/Osteopath; Pediatric Infectious Diseases",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13323"
            }
          ]
        },
        {
          "code" : "203BP0209Y",
          "display" : "Physicians; Physician/Osteopath; Pediatric Intensive Care",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13324"
            }
          ]
        },
        {
          "code" : "203BP0210Y",
          "display" : "Physicians; Physician/Osteopath; Pediatric Nephrology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13326"
            }
          ]
        },
        {
          "code" : "203BP0211Y",
          "display" : "Physicians; Physician/Osteopath; Pediatric Neurology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13327"
            }
          ]
        },
        {
          "code" : "203BP0212Y",
          "display" : "Physicians; Physician/Osteopath; Pediatric Otolaryngology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13328"
            }
          ]
        },
        {
          "code" : "203BP0213Y",
          "display" : "Physicians; Physician/Osteopath; Pediatric Pathology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13329"
            }
          ]
        },
        {
          "code" : "203BP0214Y",
          "display" : "Physicians; Physician/Osteopath; Pediatric Pulmonology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13330"
            }
          ]
        },
        {
          "code" : "203BP0215N",
          "display" : "Physicians; Physician/Osteopath; Pediatric Radiology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13331"
            }
          ]
        },
        {
          "code" : "203BP0216Y",
          "display" : "Physicians; Physician/Osteopath; Pediatric Rheumatology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13332"
            }
          ]
        },
        {
          "code" : "203BP0220N",
          "display" : "Physicians; Physician/Osteopath; Pediatric Medical Toxocology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13325"
            }
          ]
        },
        {
          "code" : "203BP0400Y",
          "display" : "Physicians; Physician/Osteopath; Physical Medicine & Rehabilitation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13336"
            }
          ]
        },
        {
          "code" : "203BP0500Y",
          "display" : "Physicians; Physician/Osteopath; Preventive Medicine, General",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13337"
            }
          ]
        },
        {
          "code" : "203BP0600Y",
          "display" : "Physicians; Physician/Osteopath; Proctology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13338"
            }
          ]
        },
        {
          "code" : "203BP0800Y",
          "display" : "Physicians; Physician/Osteopath; Psychiatry",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13339"
            }
          ]
        },
        {
          "code" : "203BP0801Y",
          "display" : "Physicians; Physician/Osteopath; Psychiatry & Neurology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13340"
            }
          ]
        },
        {
          "code" : "203BP0802Y",
          "display" : "Physicians; Physician/Osteopath; Psychiatry, Addiction",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13515"
            }
          ]
        },
        {
          "code" : "203BP0803Y",
          "display" : "Physicians; Physician/Osteopath; Psychiatry, Child",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13516"
            }
          ]
        },
        {
          "code" : "203BP0804Y",
          "display" : "Physicians; Physician/Osteopath; Psychiatry, Child & Adolescent",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13517"
            }
          ]
        },
        {
          "code" : "203BP0805Y",
          "display" : "Physicians; Physician/Osteopath; Psychiatry, Geriatric",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13518"
            }
          ]
        },
        {
          "code" : "203BP0806N",
          "display" : "Physicians; Physician/Osteopath; Psychiatry, Pediatric",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13519"
            }
          ]
        },
        {
          "code" : "203BP0901N",
          "display" : "Physicians; Physician/Osteopath; Public Health & General Preventive Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13521"
            }
          ]
        },
        {
          "code" : "203BP0903Y",
          "display" : "Physicians; Physician/Osteopath; Public Health: Preventive Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13522"
            }
          ]
        },
        {
          "code" : "203BP1001Y",
          "display" : "Physicians; Physician/Osteopath; Pulmonary Diseases",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13523"
            }
          ]
        },
        {
          "code" : "203BP1003Y",
          "display" : "Physicians; Physician/Osteopath; Pulmonary Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13524"
            }
          ]
        },
        {
          "code" : "203BP1200N",
          "display" : "Physicians; Physician/Osteopath; Pharmacotherapy",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13335"
            }
          ]
        },
        {
          "code" : "203BP1300N",
          "display" : "Physicians; Physician/Osteopath; Psychopharmacy",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13520"
            }
          ]
        },
        {
          "code" : "203BP2600N",
          "display" : "Physicians; Physician/Osteopath; Pharmacology, Clinical",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13334"
            }
          ]
        },
        {
          "code" : "203BP2900N",
          "display" : "Physicians; Physician/Osteopath; Pain Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13308"
            }
          ]
        },
        {
          "code" : "203BR0001Y",
          "display" : "Physicians; Physician/Osteopath; Radiation Oncology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13525"
            }
          ]
        },
        {
          "code" : "203BR0002Y",
          "display" : "Physicians; Physician/Osteopath; Radiation Therapy",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13526"
            }
          ]
        },
        {
          "code" : "203BR0200Y",
          "display" : "Physicians; Physician/Osteopath; Radiology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13528"
            }
          ]
        },
        {
          "code" : "203BR0201Y",
          "display" : "Physicians; Physician/Osteopath; Radiology, Angiography & Interventional",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13529"
            }
          ]
        },
        {
          "code" : "203BR0202Y",
          "display" : "Physicians; Physician/Osteopath; Radiology, Diagnostic",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13530"
            }
          ]
        },
        {
          "code" : "203BR0203N",
          "display" : "Physicians; Physician/Osteopath; Radiology, Therapeutic",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13531"
            }
          ]
        },
        {
          "code" : "203BR0204N",
          "display" : "Physicians; Physician/Osteopath; Radiology, Vascular & Interventional",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13532"
            }
          ]
        },
        {
          "code" : "203BR0205N",
          "display" : "Physicians; Physician/Osteopath; Radiological Physics",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13527"
            }
          ]
        },
        {
          "code" : "203BR0300N",
          "display" : "Physicians; Physician/Osteopath; Radium Therapy",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13533"
            }
          ]
        },
        {
          "code" : "203BR0402Y",
          "display" : "Physicians; Physician/Osteopath; Rehabilitation Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13534"
            }
          ]
        },
        {
          "code" : "203BR0500Y",
          "display" : "Physicians; Physician/Osteopath; Rheumatology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13535"
            }
          ]
        },
        {
          "code" : "203BR0600N",
          "display" : "Physicians; Physician/Osteopath; Rhinology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13536"
            }
          ]
        },
        {
          "code" : "203BR0700Y",
          "display" : "Physicians; Physician/Osteopath; Roentgenology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13537"
            }
          ]
        },
        {
          "code" : "203BR0701Y",
          "display" : "Physicians; Physician/Osteopath; Roentgenology, Diagnostic",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13538"
            }
          ]
        },
        {
          "code" : "203BS0000Y",
          "display" : "Physicians; Physician/Osteopath; Sports Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13539"
            }
          ]
        },
        {
          "code" : "203BS0001Y",
          "display" : "Physicians; Physician/Osteopath; Sports Medicine: Emergency Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13540"
            }
          ]
        },
        {
          "code" : "203BS0002Y",
          "display" : "Physicians; Physician/Osteopath; Sports Medicine: Family Practice",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13541"
            }
          ]
        },
        {
          "code" : "203BS0003Y",
          "display" : "Physicians; Physician/Osteopath; Sports Medicine: Internal Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13542"
            }
          ]
        },
        {
          "code" : "203BS0004Y",
          "display" : "Physicians; Physician/Osteopath; Sports Medicine: Pediatrics",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13543"
            }
          ]
        },
        {
          "code" : "203BS0100Y",
          "display" : "Physicians; Physician/Osteopath; Surgery, General",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13548"
            }
          ]
        },
        {
          "code" : "203BS0101Y",
          "display" : "Physicians; Physician/Osteopath; Surgery, Colon & Rectal Surgery",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13546"
            }
          ]
        },
        {
          "code" : "203BS0102Y",
          "display" : "Physicians; Physician/Osteopath; Surgical Critical Care: Surgery",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13570"
            }
          ]
        },
        {
          "code" : "203BS0104N",
          "display" : "Physicians; Physician/Osteopath; Surgery, Abdominal",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13544"
            }
          ]
        },
        {
          "code" : "203BS0105Y",
          "display" : "Physicians; Physician/Osteopath; Surgery, Hand",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13550"
            }
          ]
        },
        {
          "code" : "203BS0106Y",
          "display" : "Physicians; Physician/Osteopath; Surgery, Hand: Orthopedic Surgery",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13551"
            }
          ]
        },
        {
          "code" : "203BS0107Y",
          "display" : "Physicians; Physician/Osteopath; Surgery, Hand: Plastic Surgery",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13552"
            }
          ]
        },
        {
          "code" : "203BS0108N",
          "display" : "Physicians; Physician/Osteopath; Surgery, Head & Neck",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13553"
            }
          ]
        },
        {
          "code" : "203BS0110Y",
          "display" : "Physicians; Physician/Osteopath; Surgery, Neurological",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13554"
            }
          ]
        },
        {
          "code" : "203BS0111Y",
          "display" : "Physicians; Physician/Osteopath; Surgery, Obstetric & Gynecologic",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13555"
            }
          ]
        },
        {
          "code" : "203BS0113Y",
          "display" : "Physicians; Physician/Osteopath; Surgery, Orthopedic",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13556"
            }
          ]
        },
        {
          "code" : "203BS0114N",
          "display" : "Physicians; Physician/Osteopath; Surgery, Orthopedic, Adult Reconstructive",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13557"
            }
          ]
        },
        {
          "code" : "203BS0115N",
          "display" : "Physicians; Physician/Osteopath; Surgery, Orthopedic, Musculoskeletal Oncology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13558"
            }
          ]
        },
        {
          "code" : "203BS0116N",
          "display" : "Physicians; Physician/Osteopath; Surgery, Orthopedic, Pediatric",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13559"
            }
          ]
        },
        {
          "code" : "203BS0117N",
          "display" : "Physicians; Physician/Osteopath; Surgery, Orthopedic, Spine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13560"
            }
          ]
        },
        {
          "code" : "203BS0119N",
          "display" : "Physicians; Physician/Osteopath; Surgery, Orthopedic, Trauma",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13561"
            }
          ]
        },
        {
          "code" : "203BS0120Y",
          "display" : "Physicians; Physician/Osteopath; Surgery, Pediatric",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13563"
            }
          ]
        },
        {
          "code" : "203BS0121Y",
          "display" : "Physicians; Physician/Osteopath; Surgery, Plastic",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13564"
            }
          ]
        },
        {
          "code" : "203BS0122Y",
          "display" : "Physicians; Physician/Osteopath; Surgery, Plastic & Reconstructive",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13565"
            }
          ]
        },
        {
          "code" : "203BS0123Y",
          "display" : "Physicians; Physician/Osteopath; Surgery, Facial Plastic",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13547"
            }
          ]
        },
        {
          "code" : "203BS0125Y",
          "display" : "Physicians; Physician/Osteopath; Surgery, Thoracic",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13566"
            }
          ]
        },
        {
          "code" : "203BS0126Y",
          "display" : "Physicians; Physician/Osteopath; Surgery, Thoracic Cardiovascular",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13567"
            }
          ]
        },
        {
          "code" : "203BS0127N",
          "display" : "Physicians; Physician/Osteopath; Surgery, Traumatic",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13568"
            }
          ]
        },
        {
          "code" : "203BS0128Y",
          "display" : "Physicians; Physician/Osteopath; Surgery, Urological",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13569"
            }
          ]
        },
        {
          "code" : "203BS0129Y",
          "display" : "Physicians; Physician/Osteopath; Surgery, General Vascular",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13549"
            }
          ]
        },
        {
          "code" : "203BS0130Y",
          "display" : "Physicians; Physician/Osteopath; Surgery, Otorhinolaryngology & Facial Plastic Surgery",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13562"
            }
          ]
        },
        {
          "code" : "203BS0133N",
          "display" : "Physicians; Physician/Osteopath; Surgery, Cardiovascular",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13545"
            }
          ]
        },
        {
          "code" : "203BT0000Y",
          "display" : "Physicians; Physician/Osteopath; Toxicology, Medical",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13572"
            }
          ]
        },
        {
          "code" : "203BT0001Y",
          "display" : "Physicians; Physician/Osteopath; Toxicology, Medical: Preventive Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13574"
            }
          ]
        },
        {
          "code" : "203BT0002Y",
          "display" : "Physicians; Physician/Osteopath; Toxicology, Medical: Emergency Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13573"
            }
          ]
        },
        {
          "code" : "203BT0100N",
          "display" : "Physicians; Physician/Osteopath; Thermography",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13571"
            }
          ]
        },
        {
          "code" : "203BU0001Y",
          "display" : "Physicians; Physician/Osteopath; Ultrasound, Diagnostic",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13575"
            }
          ]
        },
        {
          "code" : "203BU0100Y",
          "display" : "Physicians; Physician/Osteopath; Urology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13577"
            }
          ]
        },
        {
          "code" : "203BU0300Y",
          "display" : "Physicians; Physician/Osteopath; Underseas Medicine: Preventive Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13576"
            }
          ]
        },
        {
          "code" : "203BX0000N",
          "display" : "Physicians; Physician/Osteopath; Obstetrics",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13512"
            }
          ]
        },
        {
          "code" : "203BX0001Y",
          "display" : "Physicians; Physician/Osteopath; Obstetrics & Gynecology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13513"
            }
          ]
        },
        {
          "code" : "203BX0100Y",
          "display" : "Physicians; Physician/Osteopath; Occupational Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13514"
            }
          ]
        },
        {
          "code" : "203BX0104Y",
          "display" : "Physicians; Physician/Osteopath; Occupational Medicine: Preventive Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13294"
            }
          ]
        },
        {
          "code" : "203BX0105Y",
          "display" : "Physicians; Physician/Osteopath; Occupational-Environmental Medicine: Preventive Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13295"
            }
          ]
        },
        {
          "code" : "203BX0200Y",
          "display" : "Physicians; Physician/Osteopath; Oncology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13296"
            }
          ]
        },
        {
          "code" : "203BX0201Y",
          "display" : "Physicians; Physician/Osteopath; Oncology, Gynecologic",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13297"
            }
          ]
        },
        {
          "code" : "203BX0202Y",
          "display" : "Physicians; Physician/Osteopath; Oncology, Medical",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13298"
            }
          ]
        },
        {
          "code" : "203BX0300Y",
          "display" : "Physicians; Physician/Osteopath; Ophthalmology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13299"
            }
          ]
        },
        {
          "code" : "203BX0500Y",
          "display" : "Physicians; Physician/Osteopath; Otolaryngology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13302"
            }
          ]
        },
        {
          "code" : "203BX0600Y",
          "display" : "Physicians; Physician/Osteopath; Otorhinolaryngology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13305"
            }
          ]
        },
        {
          "code" : "203BX0601N",
          "display" : "Physicians; Physician/Osteopath; Otorhinolaryngology & Head-Neck",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13306"
            }
          ]
        },
        {
          "code" : "203BX0800N",
          "display" : "Physicians; Physician/Osteopath; Orthopedic",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13300"
            }
          ]
        },
        {
          "code" : "203BX0900N",
          "display" : "Physicians; Physician/Osteopath; Otology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13303"
            }
          ]
        },
        {
          "code" : "203BX0901N",
          "display" : "Physicians; Physician/Osteopath; Otology & Neurotology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13304"
            }
          ]
        },
        {
          "code" : "203BX2100Y",
          "display" : "Physicians; Physician/Osteopath; Osteopathic Manipulative Medicine, Special Proficiency",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13301"
            }
          ]
        }
      ]
    },
    {
      "code" : "211D00000N",
      "display" : "Podiatric Medicine & Surgery Service; Assistant, Podiatric",
      "definition" : "An individual who assists a podiatrist in tasks, such as exposing and developing x-rays; taking and recording patient histories; assisting in biomechanical evaluations and negative castings; preparing and sterilizing instruments and equipment; providing the patient with postoperative instructions; applying surgical dressings; preparing the patient for treatment, padding, and strapping; and performing routine office procedures.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13583"
        }
      ]
    },
    {
      "code" : "213E00000N",
      "display" : "Podiatric Medicine & Surgery Service; Podiatrist",
      "definition" : "A podiatrist is a person qualified by a Doctor of Podiatric Medicine (D.P.M.) degree, licensed by the state, and practicing within the scope of that license. Podiatrists diagnose and treat foot diseases and deformities. They perform medical, surgical and other operative procedures, prescribe corrective devices and prescribe and administer drugs and physical therapy.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13584"
        }
      ],
      "concept" : [
        {
          "code" : "213EG0000N",
          "display" : "Podiatric Medicine & Surgery Service; Podiatrist; General Practice",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13585"
            }
          ]
        },
        {
          "code" : "213EP0504N",
          "display" : "Podiatric Medicine & Surgery Service; Podiatrist; Preventive Medicine: Public Health",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13586"
            }
          ]
        },
        {
          "code" : "213EP1101N",
          "display" : "Podiatric Medicine & Surgery Service; Podiatrist; Primary Podiatric Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13587"
            }
          ]
        },
        {
          "code" : "213ER0200N",
          "display" : "Podiatric Medicine & Surgery Service; Podiatrist; Radiology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13588"
            }
          ]
        },
        {
          "code" : "213ES0000N",
          "display" : "Podiatric Medicine & Surgery Service; Podiatrist; Sports Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13589"
            }
          ]
        },
        {
          "code" : "213ES0103N",
          "display" : "Podiatric Medicine & Surgery Service; Podiatrist; Surgery, Foot & Ankle",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13591"
            }
          ]
        },
        {
          "code" : "213ES0131N",
          "display" : "Podiatric Medicine & Surgery Service; Podiatrist; Surgery, Foot",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13590"
            }
          ]
        }
      ]
    },
    {
      "code" : "221700000N",
      "display" : "Respiratory, Rehabilitative & Restorative; Art Therapist",
      "definition" : "(1) An individual who uses art to achieve the therapeutic goals of symptom relief, emotional integration, and recovery from or adjustment to illness or disability. (2) An art therapist uses a form of treatment that enables patients with mental or physical disabilities to use art as a way of expressing and dealing with feelings and inner conflicts. (3) An individual who uses arts modalities and creative processes during intentional intervention in therapeutic, rehabilitative, community, or educational settings to foster health, communication, and expression; promote the integration of physical, emotional, cognitive, and social functioning; enhance self-awareness; and facilitate change.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13593"
        }
      ]
    },
    {
      "code" : "222Z00000N",
      "display" : "Respiratory, Rehabilitative & Restorative; Orthotist",
      "definition" : "An individual skilled in the practice, making, use and application to individual cases of an orthopedic appliance or apparatus used to support, align, prevent or correct deformities or to improve the function of movable parts of the body.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13608"
        }
      ]
    },
    {
      "code" : "224P00000N",
      "display" : "Respiratory, Rehabilitative & Restorative; Prosthetist",
      "definition" : "An individual skilled in the practice, making, use, and application to individual cases of an artificial substitute for a missing body part, such as an arm or leg, eye or tooth, used for functional or cosmetic reasons, or both.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13622"
        }
      ]
    },
    {
      "code" : "224Z00000N",
      "display" : "Respiratory, Rehabilitative & Restorative; Occupational Therapy Assistant",
      "definition" : "An Occupational Therapy assistant: provides medically prescribed occupational therapy services under the supervision of a registered occupational therapist to promote rehabilitation of patients in the hospital, home, schools and other settings; has completed a 2-year associate degree or one of the limited number of certificate programs; has met the qualifications as determined by the representative assembly and thus is entitled to use the term Certified occupational therapy assistant.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13606"
        }
      ]
    },
    {
      "code" : "225000000N",
      "display" : "Respiratory, Rehabilitative & Restorative; Orthotics/Prosthetics Fitter",
      "definition" : "An individual skilled in the practice, making, use and application to individual cases of an orthopedic appliance or apparatus used to support, align, prevent or correct deformities or to improve the function of movable parts of the body.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13607"
        }
      ]
    },
    {
      "code" : "225100000N",
      "display" : "Respiratory, Rehabilitative & Restorative; Physical Therapist",
      "definition" : "(1) Physical therapists are health care professionals who evaluate and treat people with health problems resulting from injury or disease. PT's assess joint motion, muscle strength and endurance, function of heart and lungs, and performance of activities required in daily living, among other responsibilities. Treatment includes therapeutic exercises, cardiovascular endurance training, and training in activities of daily living. (2) A physical therapist is a person qualified by an accredited program in physical therapy, licensed by the state, and practicing within the scope of that license. Physical therapists treat disease, injury, or loss of a bodily part by physical means, such as the application of light, heat, cold, water, electricity, massage and exercise. They develop treatment plans based upon each patient's strengths, weaknesses, range of motion and ability to function. (3) A health professional who specializes in physical therapy- the health care field concerned primarily with the treatment of disorders with physical agents and methods, such as massage, manipulation, therapeutic exercises, cold, heat (including short-wave, microwave, and ultrasonic diathermy), hydrotherapy, electric stimulation and light to assist in rehabilitating patients and in restoring normal function after an illness or injury.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13609"
        }
      ],
      "concept" : [
        {
          "code" : "2251C0400N",
          "display" : "Respiratory, Rehabilitative & Restorative; Physical Therapist; Case Management",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13611"
            }
          ]
        },
        {
          "code" : "2251C2600N",
          "display" : "Respiratory, Rehabilitative & Restorative; Physical Therapist; Cardiopulmonary",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13610"
            }
          ]
        },
        {
          "code" : "2251E1200N",
          "display" : "Respiratory, Rehabilitative & Restorative; Physical Therapist; Ergonomics",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13613"
            }
          ]
        },
        {
          "code" : "2251E1300N",
          "display" : "Respiratory, Rehabilitative & Restorative; Physical Therapist; Electrophysiology, Clinical",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13612"
            }
          ]
        },
        {
          "code" : "2251G0304N",
          "display" : "Respiratory, Rehabilitative & Restorative; Physical Therapist; Geriatrics",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13614"
            }
          ]
        },
        {
          "code" : "2251H1200N",
          "display" : "Respiratory, Rehabilitative & Restorative; Physical Therapist; Hand",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13615"
            }
          ]
        },
        {
          "code" : "2251H1300N",
          "display" : "Respiratory, Rehabilitative & Restorative; Physical Therapist; Human Factors",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13616"
            }
          ]
        },
        {
          "code" : "2251N0400N",
          "display" : "Respiratory, Rehabilitative & Restorative; Physical Therapist; Neurology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13617"
            }
          ]
        },
        {
          "code" : "2251P0200N",
          "display" : "Respiratory, Rehabilitative & Restorative; Physical Therapist; Pediatrics",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13619"
            }
          ]
        },
        {
          "code" : "2251S0007N",
          "display" : "Respiratory, Rehabilitative & Restorative; Physical Therapist; Sports",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13620"
            }
          ]
        },
        {
          "code" : "2251X0800N",
          "display" : "Respiratory, Rehabilitative & Restorative; Physical Therapist; Orthopedic",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13618"
            }
          ]
        }
      ]
    },
    {
      "code" : "225200000N",
      "display" : "Respiratory, Rehabilitative & Restorative; Physical Therapy Assistant",
      "definition" : "(1)Physical therapist assistants are skilled health care providers who are graduates of a physical therapist assistant associate degree program accredited by an agency recognized by the Secretary of the U.S. Department of Education or Council on Postsecondary Accreditation, who assists the physical therapist in providing physical therapy. The supervising physical therapist is directly responsible for the actions of the physical therapist assistant. The PTA performs physical therapy procedures and related tasks that have been selected and delegated by the supervising physical therapist. Duties of the PTA include assisting the physical therapist in implementing treatment programs, training patients in exercised and activities of daily living, conducting treatments, and reporting to the physical therapist on the patient's responses. In addition to direct patient care, the PTA may also perform such functions as patient transport, and clinic or equipment preparation and maintenance. Currently more than half of all states require PTAs to be licensed, registered or certified. (2) An individual who works under the supervision of a physical therapist to assist him or her in providing physical therapy services. A physical therapy assistant may, for instance, help patients follow an appropriate exercise program that will increase their strength, endurance, coordination, and range of motion and train patients to perform activities of daily life.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13621"
        }
      ]
    },
    {
      "code" : "225400000N",
      "display" : "Respiratory, Rehabilitative & Restorative; Rehabilitation Practitioner",
      "definition" : "A health care practitioner who trains or retrains individuals disabled by disease or injury to help them attain their maximum functional capacity.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13628"
        }
      ]
    },
    {
      "code" : "2255A2300N",
      "display" : "Respiratory, Rehabilitative & Restorative; Specialist/Technologist; Athletic Trainer",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13632"
        }
      ]
    },
    {
      "code" : "2255R0406N",
      "display" : "Respiratory, Rehabilitative & Restorative; Specialist/Technologist; Rehabilitation, Blind",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13633"
        }
      ]
    },
    {
      "code" : "225600000N",
      "display" : "Respiratory, Rehabilitative & Restorative; Dance Therapist",
      "definition" : "The dance therapist, sometimes called a movement therapist, focuses on rhythmic body movements as a medium of physical and psychological change. Dance therapy is practiced more often with mental health patients than with physically disabled patients. A master's degree is required by the American Dance Therapy Association to award the credentials Dance Therapist Registered (DTR).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13594"
        }
      ]
    },
    {
      "code" : "225700000N",
      "display" : "Respiratory, Rehabilitative & Restorative; Massage Therapist",
      "definition" : "An individual trained in the manipulation of tissues (as by rubbing, stroking, kneading, or tapping) with the hand or an instrument for remedial or hygienic purposes.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13596"
        }
      ]
    },
    {
      "code" : "225800000N",
      "display" : "Respiratory, Rehabilitative & Restorative; Recreation Therapist",
      "definition" : "A recreation therapist uses recreational activities for intervention in some physical, social or emotional behavior to bring about a desired change in that behavior and promote the growth and development of the patient.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13624"
        }
      ]
    },
    {
      "code" : "225900000N",
      "display" : "Respiratory, Rehabilitative & Restorative; Respiratory Therapist",
      "definition" : "A respiratory therapist is a person who has graduated from a respiratory therapy program accredited by the Committee on Allied Health Education and Accreditation, and where applicable, is licensed by the state and is practicing within the scope of that license. A respiratory therapist administers oxygen and other gases and provides assistance with equipment to patients with either acute or chronic breathing difficulties, often within the home.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13629"
        }
      ],
      "concept" : [
        {
          "code" : "2259P1700N",
          "display" : "Respiratory, Rehabilitative & Restorative; Respiratory Therapist; Perinatal",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13630"
            }
          ]
        }
      ]
    },
    {
      "code" : "225A00000N",
      "display" : "Respiratory, Rehabilitative & Restorative; Music Therapist",
      "definition" : "The music therapist works with patients with a broad variety of diagnoses and therapeutic goals. The interventions may involve musical performance with instruments, voice or body movements; listening to music; or attending musical events.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13597"
        }
      ]
    },
    {
      "code" : "225B00000N",
      "display" : "Respiratory, Rehabilitative & Restorative; Pulmonary Function Technologist",
      "definition" : "An individual who is trained and qualified in the techniques and procedures for assessment and treatment of diseases of the lungs and airways such as pneumonia, cancer, pleurisy, asthma, bronchitis, emphysema, and other disorders. Therapy involves assessment of lung functions, assisting the patient in therapeutic exercise and monitoring mechanical assistance to ventilation.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13623"
        }
      ]
    },
    {
      "code" : "225C00000N",
      "display" : "Respiratory, Rehabilitative & Restorative; Rehabilitation Counselor",
      "definition" : "An individual trained and educated in a systematic process of assisting persons with physical, mental, developmental, cognitive, and emotional disabilities to achieve their personal, career, and independent living goals assessment and appraisal, diagnosis and treatment planning, career (vocational) counseling, individual and group counseling interventions for adjustments to the medical and psychosocial impact of disability, case management, program evaluation and research, job analysis and placement counseling, and consultation on rehabilitation resources and technology. Certification generally requires a Master's degree with specialized courses in rehabilitation processes and technology.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13625"
        }
      ],
      "concept" : [
        {
          "code" : "225CA2400N",
          "display" : "Respiratory, Rehabilitative & Restorative; Rehabilitation Counselor; Assistive Technology Practitioner",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13626"
            }
          ]
        }
      ]
    },
    {
      "code" : "225CA2500N",
      "display" : "Respiratory, Rehabilitative & Restorative; Rehabilitation Counselor; Assistive Technology Supplier",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13627"
        }
      ]
    },
    {
      "code" : "225X00000N",
      "display" : "Respiratory, Rehabilitative & Restorative; Occupational Therapist",
      "definition" : "An occupational therapist is a person qualified by completion of an approved program in occupational therapy, licensed by the state and practicing within the scope of that license, or where licensure does not exist, certified by the American Occupational Therapy Certification Board. An occupational therapist evaluates the self-care, work and leisure performance skills of well and disabled clients and plans and implements programs to restore, develop or maintain the task performance skills necessary for daily living and for the client's particular occupational role.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13598"
        }
      ],
      "concept" : [
        {
          "code" : "225XC0400N",
          "display" : "Respiratory, Rehabilitative & Restorative; Occupational Therapist; Case Management",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13599"
            }
          ]
        },
        {
          "code" : "225XE1200N",
          "display" : "Respiratory, Rehabilitative & Restorative; Occupational Therapist; Ergonomics",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13600"
            }
          ]
        },
        {
          "code" : "225XH1200N",
          "display" : "Respiratory, Rehabilitative & Restorative; Occupational Therapist; Hand",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13601"
            }
          ]
        },
        {
          "code" : "225XH1300N",
          "display" : "Respiratory, Rehabilitative & Restorative; Occupational Therapist; Human Factors",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13602"
            }
          ]
        },
        {
          "code" : "225XN1300N",
          "display" : "Respiratory, Rehabilitative & Restorative; Occupational Therapist; Neurorehabilitation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13603"
            }
          ]
        },
        {
          "code" : "225XP0200N",
          "display" : "Respiratory, Rehabilitative & Restorative; Occupational Therapist; Pediatrics",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13604"
            }
          ]
        },
        {
          "code" : "225XR0403N",
          "display" : "Respiratory, Rehabilitative & Restorative; Occupational Therapist; Rehabilitation, Driver",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13605"
            }
          ]
        }
      ]
    },
    {
      "code" : "226300000N",
      "display" : "Respiratory, Rehabilitative & Restorative; Kinesiotherapist",
      "definition" : "A provider trained and educated in the applied science of medically prescribed therapeutic exercise, education and adapted physical activities designed to improve the quality of line and health of adults and children by developing physical fitness, increasing mobility and independence, and improving psychosocial behavior. The kinesiotherapist seeks a coach-player relationship in which he/she helps the patient/client reach the goal of becoming an independent, self-sustaining person. Kinesiotherapists, as compared with physical therapists, put more emphasis on geriatric care, reconditioning and fitness, and psychiatric care. A large percentage of kinesiotherapists practice in Veterans Administration hospitals.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13595"
        }
      ]
    },
    {
      "code" : "231H00000N",
      "display" : "Speech, Language and Hearing Service; Audiologist",
      "definition" : "(1) A specialist in evaluation, habilitation and rehabilitation of those whose communication disorders center in whole or in part in hearing function. Audiologists are autonomous professionals who identify, assess, and manage disorders of the auditory, balance and other neural systems. Audiologists provide audiological (aural) rehabilitation to children and adults across the entire age span. Audiologists select, fit and dispense amplification systems such as hearing aids and related devices. (2) An audiologist is a person qualified by a master's degree in audiology, licensed by the state, where applicable, and practicing within the scope of that license. Audiologists evaluate and treat patients with impaired hearing. They plan, direct and conduct rehabilitative programs with audiotry substitutional devises (hearing aids) and other therapy.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13635"
        }
      ],
      "concept" : [
        {
          "code" : "231HA2400N",
          "display" : "Speech, Language and Hearing Service; Audiologist; Assistive Technology Practitioner",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13636"
            }
          ]
        },
        {
          "code" : "231HA2500N",
          "display" : "Speech, Language and Hearing Service; Audiologist; Assistive Technology Supplier",
          "designation" : [
            {
              "language" : "en",
              "use" : {
                "system" : "http://snomed.info/sct",
                "code" : "900000000000013009"
              },
              "value" : "Audiologist"
            }
          ],
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13637"
            }
          ]
        }
      ]
    },
    {
      "code" : "2355A2700N",
      "display" : "Speech, Language and Hearing Service; Specialist/Technologist; Audiology Assistant",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13641"
        }
      ]
    },
    {
      "code" : "2355S0801N",
      "display" : "Speech, Language and Hearing Service; Specialist/Technologist; Speech-Language Assistant",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13642"
        }
      ]
    },
    {
      "code" : "235Z00000N",
      "display" : "Speech, Language and Hearing Service; Speech-Language Pathologist",
      "definition" : "A speech pathologist is a person qualified by a master's degree in speech-language pathology, and where applicable, licensed by the state and practicing within the scope of the license. Also, known as speech therapist, a speech pathologist evaluates patients with language and speech impairments or disorders, whether arising from physiological and neurological disturbances, defective articulation or foreign dialects, and conducts remedial programs designed to restore or improve their communication efficacy. Speech pathologists assess and treat persons with speech, language, voice, and fluency disorders.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13643"
        }
      ]
    },
    {
      "code" : "237600000N",
      "display" : "Speech, Language and Hearing Service; Audiologist-Hearing Aid Fitter",
      "definition" : "An audiologist/hearing aid fitter is the professional who specializes in evaluating and treating people with hearing loss, conducts a wide variety of tests to determine the exact nature of an individual's hearing problem, presents a variety of treatment options to patients, dispenses and fits hearing aids, administers tests of balance to evaluate dizziness and provides hearing rehabilitation training. This classification should be used where individuals are licensed as \"audiologist-hearing aid fitters\" as opposed to states that license individuals as \"audiologists\".",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13638"
        }
      ]
    },
    {
      "code" : "237700000N",
      "display" : "Speech, Language and Hearing Service; Hearing Instrument Specialist",
      "definition" : "Individuals who test hearing for the selection, adaptation, fitting, adjusting, servicing, and sale of hearing aids. Hearing Instrument Specialist is a designation provided individuals who qualify by the National Hearing Aid Society.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13639"
        }
      ]
    },
    {
      "code" : "246QB0000N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Pathology; Blood Banking",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13689"
        }
      ]
    },
    {
      "code" : "246QC1000N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Pathology; Chemistry",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13690"
        }
      ]
    },
    {
      "code" : "246QC2700N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Pathology; Cytotechnology",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13691"
        }
      ]
    },
    {
      "code" : "246QH0000N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Pathology; Hematology",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13693"
        }
      ]
    },
    {
      "code" : "246QH0401N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Pathology; Hemapheresis Practitioner",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13692"
        }
      ]
    },
    {
      "code" : "246QH0600N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Pathology; Histology",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13694"
        }
      ]
    },
    {
      "code" : "246QI0000N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Pathology; Immunology",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13695"
        }
      ]
    },
    {
      "code" : "246QL0900N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Pathology; Laboratory Management",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13696"
        }
      ]
    },
    {
      "code" : "246QL0901N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Pathology; Laboratory Management, Diplomate",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13697"
        }
      ]
    },
    {
      "code" : "246QM0706N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Pathology; Medical Technologist",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13698"
        }
      ]
    },
    {
      "code" : "246QM0900N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Pathology; Microbiology",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13699"
        }
      ]
    },
    {
      "code" : "246RH0600N",
      "display" : "Technologists, Technicians & Other; Technician, Pathology; Histology",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13712"
        }
      ]
    },
    {
      "code" : "246RM2200N",
      "display" : "Technologists, Technicians & Other; Technician, Pathology; Medical Laboratory",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13713"
        }
      ]
    },
    {
      "code" : "246RP1900N",
      "display" : "Technologists, Technicians & Other; Technician, Pathology; Phlebotomy",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13714"
        }
      ]
    },
    {
      "code" : "246VC0100N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Cardiology; Cardiology",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13661"
        }
      ]
    },
    {
      "code" : "246VC2400N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Cardiology; Cardiopulmonary-Cardiovascular",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13662"
        }
      ]
    },
    {
      "code" : "246VC2901N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Cardiology; Cardiovascular: Invasive Technology",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13663"
        }
      ]
    },
    {
      "code" : "246VC2902N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Cardiology; Cardiovascular: Noninvasive Technology",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13664"
        }
      ]
    },
    {
      "code" : "246VC2903N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Cardiology; Cardiovascular: Vascular Technology",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13665"
        }
      ]
    },
    {
      "code" : "246VP3600N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Cardiology; Perfusionist",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13666"
        }
      ]
    },
    {
      "code" : "246VS1301N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Cardiology; Sonography, Diagnostic Cardiac",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13667"
        }
      ]
    },
    {
      "code" : "246VV0100N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Cardiology; Vascular",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13668"
        }
      ]
    },
    {
      "code" : "246WC3000N",
      "display" : "Technologists, Technicians & Other; Technician, Cardiology; Cardiographic",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13701"
        }
      ]
    },
    {
      "code" : "246WE0400N",
      "display" : "Technologists, Technicians & Other; Technician, Cardiology; ECG",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13702"
        }
      ]
    },
    {
      "code" : "246YC3301N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Health Information; Coding Specialist, Hospital Based",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13670"
        }
      ]
    },
    {
      "code" : "246YC3302N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Health Information; Coding Specialist, Physician Office Based",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13671"
        }
      ]
    },
    {
      "code" : "246YR1600N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Health Information; Registered Record Administrator",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13672"
        }
      ]
    },
    {
      "code" : "246ZA2600N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Other; Art, Medical",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13674"
        }
      ]
    },
    {
      "code" : "246ZB0301N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Other; Biomedical Engineering",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13676"
        }
      ]
    },
    {
      "code" : "246ZB0302N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Other; Biomedical Photographer",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13677"
        }
      ]
    },
    {
      "code" : "246ZB0500N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Other; Biochemist",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13675"
        }
      ]
    },
    {
      "code" : "246ZB0600N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Other; Biostatistician",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13678"
        }
      ]
    },
    {
      "code" : "246ZE0500N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Other; EEG",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13679"
        }
      ]
    },
    {
      "code" : "246ZE0600N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Other; Electroneurodiagnostic",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13680"
        }
      ]
    },
    {
      "code" : "246ZF0200N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Other; Forensic",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13681"
        }
      ]
    },
    {
      "code" : "246ZG0701N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Other; Graphics Methods",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13683"
        }
      ]
    },
    {
      "code" : "246ZG1000N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Other; Geneticist, Medical (PhD)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13682"
        }
      ]
    },
    {
      "code" : "246ZI1000N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Other; Illustration, Medical",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13684"
        }
      ]
    },
    {
      "code" : "246ZN0300N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Other; Nephrology",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13685"
        }
      ]
    },
    {
      "code" : "246ZS0400N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Other; Surgical",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13686"
        }
      ]
    },
    {
      "code" : "246ZV0500N",
      "display" : "Technologists, Technicians & Other; Specialist/Technologist, Other; Virology",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13687"
        }
      ]
    },
    {
      "code" : "2470A2800N",
      "display" : "Technologists, Technicians & Other; Technician, Health Information; Assistant Record Technician",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13704"
        }
      ]
    },
    {
      "code" : "2471C1101N",
      "display" : "Technologists, Technicians & Other; Radiologic Technologist; Cardiovascular-Interventional Technology: Radiography",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13646"
        }
      ]
    },
    {
      "code" : "2471C3401N",
      "display" : "Technologists, Technicians & Other; Radiologic Technologist; Computed Tomography: Radiation Therapy",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13647"
        }
      ]
    },
    {
      "code" : "2471C3402N",
      "display" : "Technologists, Technicians & Other; Radiologic Technologist; Computed Tomography: Radiography",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13648"
        }
      ]
    },
    {
      "code" : "2471D1300N",
      "display" : "Technologists, Technicians & Other; Radiologic Technologist; Dosimetrist, Medical",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13649"
        }
      ]
    },
    {
      "code" : "2471M1201N",
      "display" : "Technologists, Technicians & Other; Radiologic Technologist; Magnetic Resonance Imaging (MRI): Radiation Therapy",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13650"
        }
      ]
    },
    {
      "code" : "2471M1202N",
      "display" : "Technologists, Technicians & Other; Radiologic Technologist; Magnetic Resonance Imaging (MRI): Radiographer",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13651"
        }
      ]
    },
    {
      "code" : "2471M2300N",
      "display" : "Technologists, Technicians & Other; Radiologic Technologist; Mammography: Radiography",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13652"
        }
      ]
    },
    {
      "code" : "2471N0900N",
      "display" : "Technologists, Technicians & Other; Radiologic Technologist; Nuclear Medicine Technology",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13653"
        }
      ]
    },
    {
      "code" : "2471Q0001N",
      "display" : "Technologists, Technicians & Other; Radiologic Technologist; Quality Management: Radiation Therapy",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13654"
        }
      ]
    },
    {
      "code" : "2471Q0002N",
      "display" : "Technologists, Technicians & Other; Radiologic Technologist; Quality Management: Radiographer",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13655"
        }
      ]
    },
    {
      "code" : "2471R0002N",
      "display" : "Technologists, Technicians & Other; Radiologic Technologist; Radiation Therapy",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13657"
        }
      ]
    },
    {
      "code" : "2471R0003N",
      "display" : "Technologists, Technicians & Other; Radiologic Technologist; Radiation Physicist",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13656"
        }
      ]
    },
    {
      "code" : "2471R1500N",
      "display" : "Technologists, Technicians & Other; Radiologic Technologist; Radiographer",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13658"
        }
      ]
    },
    {
      "code" : "2471S1302N",
      "display" : "Technologists, Technicians & Other; Radiologic Technologist; Sonography, Diagnostic Medical",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13659"
        }
      ]
    },
    {
      "code" : "2472B0301N",
      "display" : "Technologists, Technicians & Other; Technician, Other; Biomedical Engineering",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13706"
        }
      ]
    },
    {
      "code" : "2472D0500N",
      "display" : "Technologists, Technicians & Other; Technician, Other; Darkroom",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13707"
        }
      ]
    },
    {
      "code" : "2472E0500N",
      "display" : "Technologists, Technicians & Other; Technician, Other; EEG",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13708"
        }
      ]
    },
    {
      "code" : "2472R0900N",
      "display" : "Technologists, Technicians & Other; Technician, Other; Renal Dialysis",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13709"
        }
      ]
    },
    {
      "code" : "2472V0600N",
      "display" : "Technologists, Technicians & Other; Technician, Other; Veterinary",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13710"
        }
      ]
    },
    {
      "code" : "2514C0400N",
      "display" : "Agencies; Agency; Case Management",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13718"
        }
      ]
    },
    {
      "code" : "2514H0200N",
      "display" : "Agencies; Agency; Home Health",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13719"
        }
      ]
    },
    {
      "code" : "2514H0201N",
      "display" : "Agencies; Agency; Home Infusion",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13720"
        }
      ]
    },
    {
      "code" : "2514H0300N",
      "display" : "Agencies; Agency; Hospice Care, Community Based",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13721"
        }
      ]
    },
    {
      "code" : "2514N1101N",
      "display" : "Agencies; Agency; Nursing Care",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13722"
        }
      ]
    },
    {
      "code" : "2514P0906N",
      "display" : "Agencies; Agency; Public Health or Welfare",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13723"
        }
      ]
    },
    {
      "code" : "2514V0001N",
      "display" : "Agencies; Agency; Voluntary or Charitable",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13724"
        }
      ]
    },
    {
      "code" : "261QA0600N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Adult Day Care",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13727"
        }
      ]
    },
    {
      "code" : "261QA1903N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Ambulatory Surgical",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13728"
        }
      ]
    },
    {
      "code" : "261QB0400N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Birthing",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13729"
        }
      ]
    },
    {
      "code" : "261QC1500N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Community Health",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13730"
        }
      ]
    },
    {
      "code" : "261QC1800N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Corporate Health",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13731"
        }
      ]
    },
    {
      "code" : "261QD0000N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Dental",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13732"
        }
      ]
    },
    {
      "code" : "261QE0002N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Emergency Care",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13733"
        }
      ]
    },
    {
      "code" : "261QE0700N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; End-Stage Renal Disease (ESRD) Treatment",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13734"
        }
      ]
    },
    {
      "code" : "261QE0800N",
      "display" : "Endoscopy lab",
      "definition" : "(X12N 261QD0000N)",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "Ambulatory Health Care Facilities; Clinic/Center; Endoscopy"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10907"
        }
      ]
    },
    {
      "code" : "261QF0400N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Federally Qualified Health Center (FQHC)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13737"
        }
      ]
    },
    {
      "code" : "261QH0100N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Health",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13738"
        }
      ]
    },
    {
      "code" : "261QI0500N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Infusion Therapy",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13739"
        }
      ]
    },
    {
      "code" : "261QL0400N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Lithotripsy",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13740"
        }
      ]
    },
    {
      "code" : "261QM0801N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Mental Health (Including Community Mental Health Center)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13742"
        }
      ]
    },
    {
      "code" : "261QM1000N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Migrant Health",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13743"
        }
      ]
    },
    {
      "code" : "261QM1100N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Military",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13744"
        }
      ]
    },
    {
      "code" : "261QM1101N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Military Expanded Services",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13745"
        }
      ]
    },
    {
      "code" : "261QM1102N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Military Operational Component",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13746"
        }
      ]
    },
    {
      "code" : "261QM1200N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Magnetic Resonance Imaging (MRI)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13741"
        }
      ]
    },
    {
      "code" : "261QM1300N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Multi-Specialty",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13747"
        }
      ]
    },
    {
      "code" : "261QP0904N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Public Health, Federal",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13759"
        }
      ]
    },
    {
      "code" : "261QP0905N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Public Health, State or Local",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13760"
        }
      ]
    },
    {
      "code" : "261QP1100N",
      "display" : "Podiatry clinic",
      "definition" : "(X12N 261QP1100N)",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "Ambulatory Health Care Facilities; Clinic/Center; Podiatric"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10962"
        }
      ]
    },
    {
      "code" : "261QP2000N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Physical Therapy",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13753"
        }
      ]
    },
    {
      "code" : "261QP2300N",
      "display" : "Primary care clinic",
      "definition" : "(X12N 261QP2300N)",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "Ambulatory Health Care Facilities; Clinic/Center; Primary Care"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10952"
        }
      ]
    },
    {
      "code" : "261QP2400N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Prison Health",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13758"
        }
      ]
    },
    {
      "code" : "261QP3300N",
      "display" : "Pain clinic",
      "definition" : "(X12N 261QP3300N)",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "Ambulatory Health Care Facilities; Clinic/Center; Pain"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10951"
        }
      ]
    },
    {
      "code" : "261QR0200N",
      "display" : "Radiology diagnostics or therapeutics unit",
      "definition" : "A practice setting where radiology services (diagnostic or therapeutic) are provided (X12N 261QR0200N)",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "Ambulatory Health Care Facilities; Clinic/Center; Radiology"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10908"
        }
      ],
      "concept" : [
        {
          "code" : "261QX0203N",
          "display" : "Radiation oncology unit",
          "definition" : "(X12N 261QX0203N)",
          "designation" : [
            {
              "language" : "en",
              "use" : {
                "system" : "http://snomed.info/sct",
                "code" : "900000000000013009"
              },
              "value" : "Ambulatory Health Care Facilities; Clinic/Center; Oncology, Radiation"
            }
          ],
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "10909"
            }
          ]
        }
      ]
    },
    {
      "code" : "261QR0206N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Radiology: Mammography",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13763"
        }
      ]
    },
    {
      "code" : "261QR0207N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Radiology: Mobile Mammography",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13765"
        }
      ]
    },
    {
      "code" : "261QR0208N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Radiology: Mobile",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13764"
        }
      ]
    },
    {
      "code" : "261QR0400N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Rehabilitation",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13767"
        }
      ]
    },
    {
      "code" : "261QR0401N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Rehabilitation, Comprehensive Outpatient Rehabilitation Facility (CORF)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13768"
        }
      ]
    },
    {
      "code" : "261QR0404N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Rehabilitation: Cardiac Facilities",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "Cardiology clinic"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10590"
        }
      ]
    },
    {
      "code" : "261QR0405N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Rehabilitation, Substance Use Disorder",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13769"
        }
      ]
    },
    {
      "code" : "261QR0800N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Recovery Care",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13766"
        }
      ]
    },
    {
      "code" : "261QR1100N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Research",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13772"
        }
      ]
    },
    {
      "code" : "261QR1300N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Rural Health",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13773"
        }
      ]
    },
    {
      "code" : "261QS0112N",
      "display" : "Oral and maxillofacial surgery clinic",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "Ambulatory Health Care Facilities; Clinic/Center; Surgery, Oral/Maxillofacial"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10946"
        }
      ]
    },
    {
      "code" : "261QS0132N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Surgery, Ophthalmologic",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13776"
        }
      ]
    },
    {
      "code" : "261QS1000N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Student Health",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13775"
        }
      ]
    },
    {
      "code" : "261QS1200N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Sleep Disorder Diagnostic",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13774"
        }
      ]
    },
    {
      "code" : "261QU0200N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Urgent Care",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13779"
        }
      ]
    },
    {
      "code" : "261QV0200N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; VA",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13780"
        }
      ]
    },
    {
      "code" : "261QX0100N",
      "display" : "Ambulatory Health Care Facilities; Clinic/Center; Occupational Medicine",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13748"
        }
      ]
    },
    {
      "code" : "273R00000N",
      "display" : "Psychiatric hospital unit",
      "definition" : "(X12N 273R00000N)",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "Hospital Units; Psychiatric Unit"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10600"
        }
      ]
    },
    {
      "code" : "273Y00000N",
      "display" : "Rehabilitation hospital unit",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "Hospital Units; Rehabilitation Unit"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10601"
        }
      ]
    },
    {
      "code" : "275N00000N",
      "display" : "Hospital Units; Medicare Defined Swing Bed Unit",
      "definition" : "A unit of a hospital that has a Medicare provider agreement and has been granted approval from HCFA to provide post-hospital extended care services and be reimbursed as a swing-bed unit.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13783"
        }
      ]
    },
    {
      "code" : "276400000N",
      "display" : "Hospital Units; Rehabilitation, Substance Use Disorder Unit",
      "definition" : "A distinct part of a hospital that provides medically monitored, interdisciplinary addiction-focused treatment to patients/clients who have psychoactive substance use disorders (commonly referred to as alcohol and drug abuse or substance abuse).",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13788"
        }
      ]
    },
    {
      "code" : "281P00000N",
      "display" : "Chronic Care Facility",
      "definition" : "(1) A hospital including a physical plant and personnel that provides multidisciplinary diagnosis and treatment for diseases that have one or more of the following characteristics: is permanent; leaves residual disability; is caused by nonreversible pathological alteration; requires special training of the patient for rehabilitation; and/or may be expected to require a long period of supervision or care. In addition, patients require the safety, security, and shelter of these specialized inpatient or partial hospitalization settings. (2) A hospital that provides medical and skilled nursing services to patients with long-term illnesses who are not in an acute phase but who require an intensity of services not available in nursing homes",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "Hospitals; Chronic Disease Hospital"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13792"
        }
      ],
      "concept" : [
        {
          "code" : "281PC2000N",
          "display" : "Hospitals; Chronic Disease Hospital; Children",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13793"
            }
          ]
        }
      ]
    },
    {
      "code" : "282N00000N",
      "display" : "Hospitals; General Acute Care Hospital",
      "definition" : "(X12N 282N00000N)",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "General acute care hospital"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10603"
        }
      ],
      "concept" : [
        {
          "code" : "282NC2000N",
          "display" : "Hospitals; General Acute Care Hospital; Children",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13796"
            }
          ]
        },
        {
          "code" : "282NR1301N",
          "display" : "Hospitals; General Acute Care Hospital; Rural",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13797"
            }
          ]
        },
        {
          "code" : "282NW0100N",
          "display" : "Hospitals; General Acute Care Hospital; Women",
          "designation" : [
            {
              "language" : "en",
              "use" : {
                "system" : "http://snomed.info/sct",
                "code" : "900000000000013009"
              },
              "value" : "Women's Acute Care Hospital"
            }
          ],
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13798"
            }
          ],
          "concept" : [
            {
              "code" : "2865C1500N",
              "display" : "Hospitals; Military Hospital; Community Health",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "13800"
                }
              ]
            },
            {
              "code" : "2865M2000N",
              "display" : "Hospitals; Military Hospital; Medical Center",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "13801"
                }
              ]
            },
            {
              "code" : "2865X1600N",
              "display" : "Hospitals; Military Hospital; Operational Component Facility",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "13802"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "code" : "283Q00000N",
      "display" : "Hospitals; Psychiatric Hospital",
      "definition" : "An organization including a physical plant and personnel that provides multidisciplinary diagnostic and treatment mental health services to patients requiring the safety, security, and shelter of the inpatient or partial hospitalization settings.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13803"
        }
      ]
    },
    {
      "code" : "283X00000N",
      "display" : "Rehabilitation hospital",
      "definition" : "(X12N 283X00000N)",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "Hospitals; Rehabilitation Hospital"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10604"
        }
      ],
      "concept" : [
        {
          "code" : "283XC2000N",
          "display" : "Hospitals; Rehabilitation Hospital; Children",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13806"
            }
          ]
        }
      ]
    },
    {
      "code" : "284300000N",
      "display" : "Hospitals; Special Hospital",
      "definition" : "A designation by the AHA of a hospital whose primary function of the institution is to provide diagnostic and treatment services for patients who have specified medical conditions, both surgical and nonsurgical.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13807"
        }
      ]
    },
    {
      "code" : "287300000N",
      "display" : "Hospitals; Christian Science Sanitorium",
      "definition" : "A Christian Science sanitarium operated, or listed and certified, by The First Church of Christ, Scientist, Boston, Massachusetts, furnishing inpatient hospital care services.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13791"
        }
      ]
    },
    {
      "code" : "291U00000N",
      "display" : "Laboratories; Clinical Medical Laboratory",
      "definition" : "(1) A clinical laboratory is a facility for the biological, microbiological, serological, chemical, immunohematological, hematological, biophysical, cytological, pathological, or other examination of materials derived from the human body for the purpose of providing information for the diagnosis, prevention, or treatment of any disease or impairment of, human beings. These examinations also include procedures to determine, measure, or otherwise describe the presence or absence of various substances or organisms in the body. Facilities only collecting or preparing specimens (or both) or only serving as a mailing service and not performing testing are not considered clinical laboratories. (2) Any facility that examines materials from the human body for purposes of providing information for the diagnosis, prevention, or treatment of any disease or impairment of, or the assessment of, the health of human beings. Typical divisions of a clinical laboratory include hematology, cytology, bacteriology, histology, biochemistry, medical toxicology, and serology.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13809"
        }
      ]
    },
    {
      "code" : "292200000N",
      "display" : "Laboratories; Dental Laboratory",
      "definition" : "A commercial laboratory specializing in the construction of dental appliances that conform to a dentist's specifications including the construction of dentures (complete or partial), orthodontic appliances, bridgework, crowns, and inlays.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13810"
        }
      ]
    },
    {
      "code" : "293D00000N",
      "display" : "Laboratories; Physiological Laboratory",
      "definition" : "A laboratory that operates independently of a hospital and physician's office to furnish physiological diagnostic services (e.g. EEG's , EKG's, scans, etc.). Facilities offering ONLY physiological services are not certified as independent laboratories. If an independent laboratory offers physiological services IN ADDITION to clinical laboratory services, they are surveyed only for compliance with the clinical laboratory regulations because there are no health and safety regulations for physiological services.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13811"
        }
      ]
    },
    {
      "code" : "302F00000N",
      "display" : "Managed Care Organizations; Exclusive Provider Organization",
      "definition" : "(1) An EPO is a form of PPO, in which patients must visit a caregiver that is specified on its panel of providers (is a participating provider). If a visit to an outside(not participating) provider is made the EPO offers very limited or no coverage for the medical service; (2) While similar to a PPO in that an EPO allows patients to go outside the network for care, if they do so in an EPO, they are required to pay the entire cost of care. An EPO differs from an HMO in that EPO physicians do not receive capitation but instead are reimbursed only for actual services provided; (3) An organization identical to a preferred provider organization except that persons enrolled in the plan are eligible to receive benefits only when they use the services of the contracting providers. No benefits are available when non-contracting providers are used, except in certain emergency situations.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13813"
        }
      ]
    },
    {
      "code" : "302R00000N",
      "display" : "Managed Care Organizations; Health Maintenance Organization",
      "definition" : "(1) A form of health insurance in which its members prepay a premium for the HMO's health services which generally include inpatient and ambulatory care. For the patient, an HMO means reduced out-of-pocket costs (i.e. no deductible), no paperwork (i.e. insurance forms), and only a small copayment for each office visit to cover the paperwork handled by the HMO; (2) A organization of health care personnel and facilities that provides a comprehensive range of health services to an enrolled population for a fixed sum of money paid in advance for a specified period of time. These health services include a wide variety of medical treatments and consults, inpatient and outpatient hospitalization, home health service, ambulance service, and sometimes dental and pharmacy services. The HMO may be organized as a group model, an individual practice association (IPA), a network model or a staff model.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13814"
        }
      ]
    },
    {
      "code" : "305R00000N",
      "display" : "Managed Care Organizations; Preferred Provider Organization",
      "definition" : "A group of physicians and/or hospitals who contract with an employer to provide services to their employees. In a PPO, the patient may got to the physician of his/her choice, even if that physician does not participate in the PPO, but the patient receives care at a lower benefit level.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13816"
        }
      ]
    },
    {
      "code" : "305S00000N",
      "display" : "Managed Care Organizations; Point of Service",
      "definition" : "This product may also be called an open-ended HMO and offers a transition product incorporating features of both HMOs and PPOs. Beneficiaries are enrolled in an HMO but have the option to go outside the networks for an additional cost.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13815"
        }
      ]
    },
    {
      "code" : "311500000N",
      "display" : "Nursing & Custodial Care Facilities; Alzheimer Center (Dementia Center)",
      "definition" : "A freestanding facility or special care unit of a long term care facility focusing on patient care of individuals diagnosed with dementia or Alzheimer's Disease or their related diseases. Six elements of the facility/unit set it apart from other (the rest of the) facilities(y): (1) Admission of residents with dementia (including those with Alzheimer's disease); (2) Staff who are specially selected, trained, and supervised; (3) Activities that are specifically designed for the cognitively impaired; (4) A marketing of a special care unit in brochures; (5) A high level of family involvement; and (6) A physical environment designed to keep residents safe and segregated from other populations.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13819"
        }
      ]
    },
    {
      "code" : "311Z00000N",
      "display" : "Nursing & Custodial Care Facilities; Custodial Care Facility",
      "definition" : "A facility providing care that serves to assist an individual in the activities of daily living, such as assistance in walking, getting in and out of bed, bathing, dressing, feeding, and using the toilet, preparation of special diets, and supervision of medication that usually can be self-administered. Custodial care essentially is personal care that does not require the continuing attention of trained medical or paramedical personnel.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13821"
        }
      ]
    },
    {
      "code" : "313M00000N",
      "display" : "Nursing & Custodial Care Facilities; Nursing Facility/Intermediate Care Facility",
      "definition" : "An institution (or a distinct part of an institution) which- (1) is primarily engaged in providing to residents- (A) skilled nursing care and related services for residents who require medical or nursing care, (B) rehabilitation services for the rehabilitation of injured, disabled, or sick persons, or, on a regular basis, health-related care and services to individuals who because of their mental or physical condition require care and services (above the level of room and board) which can be made available to them only through institutional facilities, and is not primarily for the care and treatment of mental diseases; (2) has in effect a transfer agreement with one or more hospitals.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13824"
        }
      ]
    },
    {
      "code" : "314000000N",
      "display" : "Skilled nursing facility",
      "definition" : "(X12N 314000000N)",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "Nursing & Custodial Care Facilities; Skilled Nursing Facility"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10606"
        }
      ]
    },
    {
      "code" : "315D00000N",
      "display" : "Nursing & Custodial Care Facilities; Hospice, Inpatient",
      "definition" : "A provider organization, or distinct part of the organization, which renders an interdisciplinary program providing palliative care, chiefly medical relief of pain and supporting services, which addresses the emotional, social, financial, and legal needs of terminally ill patients and their families where an institutional care environment is required for the patient.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13822"
        }
      ]
    },
    {
      "code" : "315P00000N",
      "display" : "Nursing & Custodial Care Facilities; Intermediate Care Facility, Mentally Retarded",
      "definition" : "(1) A public institution for care of the mentally retarded or people with related conditions. (2) An institution giving active treatment to mentally retarded or developmentally disabled persons or persons with related conditions. The primary purpose of the institution is to provide health or rehabilitative services to such individuals.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13823"
        }
      ]
    },
    {
      "code" : "317400000N",
      "display" : "Nursing & Custodial Care Facilities; Christian Science Facility",
      "definition" : "A Christian Science sanitarium operated, or listed and certified, by The First Church of Christ, Scientist, Boston, Massachusetts, furnishing extended care services.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13820"
        }
      ]
    },
    {
      "code" : "322D00000N",
      "display" : "Residential Treatment Facilities; Residential Treatment Facility for Emotionally Disturbed Children",
      "definition" : "A provider facility or distinct part of the organization which renders an interdisciplinary program of mental health treatment to individuals under 21 years of age who have persistent dysfunction in major life areas. The dysfunction is of an extent and pervasiveness that requires a protected and highly structured therapeutic environment. These organizations, or distinct part of organizations, exclude those that provide acute psychiatric care, partial hospitalization, group living, therapeutic schooling, primary diagnosis substance abuse disorder treatment, or primary diagnosis mental retardation or developmental disability treatment.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13830"
        }
      ]
    },
    {
      "code" : "323P00000N",
      "display" : "Residential Treatment Facilities; Psychiatric Residential Treatment Facility",
      "definition" : "A residential treatment center (RTC) is a facility or distinct part of a facility that providers, to children and adolescents, a total, twenty-four hour, therapeutically planned group living and learning situation where distinct and individualized psychotherapeutic interventions can take place. residential treatment is a specific level of care to e differentiated from acute, intermediate, and long-term hospital care, when the least restrictive environment is maintained to allow for normalization of the patient's surroundings. The RTC must be both physically and programmatically distinct if it is a part or subunit of a larger treatment program. A RTC is organized and professionally staffed to provide residential treatment of mental disorders to children and adolescents who have sufficient intellectual potential to respond to active treatment (that is , for whom it can reasonably be assumed that treatment of the mental disorder will result in an improved ability to function outside the RTC) for whom outpatient treatment, partial hospitalization or protected and structured environment is medically or psychologically necessary.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13829"
        }
      ]
    },
    {
      "code" : "324500000N",
      "display" : "Substance use rehabilitation facility",
      "definition" : "(X12N 324500000N)",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "system" : "http://snomed.info/sct",
            "code" : "900000000000013009"
          },
          "value" : "Residential Treatment Facilities; Substance Use Rehabilitation Facility"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10608"
        }
      ]
    },
    {
      "code" : "331L00000N",
      "display" : "Suppliers; Blood Bank",
      "definition" : "An institution (organization or distinct part thereof) that performs, or is responsible for the performance of, the collection, processing, storage and/or issuance of human blood and blood components, intended for transfusion. The institution may also collect, process, and/or distribute human tissue, including bone marrow and peripheral blood progenitor cells, intended for transplantation.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13834"
        }
      ]
    },
    {
      "code" : "332B00000N",
      "display" : "Suppliers; Durable Medical Equipment & Medical Supplies",
      "definition" : "A supplier of medical equipment such as respirators, wheelchairs, home dialysis systems, or monitoring systems, that are prescribed by a physician for a patient's use in the home and that are usable for an extended period of time.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13835"
        }
      ],
      "concept" : [
        {
          "code" : "332BC3200N",
          "display" : "Suppliers; Durable Medical Equipment & Medical Supplies; Customized Equipment",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13836"
            }
          ]
        },
        {
          "code" : "332BD1200N",
          "display" : "Suppliers; Durable Medical Equipment & Medical Supplies; Dialysis Equipment & Supplies",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13837"
            }
          ]
        },
        {
          "code" : "332BN1400N",
          "display" : "Suppliers; Durable Medical Equipment & Medical Supplies; Nursing Facility Supplies",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13838"
            }
          ]
        },
        {
          "code" : "332BP3500N",
          "display" : "Suppliers; Durable Medical Equipment & Medical Supplies; Parenteral & Enteral Nutrition",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13840"
            }
          ]
        },
        {
          "code" : "332BX2000N",
          "display" : "Suppliers; Durable Medical Equipment & Medical Supplies; Oxygen Equipment & Supplies",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13839"
            }
          ]
        }
      ]
    },
    {
      "code" : "332G00000N",
      "display" : "Suppliers; Eye Bank",
      "definition" : "An eye bank procures and distributes eyes for transplant, education and research. To promote patient safety, donated eyes and donor medial histories are evaluated based on strict Eye Bank Association of America Medical Standards.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13841"
        }
      ]
    },
    {
      "code" : "332H00000N",
      "display" : "Suppliers; Eyewear Supplier (Equipment, not the service)",
      "definition" : "An organization that provides spectacles, contact lenses, and other vision enhancement devices prescribed by an optometrist or ophthalmologist.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13842"
        }
      ]
    },
    {
      "code" : "332S00000N",
      "display" : "Suppliers; Hearing Aid Equipment",
      "definition" : "The manufacture and/or sale of electronic hearing aids, their component parts, and related products and services on a national basis.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13843"
        }
      ]
    },
    {
      "code" : "332U00000N",
      "display" : "Suppliers; Home Delivered Meals",
      "definition" : "Home-delivered meals are those services or activities designed to prepare and deliver one or more meals a day to an individual's residence in order to prevent institutionalization, malnutrition, and feelings of isolation. Component services or activities may include the cost of personnel, equipment, and food; assessment of nutritional and dietary needs; nutritional education and counseling; socialization services; and information and referral.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13844"
        }
      ]
    },
    {
      "code" : "333600000N",
      "display" : "Suppliers; Pharmacy",
      "definition" : "A facility used by pharmacists for the compounding and dispensing of medicinal preparations (drug store). A pharmacy is a facility whose primary function is to store, prepare and legally dispense prescription drugs through a licensed pharmacist. It meets any licensing or certification standards set forth by the jurisdiction where it is located.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13846"
        }
      ]
    },
    {
      "code" : "335E00000N",
      "display" : "Suppliers; Prosthetic/Orthotic Supplier",
      "definition" : "An organization which supplies or vends orthopedic appliances or apparatuses and artificial body parts used to support, align, prevent, or correct deformities or to replace or improve function of body parts.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13848"
        }
      ]
    },
    {
      "code" : "335U00000N",
      "display" : "Suppliers; Organ Procurement Organization",
      "definition" : "A federally designated organization that works with hospital personnel in retrieval of organs for transplantation. The federal government designates an OPO's service area and the hospitals with which an OPO is to establish working relationships.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13845"
        }
      ]
    },
    {
      "code" : "335V00000N",
      "display" : "Suppliers; Portable X-Ray Supplier",
      "definition" : "A supplier of diagnostic x-ray services furnished in a place or residence used as the patient's home or, in certain circumstances, in an institution, where the institution cannot bill for the services. Portable x-ray services include: (1) skeletal films involving arms and legs, pelvis, vertebral column, and skull; (2) chest films which do not involve the use of contrast media (except routine screening procedures and tests in connection with routine physical examinations); and (3) abdominal films which do not involve the use of contrast media. Procedures and examinations which are excluded from portable x-ray services include the following: (1) procedures involving fluoroscopy;(2) procedures involving the use of contrast media; (3) procedures requiring the administration of a substance to the patient or injection of a substance into the patient and/or special manipulation of the patient; (4) procedures which require special medical skill or knowledge possessed by a doctor of medicine or doctor of osteopathy or which require that medical judgment be exercised; (5) procedures requiring special technical competency and/or special equipment or materials; (6) routine screening procedures; and (7) procedures which are not of a diagnostic nature.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13847"
        }
      ]
    },
    {
      "code" : "3416A0800N",
      "display" : "Transportation Services; Ambulance; Air",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13851"
        }
      ]
    },
    {
      "code" : "3416L0300N",
      "display" : "Transportation Services; Ambulance; Land",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13852"
        }
      ]
    },
    {
      "code" : "3416S0300N",
      "display" : "Transportation Services; Ambulance; Sea",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13853"
        }
      ]
    },
    {
      "code" : "343900000N",
      "display" : "Transportation Services; Medical Transport (Van)",
      "definition" : "A land vehicle with a capacity to meet special height, clearance, access, and seating, for the conveyance of persons in non-emergency situations. The vehicle may or may not be required to meet local county or state regulations.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13854"
        }
      ]
    },
    {
      "code" : "344600000N",
      "display" : "Transportation Services; Taxi",
      "definition" : "A land commercial vehicle used for the transporting of persons in non-emergency situations. The vehicle meets local, county or state regulations set forth by the jurisdictions where it is located.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13855"
        }
      ]
    },
    {
      "code" : "353BL0002N",
      "display" : "Physicians (Other Roles); Physician/Osteopath; Laboratory Service Provider",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13580"
        }
      ]
    },
    {
      "code" : "353BS0900N",
      "display" : "Physicians (Other Roles); Physician/Osteopath; Supplier",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13581"
        }
      ]
    },
    {
      "code" : "363A00000N",
      "display" : "Physician Assistants & Advanced Practice Nursing Providers; Physician Assistant",
      "definition" : "A physician assistant is a person who has successfully completed an accredited education program for physician assistant, is licensed by the state and is practicing within the scope of that license. Physician assistants are formally trained to perform many of the routine, time-consuming tasks a physician can do. In some states, they may prescribe medications. They take medical histories, perform physical exams, order lab tests and x-rays, and give inoculations. Most states require that they work under the supervision of a physician.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13422"
        }
      ],
      "concept" : [
        {
          "code" : "363AM0700N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Physician Assistant; Medical",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13423"
            }
          ]
        },
        {
          "code" : "363AS0400N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Physician Assistant; Surgical",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13424"
            }
          ]
        }
      ]
    },
    {
      "code" : "363L00000N",
      "display" : "Physician Assistants & Advanced Practice Nursing Providers; Nurse Practitioner",
      "definition" : "(1)A registered nurse provider with a graduate degree in nursing prepared for advanced practice involving independent and interdependent decision making and direct accountability for clinical judgment across the health care continuum or in a certified specialty. (2) A registered nurse who has completed additional training beyond basic nursing education and who provides primary health care services in accordance with state nurse practice laws or statutes. Tasks performed by nurse practitioners vary with practice requirements mandated by geographic, political, economic, and social factors. Nurse practitioner specialists include, but are not limited to, family nurse practitioners, gerontological nurse practitioners, pediatric nurse practitioners, obstetric-gynecologic nurse practitioners, and school nurse practitioners.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13402"
        }
      ],
      "concept" : [
        {
          "code" : "363LA2100N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Nurse Practitioner; Acute Care",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13403"
            }
          ]
        },
        {
          "code" : "363LA2200N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Nurse Practitioner; Adult Health",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13404"
            }
          ]
        },
        {
          "code" : "363LC0200N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Nurse Practitioner; Critical Care Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13406"
            }
          ]
        },
        {
          "code" : "363LC1500N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Nurse Practitioner; Community Health",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13405"
            }
          ]
        },
        {
          "code" : "363LF0000N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Nurse Practitioner; Family",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13407"
            }
          ]
        },
        {
          "code" : "363LG0600N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Nurse Practitioner; Gerontology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13408"
            }
          ]
        },
        {
          "code" : "363LN0000N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Nurse Practitioner; Neonatal",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13409"
            }
          ]
        },
        {
          "code" : "363LN0005N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Nurse Practitioner; Neonatal: Critical Care",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13410"
            }
          ]
        },
        {
          "code" : "363LP0200N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Nurse Practitioner; Pediatrics",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13413"
            }
          ]
        },
        {
          "code" : "363LP0222N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Nurse Practitioner; Pediatrics: Critical Care",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13415"
            }
          ]
        },
        {
          "code" : "363LP0223N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Nurse Practitioner; Pediatrics: Acute Care",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13414"
            }
          ]
        },
        {
          "code" : "363LP0808N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Nurse Practitioner; Psychiatric/Mental Health",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13419"
            }
          ]
        },
        {
          "code" : "363LP1700N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Nurse Practitioner; Perinatal",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13416"
            }
          ]
        },
        {
          "code" : "363LP2300N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Nurse Practitioner; Primary Care",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13417"
            }
          ]
        },
        {
          "code" : "363LS0200N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Nurse Practitioner; School",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13420"
            }
          ]
        },
        {
          "code" : "363LW0102N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Nurse Practitioner; Women's Health",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13421"
            }
          ]
        },
        {
          "code" : "363LX0001N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Nurse Practitioner; Obstetrics & Gynecology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13411"
            }
          ]
        },
        {
          "code" : "363LX0106N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Nurse Practitioner; Occupational Health",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13412"
            }
          ]
        }
      ]
    },
    {
      "code" : "364S00000N",
      "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist",
      "definition" : "A registered nurse who, through a graduate degree program in nursing, or through a formal post-basic education program or continuing education courses and clinical experience, is expert in a specialty area of nursing practice within one or more of the components of direct patient/client care, consultation, education, research and administration.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13364"
        }
      ],
      "concept" : [
        {
          "code" : "364SA2100N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Acute Care",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13365"
            }
          ]
        },
        {
          "code" : "364SA2200N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Adult Health",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13366"
            }
          ]
        },
        {
          "code" : "364SC0200N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Critical Care Medicine",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13369"
            }
          ]
        },
        {
          "code" : "364SC1501N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Community Health/Public Health",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13368"
            }
          ]
        },
        {
          "code" : "364SC2300N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Chronic Care",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13367"
            }
          ]
        },
        {
          "code" : "364SE0003N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Emergency",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13370"
            }
          ]
        },
        {
          "code" : "364SE1400N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Ethics",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13371"
            }
          ]
        },
        {
          "code" : "364SF0001N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Family Health",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13372"
            }
          ]
        },
        {
          "code" : "364SG0600N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Gerontology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13373"
            }
          ]
        },
        {
          "code" : "364SH0200N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Home Health",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13375"
            }
          ]
        },
        {
          "code" : "364SH1100N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Holistic",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13374"
            }
          ]
        },
        {
          "code" : "364SI0800N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Informatics",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13376"
            }
          ]
        },
        {
          "code" : "364SL0600N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Long-Term Care",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13377"
            }
          ]
        },
        {
          "code" : "364SM0705N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Medical-Surgical",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13378"
            }
          ]
        },
        {
          "code" : "364SN0000N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Neonatal",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13379"
            }
          ]
        },
        {
          "code" : "364SN0004N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Neonatal, High-Risk",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13380"
            }
          ]
        },
        {
          "code" : "364SN0800N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Neuroscience",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13381"
            }
          ]
        },
        {
          "code" : "364SP0200N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Pediatrics",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13385"
            }
          ]
        },
        {
          "code" : "364SP0807N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Psychiatric/Mental Health, Child & Adolescent",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13390"
            }
          ]
        },
        {
          "code" : "364SP0808N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Psychiatric/Mental Health",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13388"
            }
          ]
        },
        {
          "code" : "364SP0809N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Psychiatric/Mental Health, Adult",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13389"
            }
          ]
        },
        {
          "code" : "364SP0810N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Psychiatric/Mental Health, Child & Family",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13391"
            }
          ]
        },
        {
          "code" : "364SP0811N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Psychiatric/Mental Health, Chronically Ill",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13392"
            }
          ]
        },
        {
          "code" : "364SP0812N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Psychiatric/Mental Health, Community",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13393"
            }
          ]
        },
        {
          "code" : "364SP0813N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Psychiatric/Mental Health, Geropsychiatric",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13394"
            }
          ]
        },
        {
          "code" : "364SP1700N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Perinatal",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13386"
            }
          ]
        },
        {
          "code" : "364SP2800N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Perioperative",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13387"
            }
          ]
        },
        {
          "code" : "364SR0400N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Rehabilitation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13395"
            }
          ]
        },
        {
          "code" : "364SR1300N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Rural Health",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13396"
            }
          ]
        },
        {
          "code" : "364SS0200N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; School",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13397"
            }
          ]
        },
        {
          "code" : "364ST0500N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Transplantation",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13398"
            }
          ]
        },
        {
          "code" : "364SW0102N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Women's Health",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13399"
            }
          ]
        },
        {
          "code" : "364SX0106N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Occupational Health",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13382"
            }
          ]
        },
        {
          "code" : "364SX0200N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Oncology",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13383"
            }
          ]
        },
        {
          "code" : "364SX0204N",
          "display" : "Physician Assistants & Advanced Practice Nursing Providers; Clinical Nurse Specialist; Oncology, Pediatrics",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "13384"
            }
          ]
        }
      ]
    },
    {
      "code" : "366B00000N",
      "display" : "Physician Assistants & Advanced Practice Nursing Providers; Midwife, Certified",
      "definition" : "A provider educated in the independent management of women's health and focusing particularly on pregnancy, childbirth, the post-partum period, care of the newborn, family planning and gynecological needs of women and primary care of women. Certification requires education at the post-secondary level in midwifery and health services.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13400"
        }
      ]
    },
    {
      "code" : "367500000N",
      "display" : "Physician Assistants & Advanced Practice Nursing Providers; Nurse Anesthetist, Certified Registered",
      "definition" : "(1)A licensed registered nurse with advanced specialty education in anesthesia who, in collaboration with appropriate health care professionals, provides preoperative, intraoperative, and postoperative care to patients and assists in management and resuscitation of critical patients in intensive care, coronary care, and emergency situations. Nurse anesthetists are certified following successful completion of credentials and state licensure review and a national examination directed by the Council on Certification of Nurse Anesthetists. (2) A registered nurse who is qualified by special training to administer anesthesia in collaboration with a physician or dentist and who can assist in the care of patients who are in critical condition.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13401"
        }
      ]
    },
    {
      "code" : "374700000N",
      "display" : "Nursing Service Related Providers",
      "definition" : "(1) A person with specialized training in a narrow field of expertise whose occupation requires training and is skilled in specific technical processes and procedures. (2) An individual having special skill or practical knowledge in an area, such as operation and maintenance of equipment or performance of laboratory procedures involving biochemical analyses. Special technical qualifications are normally required, though an increasing number or technicians also possess university degrees in science, and occasionally doctorate degrees. The distinction between technician and technologist in the health care field is not always clear.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13134"
        }
      ]
    },
    {
      "code" : "3747P1801N",
      "display" : "Nursing Service Related Providers; Technician; Personal Care Attendent",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13135"
        }
      ]
    },
    {
      "code" : "374T00000N",
      "display" : "Nursing Service Related Providers; Christian Science Practitioner/Nurse",
      "definition" : "Providers who are trained and educated to perform and administer services related to health promotion, disease prevention, acute and chronic care, spiritual guidance and comfort for healing and health, restoration of health and health maintenance across the life span.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13290"
        }
      ]
    },
    {
      "code" : "374U00000N",
      "display" : "Nursing Service Related Providers; Technician; Home Health Aide",
      "definition" : "A person trained to assist public health nurses, home health nurses, and other health professionals in the bedside care of patients in their homes.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13291"
        }
      ]
    },
    {
      "code" : "376G00000N",
      "display" : "Nursing Service Related Providers; Nursing Home Administrator",
      "definition" : "An individual, often licensed by the state, who is responsible for the management of a nursing home.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13133"
        }
      ]
    },
    {
      "code" : "376J00000N",
      "display" : "Nursing Service Related Providers; Homemaker",
      "definition" : "A person who, under the supervision of a home health or welfare agency, assists elderly, ill, and disabled persons by providing services intended to preserve independent living and normal family life; frequently, household chores such as cooking and cleaning.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13292"
        }
      ]
    },
    {
      "code" : "376K00000N",
      "display" : "Nursing Service Related Providers; Nurse's Aide",
      "definition" : "(1) An unlicensed individual who is trained to function in an assistive role to the licensed nurse in the provision of patient/client activities as delegated by the nurse; (2) An individual trained (either on-the-job or through a formal course generally of less than one year) and experienced in performing patient or client-care nursing tasks that do not require the skills of a specialist, technician, or professional. Examples of tasks performed by nurses aides include changing clothes, diapers, and beds; assisting patients to perform exercises or personal hygiene tasks, and supporting communication or social interaction. Specific education and credentials are not required for this work.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "13293"
        }
      ]
    }
  ]
}

```
