# EntityNameUse - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EntityNameUse**

## CodeSystem: EntityNameUse 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-EntityNameUse | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:EntityNameUse |
| *Other Identifiers:*OID:2.16.840.1.113883.5.45 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
**** MISSING DESCRIPTION **** 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AddressRepresentationUse](ValueSet-v3-AddressRepresentationUse.md)
* [EntityNameUse](ValueSet-v3-EntityNameUse.md)
* [HL7SearchUse](ValueSet-v3-HL7SearchUse.md)
* [NameLegalUse](ValueSet-v3-NameLegalUse.md)
* [OrganizationNameUse](ValueSet-v3-OrganizationNameUse.md)
* [PersonNameUse](ValueSet-v3-PersonNameUse.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-EntityNameUse",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-EntityNameUse",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.45"
    }
  ],
  "version" : "3.0.0",
  "name" : "EntityNameUse",
  "title" : "EntityNameUse",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "**** MISSING DESCRIPTION ****",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Specializes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Generalizes"
        }
      ],
      "code" : "Specializes",
      "description" : "The child code is a more narrow version of the concept represented by the parent code.  I.e. Every child concept is also a valid parent concept.  Used to allow determination of subsumption.  Must be transitive, irreflexive, antisymmetric.",
      "type" : "Coding"
    },
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Generalizes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Specializes"
        }
      ],
      "code" : "Generalizes",
      "description" : "Inverse of Specializes.  Only included as a derived relationship.",
      "type" : "Coding"
    },
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state.  Normally is not populated unless the state is retired..",
      "type" : "code"
    },
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Indicates that the code is abstract - only intended to be used as a selector for other concepts",
      "type" : "boolean"
    }
  ],
  "concept" : [
    {
      "code" : "_NameRepresentationUse",
      "display" : "NameRepresentationUse",
      "definition" : "Identifies the different representations of a name. The representation may affect how the name is used. (E.g. use of Ideographic for formal communications.)",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21077"
        }
      ],
      "concept" : [
        {
          "code" : "ABC",
          "display" : "Alphabetic",
          "definition" : "Alphabetic transcription of name (Japanese: romaji)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15917"
            }
          ]
        },
        {
          "code" : "IDE",
          "display" : "Ideographic",
          "definition" : "Ideographic representation of name (e.g., Japanese kanji, Chinese characters)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15919"
            }
          ]
        },
        {
          "code" : "SYL",
          "display" : "Syllabic",
          "definition" : "Syllabic transcription of name (e.g., Japanese kana, Korean hangul)",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "15918"
            }
          ]
        }
      ]
    },
    {
      "code" : "ASGN",
      "display" : "assigned",
      "definition" : "A name assigned to a person. Reasons some organizations assign alternate names may include not knowing the person's name, or to maintain anonymity. Some, but not necessarily all, of the name types that people call \"alias\" may fit into this category.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21358"
        }
      ]
    },
    {
      "code" : "C",
      "display" : "License",
      "definition" : "As recorded on a license, record, certificate, etc. (only if different from legal name)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10177"
        }
      ]
    },
    {
      "code" : "I",
      "display" : "Indigenous/Tribal",
      "definition" : "e.g. Chief Red Cloud",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10179"
        }
      ]
    },
    {
      "code" : "L",
      "display" : "Legal",
      "definition" : "Known as/conventional/the one you use",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10176"
        }
      ],
      "concept" : [
        {
          "code" : "OR",
          "display" : "official registry",
          "definition" : "**Definition:**The formal name as registered in an official (government) registry, but which name might not be commonly used. Particularly used in countries with a law system based on Napoleonic law.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21637"
            }
          ]
        }
      ]
    },
    {
      "code" : "P",
      "display" : "pseudonym",
      "definition" : "A self asserted name that the person is using or has used.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21321"
        }
      ],
      "concept" : [
        {
          "code" : "A",
          "display" : "Artist/Stage",
          "definition" : "Includes writer's pseudonym, stage name, etc",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "10178"
            }
          ]
        }
      ]
    },
    {
      "code" : "R",
      "display" : "Religious",
      "definition" : "e.g. Sister Mary Francis, Brother John",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "10180"
        }
      ]
    },
    {
      "code" : "SRCH",
      "display" : "search",
      "definition" : "A name intended for use in searching or matching.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21363"
        }
      ],
      "concept" : [
        {
          "code" : "PHON",
          "display" : "phonetic",
          "definition" : "A name spelled phonetically.\r\n\r\nThere are a variety of phonetic spelling algorithms. This code value does not distinguish between these.*Discussion:*",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21364"
            }
          ]
        },
        {
          "code" : "SNDX",
          "display" : "Soundex",
          "definition" : "A name spelled according to the SoundEx algorithm.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21365"
            }
          ]
        }
      ]
    },
    {
      "code" : "_EntityNameSearchUse",
      "display" : "EntityNameSearchUse",
      "definition" : "**Description:** A name intended for use in searching or matching.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "22618"
        }
      ]
    },
    {
      "code" : "_OrganizationNameUse",
      "display" : "OrganizationNameUse",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21078"
        }
      ]
    },
    {
      "code" : "_PersonNameUse",
      "display" : "PersonNameUse",
      "definition" : "A code indicating the type of name (e.g. nickname, alias, maiden name, legal, adopted)",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21079"
        }
      ]
    }
  ]
}

```
