# AcknowledgementDetailCode - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AcknowledgementDetailCode**

## CodeSystem: AcknowledgementDetailCode 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v3-AcknowledgementDetailCode | *Version*:3.0.0 | |
| Active as of 2019-03-20 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AcknowledgementDetailCode |
| *Other Identifiers:*OID:2.16.840.1.113883.5.1100 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
**OpenIssue:**Missing description. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AcknowledgementDetailCode](ValueSet-v3-AcknowledgementDetailCode.md)
* [AcknowledgementDetailNotSupportedCode](ValueSet-v3-AcknowledgementDetailNotSupportedCode.md)
* [AcknowledgementDetailSyntaxErrorCode](ValueSet-v3-AcknowledgementDetailSyntaxErrorCode.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v3-AcknowledgementDetailCode",
  "language" : "en",
  "url" : "http://terminology.hl7.org/CodeSystem/v3-AcknowledgementDetailCode",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.1100"
    }
  ],
  "version" : "3.0.0",
  "name" : "AcknowledgementDetailCode",
  "title" : "AcknowledgementDetailCode",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "*OpenIssue:*Missing description.",
  "copyright" : "This material derives from the HL7 Terminology THO. THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Specializes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Generalizes"
        }
      ],
      "code" : "Specializes",
      "description" : "The child code is a more narrow version of the concept represented by the parent code.  I.e. Every child concept is also a valid parent concept.  Used to allow determination of subsumption.  Must be transitive, irreflexive, antisymmetric.",
      "type" : "Coding"
    },
    {
      "extension" : [
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry",
          "valueCode" : "antisymmetric"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity",
          "valueCode" : "transitive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity",
          "valueCode" : "irreflexive"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable",
          "valueBoolean" : true
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind",
          "valueCode" : "Generalizes"
        },
        {
          "url" : "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName",
          "valueString" : "Specializes"
        }
      ],
      "code" : "Generalizes",
      "description" : "Inverse of Specializes.  Only included as a derived relationship.",
      "type" : "Coding"
    },
    {
      "code" : "internalId",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v3-internal-id",
      "description" : "The internal identifier for the concept in the HL7 Access database repository.",
      "type" : "code"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state.  Normally is not populated unless the state is retired..",
      "type" : "code"
    },
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Indicates that the code is abstract - only intended to be used as a selector for other concepts",
      "type" : "boolean"
    }
  ],
  "concept" : [
    {
      "code" : "_AcknowledgementDetailNotSupportedCode",
      "display" : "AcknowledgementDetailNotSupportedCode",
      "definition" : "Refelects rejections because elements of the communication are not supported in the current context.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21419"
        }
      ],
      "concept" : [
        {
          "code" : "NS200",
          "display" : "Unsupported interaction",
          "definition" : "The interaction (or: this version of the interaction) is not supported.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21420"
            }
          ]
        },
        {
          "code" : "NS202",
          "display" : "Unsupported processing id",
          "definition" : "The Processing ID is not supported.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21421"
            }
          ]
        },
        {
          "code" : "NS203",
          "display" : "Unsupported version id",
          "definition" : "The Version ID is not supported.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21423"
            }
          ]
        },
        {
          "code" : "NS250",
          "display" : "Unsupported processing Mode",
          "definition" : "The processing mode is not supported.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21422"
            }
          ]
        },
        {
          "code" : "NS260",
          "display" : "Unknown sender",
          "definition" : "The Device.id of the sender is unknown.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21424"
            }
          ]
        },
        {
          "code" : "NS261",
          "display" : "Unrecognized attentionline",
          "definition" : "The receiver requires information in the attentionLine classes for routing purposes.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21425"
            }
          ]
        }
      ]
    },
    {
      "code" : "INTERR",
      "display" : "Internal system error",
      "definition" : "An internal software component (database, application, queue mechanism, etc.) has failed, leading to inability to process the message.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22074"
        }
      ]
    },
    {
      "code" : "NOSTORE",
      "display" : "No storage space for message.",
      "definition" : "**Rejection:** The message can't be stored by the receiver due to an unspecified internal application issue. The message was neither processed nor stored by the receiving application.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21442"
        }
      ]
    },
    {
      "code" : "RTEDEST",
      "display" : "Message routing error, destination unreachable.",
      "definition" : "**Error:** The destination of this message is known to the receiving application. Messages have been successfully routed to that destination in the past. The link to the destination application or an intermediate application is unavailable.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21443"
        }
      ]
    },
    {
      "code" : "RTUDEST",
      "display" : "Error: Message routing error, unknown destination.",
      "definition" : "The destination of this message is unknown to the receiving application. The receiving application in the message does not match the application which received the message. The message was neither routed, processed nor stored by the receiving application.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21440"
        }
      ]
    },
    {
      "code" : "RTWDEST",
      "display" : "Message routing warning, destination unreachable.",
      "definition" : "**Warning:** The destination of this message is known to the receiving application. Messages have been successfully routed to that destination in the past. The link to the destination application or an intermediate application is (temporarily) unavailable. The receiving application will forward the message as soon as the destination can be reached again.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "21441"
        }
      ]
    },
    {
      "code" : "SYN",
      "display" : "Syntax error",
      "definition" : "Reflects errors in the syntax or structure of the communication.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "active"
        },
        {
          "code" : "internalId",
          "valueCode" : "22075"
        }
      ],
      "concept" : [
        {
          "code" : "SYN102",
          "display" : "Data type error",
          "definition" : "The attribute contained data of the wrong data type, e.g. a numeric attribute contained \"FOO\".",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "21414"
            }
          ]
        },
        {
          "code" : "SYN105",
          "display" : "Required element missing",
          "definition" : "**Description:** Required association or attribute missing in message; or the sequence of the classes is different than required by the standard or one of the conformance profiles identified in the message.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22747"
            }
          ],
          "concept" : [
            {
              "code" : "SYN100",
              "display" : "Required association missing",
              "definition" : "Required association missing in message; or the sequence of the classes is different than required by the standard or one of the conformance profiles identified in the message.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21412"
                }
              ]
            },
            {
              "code" : "SYN101",
              "display" : "Required attribute missing",
              "definition" : "A required attribute is missing in a class.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21413"
                }
              ]
            },
            {
              "code" : "SYN114",
              "display" : "Insufficient repetitions",
              "definition" : "**Description:** The number of repetitions of a group of association or attributes is less than the required minimum for the standard or of one of the conformance profiles or templates identified in the message.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22748"
                }
              ]
            }
          ]
        },
        {
          "code" : "SYN106",
          "display" : "Terminology error",
          "definition" : "**Description:** A coded attribute or datatype property violates one of the terminology constraints specified in the standard or one of the conformance profiles or templates declared by the instance.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22749"
            }
          ],
          "concept" : [
            {
              "code" : "SYN103",
              "display" : "Value not found in code system",
              "definition" : "An attribute value was compared against the corresponding code system, and no match was found.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21415"
                }
              ]
            },
            {
              "code" : "SYN104",
              "display" : "Invalid code system in CNE",
              "definition" : "An attribute value referenced a code system that is not valid for an attribute constrained to CNE.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21416"
                }
              ]
            },
            {
              "code" : "SYN107",
              "display" : "Deprecated code",
              "definition" : "**Description:** A coded attribute is referencing a code that has been deprecated by the owning code system.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "22750"
                }
              ]
            }
          ]
        },
        {
          "code" : "SYN108",
          "display" : "Number of repetitions exceeds limit",
          "definition" : "**Description:** The number of repetitions of a (group of) association(s) or attribute(s) exceeds the limits of the standard or of one of the conformance profiles or templates identified in the message.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22751"
            }
          ],
          "concept" : [
            {
              "code" : "SYN110",
              "display" : "Number of association repetitions exceeds limit",
              "definition" : "The number of repetitions of a (group of) association(s) exceeds the limits of the standard or of one of the conformance profiles identified in the message.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21417"
                }
              ]
            },
            {
              "code" : "SYN112",
              "display" : "Number of attribute repetitions exceeds limit",
              "definition" : "The number of repetitions of an attribute exceeds the limits of the standard or of one of the conformance profiles identified in the message.",
              "property" : [
                {
                  "code" : "status",
                  "valueCode" : "active"
                },
                {
                  "code" : "internalId",
                  "valueCode" : "21418"
                }
              ]
            }
          ]
        },
        {
          "code" : "SYN109",
          "display" : "Mandatory element with null value",
          "definition" : "**Description:** An attribute or association identified as mandatory in a specification or declared conformance profile or template has been specified with a null flavor.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22752"
            }
          ]
        },
        {
          "code" : "SYN111",
          "display" : "Value does not match fixed value",
          "definition" : "**Description:** The value of an attribute or property differs from the fixed value asserted in the standard or one of the conformance profiles or templates declared in the message.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22753"
            }
          ]
        },
        {
          "code" : "SYN113",
          "display" : "Formal constraint violation",
          "definition" : "**Description:** A formal constraint asserted in the standard or one of the conformance profiles or templates declared in the message has been violated.",
          "property" : [
            {
              "code" : "status",
              "valueCode" : "active"
            },
            {
              "code" : "internalId",
              "valueCode" : "22754"
            }
          ]
        }
      ]
    },
    {
      "code" : "_AcknowledgementDetailSyntaxErrorCode",
      "display" : "AcknowledgementDetailSyntaxErrorCode",
      "definition" : "Reflects errors in the syntax or structure of the communication.",
      "property" : [
        {
          "code" : "notSelectable",
          "valueBoolean" : true
        },
        {
          "code" : "status",
          "valueCode" : "retired"
        },
        {
          "code" : "internalId",
          "valueCode" : "21411"
        }
      ]
    }
  ]
}

```
