# drgStatusFinancialCalculation - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **drgStatusFinancialCalculation**

## CodeSystem: drgStatusFinancialCalculation 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0742 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:DrgStatusFinancialCalculation |
| *Other Identifiers:*OID:2.16.840.1.113883.18.395 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts specifying the status of the diagnosis related group (DRG) calculation regarding the financial aspects. US Realm. Used in HL7 Version 2.x messaging in the DRG segment. 

 
Underlying Master Code System for V2 table 0742 (DRG Status Financial Calculation) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSDrgStatusFinancialCalculation](ValueSet-v2-0742.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0742",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0742",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.395"
    }
  ],
  "version" : "2.0.0",
  "name" : "DrgStatusFinancialCalculation",
  "title" : "drgStatusFinancialCalculation",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the status of the diagnosis related group (DRG) calculation regarding the financial aspects.  US Realm. Used in HL7 Version 2.x messaging in the DRG segment.",
  "purpose" : "Underlying Master Code System for V2 table 0742 (DRG Status Financial Calculation)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0742",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#status",
      "description" : "Status of the concept",
      "type" : "code"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-property-valueset",
          "valueCanonical" : "http://terminology.hl7.org/ValueSet/v2-0104"
        }
      ],
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "6443",
      "code" : "00",
      "display" : "Effective weight calculated",
      "definition" : "Effective weight calculated",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "6444",
      "code" : "01",
      "display" : "Hospital specific contract",
      "definition" : "Hospital specific contract",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "6445",
      "code" : "03",
      "display" : "Eeffective weight for transfer/referral calculated",
      "definition" : "Eeffective weight for transfer/referral calculated",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "6446",
      "code" : "04",
      "display" : "Referral from other hospital based on a cooperation (no DRG reimbursement)",
      "definition" : "Referral from other hospital based on a cooperation (no DRG reimbursement)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "6447",
      "code" : "05",
      "display" : "Invalid length of stay",
      "definition" : "Invalid length of stay",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "6448",
      "code" : "10",
      "display" : "No information/entry in cost data for this DRG",
      "definition" : "No information/entry in cost data for this DRG",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "6449",
      "code" : "11",
      "display" : "No relative weight found for department (type)",
      "definition" : "No relative weight found for department (type)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    }
  ]
}

```
