# userAuthenticationCredentialType - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **userAuthenticationCredentialType**

## CodeSystem: userAuthenticationCredentialType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0615 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:UserAuthenticationCredentialType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.373 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts specifying a type of user authentication credential. Used in HL7 Version 2.x messaging in the UAC segment. 

 
Underlying Master Code System for V2 table 0615 (User Authentication Credential Type Code) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSUserAuthenticationCredentialTypeCode](ValueSet-v2-0615.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0615",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "inm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0615",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.373"
    }
  ],
  "version" : "2.0.0",
  "name" : "UserAuthenticationCredentialType",
  "title" : "userAuthenticationCredentialType",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying a type of user authentication credential.  Used in HL7 Version 2.x messaging in the UAC segment.",
  "purpose" : "Underlying Master Code System for V2 table 0615 (User Authentication Credential Type Code)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0615",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#status",
      "description" : "Status of the concept",
      "type" : "code"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-property-valueset",
          "valueCanonical" : "http://terminology.hl7.org/ValueSet/v2-0104"
        }
      ],
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "6253",
      "code" : "KERB",
      "display" : "Kerberos Service Ticket",
      "definition" : "Kerberos Service Ticket",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Structure defined by RFC 1510"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Structure defined by RFC 1510"
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "6254",
      "code" : "SAML",
      "display" : "Authenticated User Identity Assertion",
      "definition" : "Authenticated User Identity Assertion",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "XML structure defined by the OASIS Security Assertion Markup Language (SAML) specification"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "XML structure defined by the OASIS Security Assertion Markup Language (SAML) specification"
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    }
  ]
}

```
