# paymentMethod - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **paymentMethod**

## CodeSystem: paymentMethod 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0570 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:PaymentMethod |
| *Other Identifiers:*OID:2.16.840.1.113883.18.370 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts used to specify the method for the movement of payment. Used in the Payment Information (PMT) segment in HL7 Version 2.x messaging. 

 
Underlying Master Code System for V2 table 0570 (Payment Method Code) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSPaymentMethodCode](ValueSet-v2-0570.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0570",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0570",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.370"
    }
  ],
  "version" : "2.0.0",
  "name" : "PaymentMethod",
  "title" : "paymentMethod",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts used to specify the method for the movement of payment.  Used in the Payment Information (PMT) segment in HL7 Version 2.x messaging.",
  "purpose" : "Underlying Master Code System for V2 table 0570 (Payment Method Code)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0570",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#status",
      "description" : "Status of the concept",
      "type" : "code"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-property-valueset",
          "valueCanonical" : "http://terminology.hl7.org/ValueSet/v2-0104"
        }
      ],
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "6233",
      "code" : "CASH",
      "display" : "Cash",
      "definition" : "Cash",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "6234",
      "code" : "CCCA",
      "display" : "Credit Card",
      "definition" : "Credit Card",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "6235",
      "code" : "CCHK",
      "display" : "Cashier's Check",
      "definition" : "Cashier's Check",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "6236",
      "code" : "CDAC",
      "display" : "Credit/Debit Account",
      "definition" : "Credit/Debit Account",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "6237",
      "code" : "CHCK",
      "display" : "Check",
      "definition" : "Check",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "6238",
      "code" : "DDPO",
      "display" : "Direct Deposit",
      "definition" : "Direct Deposit",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "EFT"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "EFT"
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "6239",
      "code" : "DEBC",
      "display" : "Debit Card",
      "definition" : "Debit Card",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "6240",
      "code" : "SWFT",
      "display" : "Society for Worldwide Interbank Financial Telecommunications (S.W.I.F.T.)",
      "definition" : "Society for Worldwide Interbank Financial Telecommunications (S.W.I.F.T.)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "6241",
      "code" : "TRAC",
      "display" : "Traveler's Check",
      "definition" : "Traveler's Check",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "6242",
      "code" : "VISN",
      "display" : "VISA Special Electronic Funds Transfer Network",
      "definition" : "VISA Special Electronic Funds Transfer Network",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    }
  ]
}

```
