# signatorysRelationshipToSubject - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **signatorysRelationshipToSubject**

## CodeSystem: signatorysRelationshipToSubject 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0548 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SignatorysRelationshipToSubject |
| *Other Identifiers:*OID:2.16.840.1.113883.18.355 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts specifying the relationship of the consenter to the subject. Used in HL7 Version 2 messaging in the CON segment. 

 
Underlying Master Code System for V2 table 0548 (Signatory's Relationship to Subject) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSSignatorySRelationshipToSubject](ValueSet-v2-0548.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0548",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "sd"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0548",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.355"
    }
  ],
  "version" : "2.0.0",
  "name" : "SignatorysRelationshipToSubject",
  "title" : "signatorysRelationshipToSubject",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the relationship of the consenter to the subject.  Used in HL7 Version 2 messaging in the CON segment.",
  "purpose" : "Underlying Master Code System for V2 table 0548 (Signatory's Relationship to Subject)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0548",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#status",
      "description" : "Status of the concept",
      "type" : "code"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-property-valueset",
          "valueCanonical" : "http://terminology.hl7.org/ValueSet/v2-0104"
        }
      ],
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "5693",
      "code" : "1",
      "display" : "Self",
      "definition" : "Self",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "5694",
      "code" : "2",
      "display" : "Parent",
      "definition" : "Parent",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Eltern"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "5695",
      "code" : "3",
      "display" : "Next of Kin",
      "definition" : "Next of Kin",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "5696",
      "code" : "4",
      "display" : "Durable Power of Attorney in Healthcare Affairs",
      "definition" : "Durable Power of Attorney in Healthcare Affairs",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "5697",
      "code" : "5",
      "display" : "Conservator",
      "definition" : "Conservator",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "5698",
      "code" : "6",
      "display" : "Emergent Practitioner (practitioner judging case as emergency requiring care without a consent)",
      "definition" : "Emergent Practitioner (practitioner judging case as emergency requiring care without a consent)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "5699",
      "code" : "7",
      "display" : "Non-Emergent Practitioner (i.e. medical ethics committee)",
      "definition" : "Non-Emergent Practitioner (i.e. medical ethics committee)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    }
  ]
}

```
