# sequenceCondition - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **sequenceCondition**

## CodeSystem: sequenceCondition 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0524 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SequenceCondition |
| *Other Identifiers:*OID:2.16.840.1.113883.18.342 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts that identify whether sequence conditions or a repeating cycle of orders is defined. This is part of the Order Sequence Definition used in HL7 Version 2.x messaaging in the OSD datatype. 

 
Underlying Master Code System for V2 table 0524 (Sequence condition) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSSequenceCondition](ValueSet-v2-0524.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0524",
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0524",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.342"
    }
  ],
  "version" : "2.0.0",
  "name" : "SequenceCondition",
  "title" : "sequenceCondition",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts that identify whether sequence conditions or a repeating cycle of orders is defined.   This is part of the Order Sequence Definition used in HL7 Version 2.x messaaging in the OSD datatype.",
  "purpose" : "Underlying Master Code System for V2 table 0524 (Sequence condition)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0524",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#status",
      "description" : "Status of the concept",
      "type" : "code"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-property-valueset",
          "valueCanonical" : "http://terminology.hl7.org/ValueSet/v2-0104"
        }
      ],
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "5602",
      "code" : "S",
      "display" : "Sequence conditions",
      "definition" : "Sequence conditions",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "5603",
      "code" : "C",
      "display" : "Repeating cycle of orders",
      "definition" : "Repeating cycle of orders",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "5604",
      "code" : "R",
      "display" : "Reserved for possible future use",
      "definition" : "Reserved for possible future use",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    }
  ]
}

```
