# risks - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **risks**

## CodeSystem: risks 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0489 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:Risks |
| *Other Identifiers:*OID:2.16.840.1.113883.18.313 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts specifying any known or suspected specimen hazards, e.g., exceptionally infectious agent or blood from a hepatitis patient. Used in HL7 Version 2.x messaging in the SPM and PAC segments. 

 
Underlying Master Code System for V2 table 0489 (Risk Codes) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSRiskCodes](ValueSet-v2-0489.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0489",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0489",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.313"
    }
  ],
  "version" : "2.0.0",
  "name" : "Risks",
  "title" : "risks",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying any known or suspected specimen hazards, e.g., exceptionally infectious agent or blood from a hepatitis patient.  Used in HL7 Version 2.x messaging in the SPM and PAC segments.",
  "purpose" : "Underlying Master Code System for V2 table 0489 (Risk Codes)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0489",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#status",
      "description" : "Status of the concept",
      "type" : "code"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-property-valueset",
          "valueCanonical" : "http://terminology.hl7.org/ValueSet/v2-0104"
        }
      ],
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "5292",
      "code" : "BIO",
      "display" : "Biological",
      "definition" : "Biological",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "The dangers associated with normal biological materials. I.e. potential risk of unknown infections.  Routine biological materials from living subjects."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "The dangers associated with normal biological materials. I.e. potential risk of unknown infections.  Routine biological materials from living subjects."
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "5293",
      "code" : "COR",
      "display" : "Corrosive",
      "definition" : "Corrosive",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Material is corrosive and may cause severe injury to skin, mucous membranes and eyes. Avoid any unprotected contact."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Material is corrosive and may cause severe injury to skin, mucous membranes and eyes. Avoid any unprotected contact."
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "5294",
      "code" : "ESC",
      "display" : "Escape Risk",
      "definition" : "Escape Risk",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "The entity is at risk for escaping from containment or control."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "The entity is at risk for escaping from containment or control."
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "5295",
      "code" : "AGG",
      "display" : "Aggressive",
      "definition" : "Aggressive",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "A danger that can be associated with certain living subjects, including humans."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "A danger that can be associated with certain living subjects, including humans."
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "5296",
      "code" : "IFL",
      "display" : "MaterialDangerInflammable",
      "definition" : "MaterialDangerInflammable",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Material is highly inflammable and in certain mixtures (with air) may lead to explosions.  Keep away from fire, sparks and excessive heat."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Material is highly inflammable and in certain mixtures (with air) may lead to explosions.  Keep away from fire, sparks and excessive heat."
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "5297",
      "code" : "EXP",
      "display" : "Explosive",
      "definition" : "Explosive",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Material is an explosive mixture.  Keep away from fire, sparks, and heat."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Material is an explosive mixture.  Keep away from fire, sparks, and heat."
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "5298",
      "code" : "INF",
      "display" : "MaterialDangerInfectious",
      "definition" : "MaterialDangerInfectious",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Material known to be infectious with human pathogenic microorganisms.  Those who handle this material must take precautions for their protection."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Material known to be infectious with human pathogenic microorganisms.  Those who handle this material must take precautions for their protection."
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "5299",
      "code" : "BHZ",
      "display" : "Biohazard",
      "definition" : "Biohazard",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Material contains microorganisms that are an environmental hazard.  Must be handled with special care."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Material contains microorganisms that are an environmental hazard.  Must be handled with special care."
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "5300",
      "code" : "INJ",
      "display" : "Injury Hazard",
      "definition" : "Injury Hazard",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Material is solid and sharp (e.g., cannulas.)  Dispose in hard container."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Material is solid and sharp (e.g., cannulas.)  Dispose in hard container."
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "5301",
      "code" : "POI",
      "display" : "Poison",
      "definition" : "Poison",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Material is poisonous to humans and/or animals.  Special care must be taken to avoid incorporation, even of small amounts."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Material is poisonous to humans and/or animals.  Special care must be taken to avoid incorporation, even of small amounts."
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "5302",
      "code" : "RAD",
      "display" : "Radioactive",
      "definition" : "Radioactive",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Material is a source for ionizing radiation and must be handled with special care to avoid injury of those who handle it and to avoid environmental hazards."
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "Material is a source for ionizing radiation and must be handled with special care to avoid injury of those who handle it and to avoid environmental hazards."
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    }
  ]
}

```
