# packagingStatus - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **packagingStatus**

## CodeSystem: packagingStatus 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0469 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:PackagingStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.18.298 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts specifying the packaging status of the service. Used in HL7 Version 2.x messaging in the GP2 segment. 

 
Underlying Master Code System for V2 table 0469 (Packaging Status Code) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSPackagingStatusCode](ValueSet-v2-0469.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0469",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0469",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.298"
    }
  ],
  "version" : "2.0.0",
  "name" : "PackagingStatus",
  "title" : "packagingStatus",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the packaging status of the service.  Used in HL7 Version 2.x messaging in the GP2 segment.",
  "purpose" : "Underlying Master Code System for V2 table 0469 (Packaging Status Code)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0469",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#status",
      "description" : "Status of the concept",
      "type" : "code"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-property-valueset",
          "valueCanonical" : "http://terminology.hl7.org/ValueSet/v2-0104"
        }
      ],
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "4856",
      "code" : "0",
      "display" : "Not packaged",
      "definition" : "Not packaged",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "4857",
      "code" : "1",
      "display" : "Packaged service (status indicator N, or no HCPCS code and certain revenue codes)",
      "definition" : "Packaged service (status indicator N, or no HCPCS code and certain revenue codes)",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "4858",
      "code" : "2",
      "display" : "Packaged as part of partial hospitalization per diem or daily mental health service per diem",
      "definition" : "Packaged as part of partial hospitalization per diem or daily mental health service per diem",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    }
  ]
}

```
