# ambulatoryPaymentClassification - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ambulatoryPaymentClassification**

## CodeSystem: ambulatoryPaymentClassification 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0466 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:AmbulatoryPaymentClassification |
| *Other Identifiers:*OID:2.16.840.1.113883.18.296 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts specifying the derived Ambulatory Payment Classification (APC) code. Used in HL7 Version 2.x messaging in the GP2 segment. 

 
Underlying Master Code System for V2 table 0466 (Ambulatory Payment Classification Code) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSAmbulatoryPaymentClassificationCode](ValueSet-v2-0466.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0466",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0466",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.296"
    }
  ],
  "version" : "2.0.0",
  "name" : "AmbulatoryPaymentClassification",
  "title" : "ambulatoryPaymentClassification",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the derived Ambulatory Payment Classification (APC) code.  Used in HL7 Version 2.x messaging in the GP2 segment.",
  "purpose" : "Underlying Master Code System for V2 table 0466 (Ambulatory Payment Classification Code)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0466",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#status",
      "description" : "Status of the concept",
      "type" : "code"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-property-valueset",
          "valueCanonical" : "http://terminology.hl7.org/ValueSet/v2-0104"
        }
      ],
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "4847",
      "code" : "031",
      "display" : "Dental procedures",
      "definition" : "Dental procedures",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "4848",
      "code" : "163",
      "display" : "Excision/biopsy",
      "definition" : "Excision/biopsy",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "4849",
      "code" : "181",
      "display" : "Level 1 skin repair.",
      "definition" : "Level 1 skin repair.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "4850",
      "code" : "...",
      "display" : "No suggested values defined",
      "definition" : "No suggested values defined",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "keine Werte vorgeschlagen"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "D"
        }
      ]
    }
  ]
}

```
