# providerRole - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **providerRole**

## CodeSystem: providerRole 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0443 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ProviderRole |
| *Other Identifiers:*OID:2.16.840.1.113883.18.283 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Code system of concepts specifying the functional involvement with the activity being transmitted (e.g., Case Manager, Evaluator, Transcriber, Nurse Care Practitioner, Midwife, Physician Assistant, etc.). Used in HL7 Version 2.x messaging in the ROL segment. 

 
Underlying Master Code System for V2 table 0443 (Provider Role) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSProviderRole](ValueSet-v2-0443.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0443",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0443",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.283"
    }
  ],
  "version" : "2.0.0",
  "name" : "ProviderRole",
  "title" : "providerRole",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the functional involvement with the activity being transmitted (e.g., Case Manager, Evaluator, Transcriber, Nurse Care Practitioner, Midwife, Physician Assistant, etc.).  Used in HL7 Version 2.x messaging in the ROL segment.",
  "purpose" : "Underlying Master Code System for V2 table 0443 (Provider Role)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0443",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#status",
      "description" : "Status of the concept",
      "type" : "code"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-property-valueset",
          "valueCanonical" : "http://terminology.hl7.org/ValueSet/v2-0104"
        }
      ],
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "4794",
      "code" : "AD",
      "display" : "Admitting",
      "definition" : "Admitting",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Aufnehmender Arzt"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "PV1-17 Admitting doctor"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "PV1-17 Admitting doctor"
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "4795",
      "code" : "AP",
      "display" : "Administering Provider",
      "definition" : "Administering Provider",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "RXA-10 Administering Provider"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "RXA-10 Administering Provider"
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "4796",
      "code" : "AT",
      "display" : "Attending",
      "definition" : "Attending",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Behandelnder Arzt"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "PV1-7 Attending doctor"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "PV1-7 Attending doctor"
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "4797",
      "code" : "CLP",
      "display" : "Collecting Provider",
      "definition" : "Collecting Provider",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "OBR-10 Collector Identifier"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "OBR-10 Collector Identifier"
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "4798",
      "code" : "CP",
      "display" : "Consulting Provider",
      "definition" : "Consulting Provider",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Beratender Arzt"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "4799",
      "code" : "DP",
      "display" : "Dispensing Provider",
      "definition" : "Dispensing Provider",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "RXD-10 Dispensing Provider"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "RXD-10 Dispensing Provider"
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "4800",
      "code" : "EP",
      "display" : "Entering Provider (probably not the same as transcriptionist?)",
      "definition" : "Entering Provider (probably not the same as transcriptionist?)",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "ORC-10 Entered By"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "ORC-10 Entered By"
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "4801",
      "code" : "FHCP",
      "display" : "Family Health Care Professional",
      "definition" : "Family Health Care Professional",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Hausarzt"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "4802",
      "code" : "IP",
      "display" : "Initiating Provider (as in action by)",
      "definition" : "Initiating Provider (as in action by)",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "ORC-19 Action By"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "ORC-19 Action By"
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "4803",
      "code" : "MDIR",
      "display" : "Medical Director",
      "definition" : "Medical Director",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "OBX-25 Performing Organization Medical Director"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "OBX-25 Performing Organization Medical Director"
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "4804",
      "code" : "OP",
      "display" : "Ordering Provider",
      "definition" : "Ordering Provider",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "ORC-12 Ordering Provider, OBR-16 Ordering Provider, RXO-14 Ordering Provider's DEA Number, RXE-13 Ordering Provider's DEA Number, ORC-24 Ordering Provider Address"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "ORC-12 Ordering Provider, OBR-16 Ordering Provider, RXO-14 Ordering Provider's DEA Number, RXE-13 Ordering Provider's DEA Number, ORC-24 Ordering Provider Address"
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "4805",
      "code" : "PH",
      "display" : "Pharmacist   (not sure how to dissect Pharmacist/Treatment Supplier's Verifier ID)",
      "definition" : "Pharmacist   (not sure how to dissect Pharmacist/Treatment Supplier's Verifier ID)",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "RXE-14 Pharmacist/Treatment Supplier's Verifier ID"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "RXE-14 Pharmacist/Treatment Supplier's Verifier ID"
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "4806",
      "code" : "PP",
      "display" : "Primary Care Provider",
      "definition" : "Primary Care Provider",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Durchgangsarzt"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "4807",
      "code" : "RO",
      "display" : "Responsible Observer",
      "definition" : "Responsible Observer",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "OBX-16 Responsible Observer"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "OBX-16 Responsible Observer"
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "4808",
      "code" : "RP",
      "display" : "Referring Provider",
      "definition" : "Referring Provider",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "überweisender/einweisender Arzt"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "PV1-8 Referring doctor"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "PV1-8 Referring doctor"
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "4809",
      "code" : "RT",
      "display" : "Referred to Provider",
      "definition" : "Referred to Provider",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Überweisungsempfänger"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "4810",
      "code" : "TR",
      "display" : "Transcriptionist",
      "definition" : "Transcriptionist",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Schreibkraft"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "4811",
      "code" : "PI",
      "display" : "Primary Interpreter",
      "definition" : "Primary Interpreter",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Verantwortlicher Übersetzer"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "4812",
      "code" : "AI",
      "display" : "Assistant/Alternate Interpreter",
      "definition" : "Assistant/Alternate Interpreter",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "alternativer (oder Assistent des) Befundsarzt"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "4813",
      "code" : "TN",
      "display" : "Technician",
      "definition" : "Technician",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "MTA"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "4814",
      "code" : "VP",
      "display" : "Verifying Provider",
      "definition" : "Verifying Provider",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "ORC-11 Verified By"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "ORC-11 Verified By"
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "4815",
      "code" : "VPS",
      "display" : "Verifying Pharmaceutical Supplier   (not sure how to dissect Pharmacist/Treatment Supplier's Verifier ID)",
      "definition" : "Verifying Pharmaceutical Supplier   (not sure how to dissect Pharmacist/Treatment Supplier's Verifier ID)",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "RXE-14 Pharmacist/Treatment Supplier's Verifier ID"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "RXE-14 Pharmacist/Treatment Supplier's Verifier ID"
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "4816",
      "code" : "VTS",
      "display" : "Verifying Treatment Supplier   (not sure how to dissect Pharmacist/Treatment Supplier's Verifier ID)",
      "definition" : "Verifying Treatment Supplier   (not sure how to dissect Pharmacist/Treatment Supplier's Verifier ID)",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "RXE-14 Pharmacist/Treatment Supplier's Verifier ID"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "RXE-14 Pharmacist/Treatment Supplier's Verifier ID"
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    }
  ]
}

```
