# substanceType - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **substanceType**

## CodeSystem: substanceType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0384 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:SubstanceType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.237 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts identifying the type of substance. Used in HL7 Version 2.x messaging in the Inventory Detail (INV) segment. 

 
Underlying Master Code System for V2 table 0384 (Substance Type) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSSubstanceType](ValueSet-v2-0384.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0384",
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0384",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.237"
    }
  ],
  "version" : "2.0.0",
  "name" : "SubstanceType",
  "title" : "substanceType",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined  code system of concepts identifying the type of substance.  Used in HL7 Version 2.x messaging in the Inventory Detail (INV) segment.",
  "purpose" : "Underlying Master Code System for V2 table 0384 (Substance Type)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0384",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#status",
      "description" : "Status of the concept",
      "type" : "code"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-property-valueset",
          "valueCanonical" : "http://terminology.hl7.org/ValueSet/v2-0104"
        }
      ],
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "v2-concCommentAsPub",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concCommentAsPub",
      "description" : "V2 Concept Comment As Published",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "3841",
      "code" : "SR",
      "display" : "Single Test Reagent",
      "definition" : "Single Test Reagent",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "3842",
      "code" : "MR",
      "display" : "Multiple Test Reagent",
      "definition" : "Multiple Test Reagent",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "The consumption cannot be tied to orders for a single test"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "The consumption cannot be tied to orders for a single test"
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "3843",
      "code" : "DI",
      "display" : "Diluent",
      "definition" : "Diluent",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "3844",
      "code" : "PT",
      "display" : "Pretreatment",
      "definition" : "Pretreatment",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "3845",
      "code" : "RC",
      "display" : "Reagent Calibrator",
      "definition" : "Reagent Calibrator",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "3846",
      "code" : "CO",
      "display" : "Control Reagent",
      "definition" : "Control Reagent",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "3847",
      "code" : "PW",
      "display" : "Purified Water",
      "definition" : "Purified Water",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "3848",
      "code" : "LW",
      "display" : "Liquid Waste",
      "definition" : "Liquid Waste",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "3849",
      "code" : "SW",
      "display" : "Solid Waste",
      "definition" : "Solid Waste",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "3850",
      "code" : "SC",
      "display" : "Countable Solid Item",
      "definition" : "Countable Solid Item",
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "E.g., Pipetting tip"
        },
        {
          "code" : "v2-concCommentAsPub",
          "valueString" : "E.g., Pipetting tip"
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "3851",
      "code" : "LI",
      "display" : "Measurable Liquid Item",
      "definition" : "Measurable Liquid Item",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "3852",
      "code" : "OT",
      "display" : "Other",
      "definition" : "Other",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    }
  ]
}

```
