# causalityObservations - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **causalityObservations**

## CodeSystem: causalityObservations 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0252 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:CausalityObservations |
| *Other Identifiers:*OID:2.16.840.1.113883.18.147 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts used to record event observations regarding what may have caused a product related event. Used in HL7 Version 2.x messaging in the PCR segment. 

 
Underlying Master Code System for V2 table 0252 (Causality Observations) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSCausalityObservations](ValueSet-v2-0252.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0252",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0252",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.147"
    }
  ],
  "version" : "2.0.0",
  "name" : "CausalityObservations",
  "title" : "causalityObservations",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts used to record event observations regarding what may have caused a product related event.  Used in HL7 Version 2.x messaging in the PCR segment.",
  "purpose" : "Underlying Master Code System for V2 table 0252 (Causality Observations)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0252",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#status",
      "description" : "Status of the concept",
      "type" : "code"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-property-valueset",
          "valueCanonical" : "http://terminology.hl7.org/ValueSet/v2-0104"
        }
      ],
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "id" : "2368",
      "code" : "AW",
      "display" : "Abatement of event after product withdrawn",
      "definition" : "Abatement of event after product withdrawn",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "2369",
      "code" : "BE",
      "display" : "Event recurred after product reintroduced",
      "definition" : "Event recurred after product reintroduced",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "2370",
      "code" : "LI",
      "display" : "Literature reports association of product with event",
      "definition" : "Literature reports association of product with event",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "2371",
      "code" : "IN",
      "display" : "Event occurred after product introduced",
      "definition" : "Event occurred after product introduced",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "2372",
      "code" : "EX",
      "display" : "Alternative explanations for the event available",
      "definition" : "Alternative explanations for the event available",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "2373",
      "code" : "PL",
      "display" : "Effect observed when patient receives placebo",
      "definition" : "Effect observed when patient receives placebo",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "2374",
      "code" : "TC",
      "display" : "Toxic levels of product documented in blood or body fluids",
      "definition" : "Toxic levels of product documented in blood or body fluids",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "2375",
      "code" : "DR",
      "display" : "Dose response observed",
      "definition" : "Dose response observed",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "2376",
      "code" : "SE",
      "display" : "Similar events in past for this patient",
      "definition" : "Similar events in past for this patient",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "2377",
      "code" : "OE",
      "display" : "Occurrence of event was confirmed by objective evidence",
      "definition" : "Occurrence of event was confirmed by objective evidence",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "2378",
      "code" : "OT",
      "display" : "Other",
      "definition" : "Other",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    }
  ]
}

```
