# resultStatus - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **resultStatus**

## CodeSystem: resultStatus 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/v2-0123 | *Version*:2.0.0 | |
| Active as of 2019-12-01 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ResultStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.18.51 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
HL7-defined code system of concepts which specify a status of results for an order. Used in HL7 Version 2.x messaging in the OBR segment. 

 
Underlying Master Code System for V2 table 0123 (Result Status) 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSResultStatusObr](ValueSet-v2-0123.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "v2-0123",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/v2-0123",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.51"
    }
  ],
  "version" : "2.0.0",
  "name" : "ResultStatus",
  "title" : "resultStatus",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-12-01",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts which specify a status of results for an order.  Used in HL7 Version 2.x messaging in the OBR segment.",
  "purpose" : "Underlying Master Code System for V2 table 0123 (Result Status)",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0123",
  "hierarchyMeaning" : "is-a",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#status",
      "description" : "Status of the concept",
      "type" : "code"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-property-valueset",
          "valueCanonical" : "http://terminology.hl7.org/ValueSet/v2-0104"
        }
      ],
      "code" : "v2-table-deprecated",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-table-deprecated",
      "description" : "Version of HL7 in which the code was deprecated",
      "type" : "code"
    },
    {
      "code" : "v2-concComment",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#v2-concComment",
      "description" : "V2 Concept Comment",
      "type" : "string"
    },
    {
      "code" : "HL7usageNotes",
      "uri" : "http://terminology.hl7.org/CodeSystem/utg-concept-properties#HL7usageNotes",
      "description" : "HL7 Concept Usage Notes",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "id" : "1430",
      "code" : "O",
      "display" : "Order received; specimen not yet received",
      "definition" : "Order received; specimen not yet received",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Auftrag erhalten - Probe steht noch aus"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "1431",
      "code" : "I",
      "display" : "No results available; specimen received, procedure incomplete",
      "definition" : "No results available; specimen received, procedure incomplete",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Keine Ergebnisse - Probe liegt vor, Untersuchung unvollständig"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "1432",
      "code" : "S",
      "display" : "No results available; procedure scheduled, but not done",
      "definition" : "No results available; procedure scheduled, but not done",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Keine Ergebnisse - Untersuchung eingeplant, aber noch nicht durchgeführt"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "1433",
      "code" : "A",
      "display" : "Some, but not all, results available",
      "definition" : "Some, but not all, results available",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "einige, aber nicht alle Ergebnisse verfügbar"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "1434",
      "code" : "P",
      "display" : "Preliminary",
      "definition" : "A verified early result is available, final results not yet obtained",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Vorläufig - Validiertes Zwischenergebnis liegt vor, aber noch keine endgültigen"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "1435",
      "code" : "C",
      "display" : "Corrected, final",
      "definition" : "A result under an order, that has been finalized has been corrected",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "korrigiertes Ergebnis, final"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "1436",
      "code" : "R",
      "display" : "Results stored; not yet verified",
      "definition" : "Results stored; not yet verified",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Ergebnisse gespeichert, aber noch nicht validiert"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "1437",
      "code" : "F",
      "display" : "Final results",
      "definition" : "Final results; results stored and verified.",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Endergebnis - Auftrag erledigt, Ergebnisse validiert"
        }
      ],
      "property" : [
        {
          "code" : "v2-concComment",
          "valueString" : "Can only be changed with a corrected result."
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "1438",
      "code" : "X",
      "display" : "No results available; Order canceled",
      "definition" : "No results available; Order canceled.",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Keine Ergebnisse - Auftrag storniert"
        }
      ],
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "1439",
      "code" : "Y",
      "display" : "No order on record for this test",
      "definition" : "No order on record for this test.",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Kein Auftrag zu dieser Untersuchung"
        }
      ],
      "property" : [
        {
          "code" : "HL7usageNotes",
          "valueString" : "Used only on queries"
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "1440",
      "code" : "Z",
      "display" : "No record of this patient",
      "definition" : "No record of this patient.",
      "designation" : [
        {
          "language" : "de",
          "use" : {
            "system" : "http://terminology.hl7.org/CodeSystem/hl7TermMaintInfra",
            "code" : "preferredForLanguage"
          },
          "value" : "Keine Daten über diesen Patienten"
        }
      ],
      "property" : [
        {
          "code" : "HL7usageNotes",
          "valueString" : "Used only on queries"
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "1441",
      "code" : "M",
      "display" : "Corrected, not final",
      "definition" : "A result under an order, that has not yet been finalized has been corrected",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    },
    {
      "id" : "1442",
      "code" : "N",
      "display" : "Procedure completed, results pending",
      "definition" : "No result available; requested procedure done.  To indicate that a requested test is performed but results are pending/not yet available.",
      "property" : [
        {
          "code" : "HL7usageNotes",
          "valueString" : "Transitions/Relationships: \nOBR-25  Valid preceding state (... to N): O, I, S.  Succeeding state (N to ...): P, A, R, F, X\nOBX-11  No OBX segments can be present where OBX-29 = RSLT"
        },
        {
          "code" : "status",
          "valueCode" : "A"
        }
      ]
    }
  ]
}

```
