# ResearchSubjectMilestone - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ResearchSubjectMilestone**

## CodeSystem: ResearchSubjectMilestone 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/research-subject-milestone | *Version*:1.0.1 | | |
| Active as of 2024-04-24 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ResearchSubjectMilestone |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.0 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
Indicates the progression of a study subject through the study milestones. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ResearchSubjectMilestone](ValueSet-research-subject-milestone.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "research-subject-milestone",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "brr"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/research-subject-milestone",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.0"
    }
  ],
  "version" : "1.0.1",
  "name" : "ResearchSubjectMilestone",
  "title" : "ResearchSubjectMilestone",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Indicates the progression of a study subject through the study milestones.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/research-subject-milestone",
  "content" : "complete",
  "concept" : [
    {
      "code" : "SignedUp",
      "display" : "Signed up",
      "definition" : "A person has expressed an interest in being in a study but has not yet been through any assessment or consent processes."
    },
    {
      "code" : "Screened",
      "display" : "Screened",
      "definition" : "A potential subject has been screened for suitability."
    },
    {
      "code" : "Randomized",
      "display" : "Randomized",
      "definition" : "A subject has been allocated to an arm of the study."
    }
  ]
}

```
