# ResearchStudyObjectiveType - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ResearchStudyObjectiveType**

## CodeSystem: ResearchStudyObjectiveType 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/research-study-objective-type | *Version*:1.0.0 | |
| Draft as of 2020-04-09 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ResearchStudyObjectiveType |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1248 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | |

 
Codes for the kind of study objective. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ResearchStudyObjectiveType](ValueSet-research-study-objective-type.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "research-study-objective-type",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "brr"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/research-study-objective-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1248"
    }
  ],
  "version" : "1.0.0",
  "name" : "ResearchStudyObjectiveType",
  "title" : "ResearchStudyObjectiveType",
  "status" : "draft",
  "experimental" : false,
  "date" : "2020-04-09T21:10:28+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "Codes for the kind of study objective.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/research-study-objective-type",
  "content" : "complete",
  "concept" : [
    {
      "code" : "primary",
      "display" : "Primary",
      "definition" : "The main question to be answered, and the one that drives any statistical planning for the study—e.g., calculation of the sample size to provide the appropriate power for statistical testing."
    },
    {
      "code" : "secondary",
      "display" : "Secondary",
      "definition" : "Question to be answered in the study that is of lesser importance than the primary objective."
    },
    {
      "code" : "exploratory",
      "display" : "Exploratory",
      "definition" : "Exploratory questions to be answered in the study."
    }
  ]
}

```
