# Observation Reference Range Meaning Codes - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Observation Reference Range Meaning Codes**

## CodeSystem: Observation Reference Range Meaning Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/referencerange-meaning | *Version*:1.0.1 | |
| Active as of 2025-11-13 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:ObservationReferenceRangeMeaningCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1124 | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | |

 
This value set defines a set of codes that can be used to indicate the meaning/use of a reference range for a particular target population. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ObservationReferenceRangeMeaningCodes](ValueSet-referencerange-meaning.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "referencerange-meaning",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "oo"
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/referencerange-meaning",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1124"
    }
  ],
  "version" : "1.0.1",
  "name" : "ObservationReferenceRangeMeaningCodes",
  "title" : "Observation Reference Range Meaning Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-13T08:03:09+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set defines a set of codes that can be used to indicate the meaning/use of a reference range for a particular target population.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/referencerange-meaning",
  "hierarchyMeaning" : "is-a",
  "content" : "complete",
  "property" : [
    {
      "code" : "abstract",
      "description" : "True if an element is considered 'abstract' - in otherwords, the code is not for use as a real concept",
      "type" : "boolean"
    }
  ],
  "concept" : [
    {
      "code" : "type",
      "display" : "Type",
      "definition" : "General types of reference range.",
      "property" : [
        {
          "code" : "abstract",
          "valueBoolean" : true
        }
      ],
      "concept" : [
        {
          "code" : "normal",
          "display" : "Normal Range",
          "definition" : "Values expected for a normal member of the relevant control population being measured. Typically each results producer such as a laboratory has specific normal ranges and they are usually defined as within two standard deviations from the mean and account for 95.45% of this population."
        },
        {
          "code" : "recommended",
          "display" : "Recommended Range",
          "definition" : "The range that is recommended by a relevant professional body."
        },
        {
          "code" : "treatment",
          "display" : "Treatment Range",
          "definition" : "The range at which treatment would/should be considered."
        },
        {
          "code" : "therapeutic",
          "display" : "Therapeutic Desired Level",
          "definition" : "The optimal range for best therapeutic outcomes.",
          "concept" : [
            {
              "code" : "pre",
              "display" : "Pre Therapeutic Desired Level",
              "definition" : "The optimal range for best therapeutic outcomes for a specimen taken immediately before administration."
            },
            {
              "code" : "post",
              "display" : "Post Therapeutic Desired Level",
              "definition" : "The optimal range for best therapeutic outcomes for a specimen taken immediately after administration."
            }
          ]
        }
      ]
    },
    {
      "code" : "endocrine",
      "display" : "Endocrine",
      "definition" : "Endocrine related states that change the expected value.",
      "property" : [
        {
          "code" : "abstract",
          "valueBoolean" : true
        }
      ],
      "concept" : [
        {
          "code" : "pre-puberty",
          "display" : "Pre-Puberty",
          "definition" : "An expected range in an individual prior to puberty."
        },
        {
          "code" : "follicular",
          "display" : "Follicular Stage",
          "definition" : "An expected range in an individual during the follicular stage of the cycle."
        },
        {
          "code" : "midcycle",
          "display" : "MidCycle",
          "definition" : "An expected range in an individual during the midcycle stage of the cycle."
        },
        {
          "code" : "luteal",
          "display" : "Luteal",
          "definition" : "An expected range in an individual during the luteal stage of the cycle."
        },
        {
          "code" : "postmenopausal",
          "display" : "Post-Menopause",
          "definition" : "An expected range in an individual post-menopause."
        }
      ]
    }
  ]
}

```
