# Practitioner role - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Practitioner role**

## CodeSystem: Practitioner role 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/practitioner-role | *Version*:1.0.1 | | |
| Active as of 2025-11-13 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:PractitionerRole |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1132 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This example value set defines a set of codes that can be used to indicate the role of a Practitioner. 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "practitioner-role",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pa"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/practitioner-role",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1132"
    }
  ],
  "version" : "1.0.1",
  "name" : "PractitionerRole",
  "title" : "Practitioner role",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-13T08:03:09+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This example value set defines a set of codes that can be used to indicate the role of a Practitioner.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "content" : "complete",
  "concept" : [
    {
      "code" : "doctor",
      "display" : "Doctor",
      "definition" : "A qualified/registered medical practitioner"
    },
    {
      "code" : "nurse",
      "display" : "Nurse",
      "definition" : "A practitioner with nursing experience that may be qualified/registered"
    },
    {
      "code" : "pharmacist",
      "display" : "Pharmacist",
      "definition" : "A qualified/registered/licensed pharmacist"
    },
    {
      "code" : "researcher",
      "display" : "Researcher",
      "definition" : "A practitioner that may perform research"
    },
    {
      "code" : "teacher",
      "display" : "Teacher/educator",
      "definition" : "Someone who is able to provide educational services"
    },
    {
      "code" : "ict",
      "display" : "ICT professional",
      "definition" : "Someone who is qualified in Information and Communication Technologies"
    }
  ]
}

```
