# MedicationUsage Administration Location Codes - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationUsage Administration Location Codes**

## CodeSystem: MedicationUsage Administration Location Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/medication-usage-admin-location | *Version*:1.0.0 | | |
| Draft as of 2025-11-13 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:MedicationUsageAdministrationLocationCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.0 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
MedicationUsage Administration Location Codes 

 This Code system is referenced in the content logical definition of the following value sets: 

* [MedicationUsageAdministrationLocation](ValueSet-medication-usage-admin-location.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "medication-usage-admin-location",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "phx"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/medication-usage-admin-location",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.0"
    }
  ],
  "version" : "1.0.0",
  "name" : "MedicationUsageAdministrationLocationCodes",
  "title" : "MedicationUsage Administration Location Codes",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-11-13T08:03:09+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "MedicationUsage Administration Location Codes",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/medication-usage-admin-location",
  "content" : "complete",
  "concept" : [
    {
      "code" : "inpatient",
      "display" : "Inpatient",
      "definition" : "Includes orders for medications to be administered or consumed in an inpatient or acute care setting"
    },
    {
      "code" : "outpatient",
      "display" : "Outpatient",
      "definition" : "Includes orders for medications to be administered or consumed in an outpatient setting (for example, Emergency Department, Outpatient Clinic, Outpatient Surgery, Doctor's office)"
    },
    {
      "code" : "community",
      "display" : "Community",
      "definition" : "Includes orders for medications to be administered or consumed by the patient in their home (this would include long term care or nursing homes, hospices, etc.)."
    }
  ]
}

```
