# MeasureType - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MeasureType**

## CodeSystem: MeasureType 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/measure-type | *Version*:3.0.1 | | |
| Active as of 2024-04-24 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 2 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:MeasureType |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1233 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
The type of measure (includes codes from 2.16.840.1.113883.1.11.20368). 

 This Code system is referenced in the content logical definition of the following value sets: 

* [MeasureType](ValueSet-measure-type.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "measure-type",
  "meta" : {
    "lastUpdated" : "2024-04-24T00:00:00+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/measure-type",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1233"
    }
  ],
  "version" : "3.0.1",
  "name" : "MeasureType",
  "title" : "MeasureType",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-24T00:00:00+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "The type of measure (includes codes from 2.16.840.1.113883.1.11.20368).",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/measure-type",
  "content" : "complete",
  "property" : [
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "Designation of a concept's state. Normally is not populated unless the state is retired.",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "process",
      "display" : "Process",
      "definition" : "A measure which focuses on a process which leads to a certain outcome, meaning that a scientific basis exists for believing that the process, when executed well, will increase the probability of achieving a desired outcome."
    },
    {
      "code" : "outcome",
      "display" : "Outcome",
      "definition" : "A measure that indicates the result of the performance (or non-performance) of a function or process."
    },
    {
      "code" : "structure",
      "display" : "Structure",
      "definition" : "A measure that focuses on a health care provider's capacity, systems, and processes to provide high-quality care."
    },
    {
      "code" : "patient-reported-outcome",
      "display" : "Patient Reported Outcome",
      "definition" : "A measure that focuses on patient-reported information such as patient engagement or patient experience measures."
    },
    {
      "code" : "composite",
      "display" : "Composite",
      "definition" : "A measure that combines multiple component measures in to a single quality measure.",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "retired"
        }
      ]
    }
  ]
}

```
