# Oral Site Codes - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Oral Site Codes**

## CodeSystem: Oral Site Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/ex-tooth | *Version*:1.0.0 | | |
| Draft as of 2025-11-13 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:OralSiteCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.4.642.1.1152 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html | | | |

 
This value set includes a smattering of FDI oral site codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [OralSiteCodes](ValueSet-tooth.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "ex-tooth",
  "meta" : {
    "lastUpdated" : "2020-04-09T21:10:28.568+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/ex-tooth",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.1.1152"
    }
  ],
  "version" : "1.0.0",
  "name" : "OralSiteCodes",
  "title" : "Oral Site Codes",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-11-13T08:03:09+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set includes a smattering of FDI oral site codes.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license.html",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/tooth",
  "content" : "complete",
  "concept" : [
    {
      "code" : "0",
      "display" : "Oral cavity",
      "definition" : "Oral cavity."
    },
    {
      "code" : "1",
      "display" : "1",
      "definition" : "Permanent teeth Maxillary right."
    },
    {
      "code" : "2",
      "display" : "2",
      "definition" : "Permanent teeth Maxillary left."
    },
    {
      "code" : "3",
      "display" : "3",
      "definition" : "Permanent teeth Mandibular right."
    },
    {
      "code" : "4",
      "display" : "4",
      "definition" : "Permanent teeth Mandibular left."
    },
    {
      "code" : "5",
      "display" : "5",
      "definition" : "Deciduous teeth Maxillary right."
    },
    {
      "code" : "6",
      "display" : "6",
      "definition" : "Deciduous teeth Maxillary left."
    },
    {
      "code" : "7",
      "display" : "7",
      "definition" : "Deciduous teeth Mandibular right."
    },
    {
      "code" : "8",
      "display" : "8",
      "definition" : "Deciduous teeth Mandibular left."
    },
    {
      "code" : "11",
      "display" : "11",
      "definition" : "Upper Right Tooth 1 from the central axis, permanent dentition."
    },
    {
      "code" : "12",
      "display" : "12",
      "definition" : "Upper Right Tooth 2 from the central axis, permanent dentition."
    },
    {
      "code" : "13",
      "display" : "13",
      "definition" : "Upper Right Tooth 3 from the central axis, permanent dentition."
    },
    {
      "code" : "14",
      "display" : "14",
      "definition" : "Upper Right Tooth 4 from the central axis, permanent dentition."
    },
    {
      "code" : "15",
      "display" : "15",
      "definition" : "Upper Right Tooth 5 from the central axis, permanent dentition."
    },
    {
      "code" : "16",
      "display" : "16",
      "definition" : "Upper Right Tooth 6 from the central axis, permanent dentition."
    },
    {
      "code" : "17",
      "display" : "17",
      "definition" : "Upper Right Tooth 7 from the central axis, permanent dentition."
    },
    {
      "code" : "18",
      "display" : "18",
      "definition" : "Upper Right Tooth 8 from the central axis, permanent dentition."
    },
    {
      "code" : "21",
      "display" : "21",
      "definition" : "Upper Left Tooth 1 from the central axis, permanent dentition."
    },
    {
      "code" : "22",
      "display" : "22",
      "definition" : "Upper Left Tooth 2 from the central axis, permanent dentition."
    },
    {
      "code" : "23",
      "display" : "23",
      "definition" : "Upper Left Tooth 3 from the central axis, permanent dentition."
    },
    {
      "code" : "24",
      "display" : "24",
      "definition" : "Upper Left Tooth 4 from the central axis, permanent dentition."
    },
    {
      "code" : "25",
      "display" : "25",
      "definition" : "Upper Left Tooth 5 from the central axis, permanent dentition."
    },
    {
      "code" : "26",
      "display" : "26",
      "definition" : "Upper Left Tooth 6 from the central axis, permanent dentition."
    },
    {
      "code" : "27",
      "display" : "27",
      "definition" : "Upper Left Tooth 7 from the central axis, permanent dentition."
    },
    {
      "code" : "28",
      "display" : "28",
      "definition" : "Upper Left Tooth 8 from the central axis, permanent dentition."
    },
    {
      "code" : "31",
      "display" : "31",
      "definition" : "Lower Left Tooth 1 from the central axis, permanent dentition."
    },
    {
      "code" : "32",
      "display" : "32",
      "definition" : "Lower Left Tooth 2 from the central axis, permanent dentition."
    },
    {
      "code" : "33",
      "display" : "33",
      "definition" : "Lower Left Tooth 3 from the central axis, permanent dentition."
    },
    {
      "code" : "34",
      "display" : "34",
      "definition" : "Lower Left Tooth 4 from the central axis, permanent dentition."
    },
    {
      "code" : "35",
      "display" : "35",
      "definition" : "Lower Left Tooth 5 from the central axis, permanent dentition."
    },
    {
      "code" : "36",
      "display" : "36",
      "definition" : "Lower Left Tooth 6 from the central axis, permanent dentition."
    },
    {
      "code" : "37",
      "display" : "37",
      "definition" : "Lower Left Tooth 7 from the central axis, permanent dentition."
    },
    {
      "code" : "38",
      "display" : "38",
      "definition" : "Lower Left Tooth 8 from the central axis, permanent dentition."
    },
    {
      "code" : "41",
      "display" : "41",
      "definition" : "Lower Right Tooth 1 from the central axis, permanent dentition."
    },
    {
      "code" : "42",
      "display" : "42",
      "definition" : "Lower Right Tooth 2 from the central axis, permanent dentition."
    },
    {
      "code" : "43",
      "display" : "43",
      "definition" : "Lower Right Tooth 3 from the central axis, permanent dentition."
    },
    {
      "code" : "44",
      "display" : "44",
      "definition" : "Lower Right Tooth 4 from the central axis, permanent dentition."
    },
    {
      "code" : "45",
      "display" : "45",
      "definition" : "Lower Right Tooth 5 from the central axis, permanent dentition."
    },
    {
      "code" : "46",
      "display" : "46",
      "definition" : "Lower Right Tooth 6 from the central axis, permanent dentition."
    },
    {
      "code" : "47",
      "display" : "47",
      "definition" : "Lower Right Tooth 7 from the central axis, permanent dentition."
    },
    {
      "code" : "48",
      "display" : "48",
      "definition" : "Lower Right Tooth 8 from the central axis, permanent dentition."
    }
  ]
}

```
