# Diagnosis Type Codes - HL7 Terminology (THO) v6.5.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Diagnosis Type Codes**

## CodeSystem: Diagnosis Type Codes 

| | | | |
| :--- | :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org/CodeSystem/diagnosistype | *Version*:1.0.0 | | |
| Active as of 2025-11-13 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Responsible:*[Health Level Seven International](http://hl7.org) | *Computable Name*:DiagnosisTypeCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.5.174 | | | |
| **Copyright/Legal**: This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license | | | |

 
This value set includes Diagnosis Type codes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [DiagnosisTypeCodes](ValueSet-diagnosistype.md)

-------

**History**



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "diagnosistype",
  "meta" : {
    "lastUpdated" : "2025-05-25T00:00:00+00:00",
    "profile" : [
      "http://hl7.org/fhir/StructureDefinition/shareablecodesystem"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "fm"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://terminology.hl7.org/CodeSystem/diagnosistype",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.5.174"
    }
  ],
  "version" : "1.0.0",
  "name" : "DiagnosisTypeCodes",
  "title" : "Diagnosis Type Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-11-13T08:03:09+00:00",
  "publisher" : "Health Level Seven International",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.org"
        },
        {
          "system" : "email",
          "value" : "hq@HL7.org"
        }
      ]
    }
  ],
  "description" : "This value set includes Diagnosis Type codes.",
  "copyright" : "This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: https://terminology.hl7.org/license",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org/ValueSet/diagnosistype",
  "content" : "complete",
  "concept" : [
    {
      "code" : "admitting",
      "display" : "Admitting Diagnosis",
      "definition" : "The diagnosis given as the reason why the patient was admitted to the hospital."
    },
    {
      "code" : "clinical",
      "display" : "Clinical Diagnosis",
      "definition" : "A diagnosis made on the basis of medical signs and patient-reported symptoms, rather than diagnostic tests."
    },
    {
      "code" : "differential",
      "display" : "Differential Diagnosis",
      "definition" : "One of a set of the possible diagnoses that could be connected to the signs, symptoms, and lab findings."
    },
    {
      "code" : "discharge",
      "display" : "Discharge Diagnosis",
      "definition" : "The diagnosis given when the patient is discharged from the hospital."
    },
    {
      "code" : "laboratory",
      "display" : "Laboratory Diagnosis",
      "definition" : "A diagnosis based significantly on laboratory reports or test results, rather than the physical examination of the patient."
    },
    {
      "code" : "nursing",
      "display" : "Nursing Diagnosis",
      "definition" : "A diagnosis which identifies people's responses to situations in their lives, such as a readiness to change or a willingness to accept assistance."
    },
    {
      "code" : "prenatal",
      "display" : "Prenatal Diagnosis",
      "definition" : "A diagnosis determined prior to birth."
    },
    {
      "code" : "principal",
      "display" : "Principal Diagnosis",
      "definition" : "The single medical diagnosis that is most relevant to the patient's chief complaint or need for treatment."
    },
    {
      "code" : "radiology",
      "display" : "Radiology Diagnosis",
      "definition" : "A diagnosis based primarily on the results from medical imaging studies."
    },
    {
      "code" : "remote",
      "display" : "Remote Diagnosis",
      "definition" : "A diagnosis determined using telemedicine techniques."
    },
    {
      "code" : "retrospective",
      "display" : "Retrospective Diagnosis",
      "definition" : "The labeling of an illness in a specific historical event using modern knowledge, methods and disease classifications."
    },
    {
      "code" : "secondary",
      "display" : "Secondary Diagnosis",
      "definition" : "A condition or complaint either coexisting with the principal diagnosis or arising during a service event or episode."
    },
    {
      "code" : "externalcauseofinjury",
      "display" : "External Cause of Injury",
      "definition" : "A condition or diagnosis caused by a factor outside the body that directly results in a physical injury, poisoning, or other adverse health condition."
    },
    {
      "code" : "patientreported",
      "display" : "Patient Reported Diagnosis",
      "definition" : "A condition or diagnosis reported by the patient."
    },
    {
      "code" : "patientreasonforvisit",
      "display" : "Patient Reason For Visit",
      "definition" : "Identifies the patient's reason for a visit."
    }
  ]
}

```
